/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.metadata.makernotes;

import com.lightcrafts.image.BadImageFileException;
import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.metadata.ImageMetaTagInfo;
import com.lightcrafts.image.metadata.ImageMetaTags;
import com.lightcrafts.image.metadata.ImageMetaType;
import com.lightcrafts.image.metadata.MetadataUtil;
import com.lightcrafts.image.metadata.makernotes.MakerNotesDirectory;
import com.lightcrafts.image.metadata.makernotes.MinoltaTags;
import com.lightcrafts.image.metadata.providers.FocalLengthProvider;
import com.lightcrafts.image.metadata.providers.LensProvider;
import com.lightcrafts.image.metadata.providers.PreviewImageProvider;
import com.lightcrafts.image.metadata.providers.ShutterSpeedProvider;
import com.lightcrafts.image.metadata.values.DateMetaValue;
import com.lightcrafts.image.metadata.values.FloatMetaValue;
import com.lightcrafts.image.metadata.values.ImageMetaValue;
import com.lightcrafts.image.metadata.values.LongMetaValue;
import com.lightcrafts.image.metadata.values.StringMetaValue;
import com.lightcrafts.image.types.JPEGImageType;
import com.lightcrafts.utils.NumberUtil;
import com.lightcrafts.utils.TextUtil;
import com.lightcrafts.utils.bytebuffer.ArrayByteBuffer;
import com.lightcrafts.utils.bytebuffer.LCByteBuffer;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public final class MinoltaDirectory
extends MakerNotesDirectory
implements FocalLengthProvider,
LensProvider,
ShutterSpeedProvider,
PreviewImageProvider {
    private static final ResourceBundle m_tagBundle = ResourceBundle.getBundle("com.lightcrafts.image.metadata.makernotes.MinoltaTags");
    private static final Map<Integer, ImageMetaTagInfo> m_tagsByID = new HashMap<Integer, ImageMetaTagInfo>();
    private static final Map<String, ImageMetaTagInfo> m_tagsByName = new HashMap<String, ImageMetaTagInfo>();

    @Override
    public float getFocalLength() {
        ImageMetaValue value = this.getValue(786);
        return value != null ? value.getFloatValue() : 0.0f;
    }

    @Override
    public String getLens() {
        return MinoltaDirectory.hasTagValueLabelFor(this.getValue(268));
    }

    @Override
    public String getName() {
        return "Minolta";
    }

    @Override
    public RenderedImage getPreviewImage(ImageInfo imageInfo, int maxWidth, int maxHeight) throws BadImageFileException, IOException {
        ImageMetaValue offsetValue = this.getValue(136);
        ImageMetaValue lengthValue = this.getValue(137);
        if (offsetValue == null || lengthValue == null) {
            return null;
        }
        int offset = offsetValue.getIntValue();
        int length = lengthValue.getIntValue();
        if (offset <= 0 || length <= 0) {
            return null;
        }
        byte[] buf = imageInfo.getByteBuffer().getBytes(offset + 1 + 1 + 1 + 1 + 2 + 6, length);
        if (buf[1] == -40 && buf[2] == -1) {
            buf[0] = -1;
        }
        return JPEGImageType.getImageFromBuffer((LCByteBuffer)new ArrayByteBuffer(buf), new LongMetaValue(0L), 0, lengthValue, maxWidth, maxHeight);
    }

    @Override
    public float getShutterSpeed() {
        ImageMetaValue value = this.getValue(777);
        return value != null ? value.getFloatValue() : 0.0f;
    }

    @Override
    public ImageMetaTagInfo getTagInfoFor(Integer id) {
        return m_tagsByID.get(id);
    }

    @Override
    public ImageMetaTagInfo getTagInfoFor(String name) {
        return m_tagsByName.get(name);
    }

    @Override
    public void putValue(Integer tagID, ImageMetaValue value) {
        switch (tagID) {
            case 3: {
                String model = this.getOwningMetadata().getCameraMake(true);
                if (model != null && model.contains("DIMAGE X31")) break;
            }
            case 1: {
                this.explodeSubfields(tagID, 0, value, true);
                break;
            }
            case 64: {
                if (value.getLongValue() != 0L) break;
                return;
            }
            case 778: 
            case 791: {
                int n = value.getIntValue();
                value = new FloatMetaValue((float)NumberUtil.tenths(Math.pow(2.0, (double)n / 16.0 - 0.5)));
                break;
            }
            case 818: {
                int n = value.getIntValue();
                value = new FloatMetaValue((float)NumberUtil.tenths((double)n / 8.0 - 6.0));
                break;
            }
            case 786: 
            case 796: 
            case 797: 
            case 798: {
                int n = value.getIntValue();
                value = new FloatMetaValue((float)NumberUtil.tenths((double)n / 256.0));
                break;
            }
            case 825: {
                String model = this.getOwningMetadata().getCameraMake(true);
                if (model != null && !model.contains("DIMAGE 7HI")) break;
            }
            case 789: {
                long n = value.getLongValue();
                StringBuilder sb = new StringBuilder();
                sb.append((n & 0xFFFFFFFFFFFF0000L) >> 16);
                sb.append(TextUtil.zeroPad((int)((n & 0xFF00L) >> 8), 10, 2));
                sb.append(TextUtil.zeroPad((int)(n & 0xFFL), 10, 2));
                try {
                    value = new DateMetaValue(sb.toString());
                    break;
                }
                catch (IllegalArgumentException e) {
                    return;
                }
            }
            case 781: {
                int n = value.getIntValue();
                value = new FloatMetaValue((float)NumberUtil.tenths((double)n / 3.0 - 2.0));
                break;
            }
            case 803: {
                int n = value.getIntValue();
                value = new FloatMetaValue((float)NumberUtil.tenths((double)(n - 6) / 3.0));
                break;
            }
            case 776: {
                int n = value.getIntValue();
                value = new FloatMetaValue((float)NumberUtil.tenths(Math.pow(2.0, ((double)n / 8.0 - 1.0) * 3.125)));
                break;
            }
            case 777: {
                int n = value.getIntValue();
                value = new FloatMetaValue((float)Math.pow(2.0, (double)(48 - n) / 8.0));
                break;
            }
            case 790: {
                long n = value.getLongValue();
                StringBuilder sb = new StringBuilder();
                sb.append(TextUtil.zeroPad((int)((n & 0xFF0000L) >> 16), 10, 2));
                sb.append(':');
                sb.append(TextUtil.zeroPad((int)((n & 0xFF00L) >> 8), 10, 2));
                sb.append(':');
                sb.append(TextUtil.zeroPad((int)(n & 0xFFL), 10, 2));
                value = new StringMetaValue(sb.toString());
                break;
            }
            case 259: {
                return;
            }
        }
        super.putValue(tagID, value);
    }

    @Override
    public String valueToString(ImageMetaValue value) {
        switch (value.getOwningTagID()) {
            case 64: {
                return TextUtil.quantify(value.getLongValue());
            }
            case 786: {
                return value.getStringValue() + "mm";
            }
            case 787: {
                int n = value.getIntValue();
                return n > 0 ? TextUtil.tenths((double)n / 1000.0) : "infinite";
            }
            case 777: {
                return MetadataUtil.shutterSpeedString(value.getFloatValue());
            }
            case 268: {
                String label = this.hasTagValueLabelFor(268);
                return label != null ? label : "unknown";
            }
        }
        return super.valueToString(value);
    }

    @Override
    protected ResourceBundle getTagLabelBundle() {
        return m_tagBundle;
    }

    @Override
    protected Class<? extends ImageMetaTags> getTagsInterface() {
        return MinoltaTags.class;
    }

    private static void add(int id, String name, ImageMetaType type) {
        ImageMetaTagInfo tagInfo = new ImageMetaTagInfo(id, name, type, false);
        m_tagsByID.put(id, tagInfo);
        m_tagsByName.put(name, tagInfo);
    }

    static {
        MinoltaDirectory.add(3, "CameraSettings", ImageMetaType.META_UNDEFINED);
        MinoltaDirectory.add(1, "CameraSettingsOld", ImageMetaType.META_UNDEFINED);
        MinoltaDirectory.add(257, "ColorMode", ImageMetaType.META_ULONG);
        MinoltaDirectory.add(64, "CompressedImageSize", ImageMetaType.META_ULONG);
        MinoltaDirectory.add(778, "CSAperture", ImageMetaType.META_UNKNOWN);
        MinoltaDirectory.add(782, "CSBracketStep", ImageMetaType.META_UNKNOWN);
        MinoltaDirectory.add(818, "CSBrightness", ImageMetaType.META_UNKNOWN);
        MinoltaDirectory.add(816, "CSBWFilter", ImageMetaType.META_UNKNOWN);
        MinoltaDirectory.add(798, "CSColorBalanceBlue", ImageMetaType.META_UNKNOWN);
        MinoltaDirectory.add(797, "CSColorBalanceGreen", ImageMetaType.META_UNKNOWN);
        MinoltaDirectory.add(796, "CSColorBalanceRed", ImageMetaType.META_UNKNOWN);
        MinoltaDirectory.add(809, "CSColorFilter", ImageMetaType.META_UNKNOWN);
        MinoltaDirectory.add(808, "CSColorMode", ImageMetaType.META_UNKNOWN);
        MinoltaDirectory.add(825, "CSColorProfile", ImageMetaType.META_UNKNOWN);
        MinoltaDirectory.add(800, "CSContrast", ImageMetaType.META_UNKNOWN);
        MinoltaDirectory.add(789, "CSDate", ImageMetaType.META_DATE);
        MinoltaDirectory.add(824, "CSDecPosition", ImageMetaType.META_UNKNOWN);
        MinoltaDirectory.add(780, "CSDigitalZoom", ImageMetaType.META_UNKNOWN);
        MinoltaDirectory.add(774, "CSDriveMode", ImageMetaType.META_UNKNOWN);
        MinoltaDirectory.add(781, "CSExposureCompensation", ImageMetaType.META_UNKNOWN);
        MinoltaDirectory.add(769, "CSExposureMode", ImageMetaType.META_UNKNOWN);
        MinoltaDirectory.add(794, "CSFileNumberMemory", ImageMetaType.META_UNKNOWN);
        MinoltaDirectory.add(803, "CSFlashExposureComp", ImageMetaType.META_UNKNOWN);
        MinoltaDirectory.add(788, "CSFlashFired", ImageMetaType.META_UNKNOWN);
        MinoltaDirectory.add(770, "CSFlashMode", ImageMetaType.META_UNKNOWN);
        MinoltaDirectory.add(786, "CSFocalLength", ImageMetaType.META_UNKNOWN);
        MinoltaDirectory.add(823, "CSFocusArea", ImageMetaType.META_UNKNOWN);
        MinoltaDirectory.add(787, "CSFocusDistance", ImageMetaType.META_UNKNOWN);
        MinoltaDirectory.add(822, "CSFocusMode", ImageMetaType.META_UNKNOWN);
        MinoltaDirectory.add(807, "CSFolderName", ImageMetaType.META_UNKNOWN);
        MinoltaDirectory.add(772, "CSImageSize", ImageMetaType.META_UNKNOWN);
        MinoltaDirectory.add(817, "CSInternalFlash", ImageMetaType.META_UNKNOWN);
        MinoltaDirectory.add(784, "CSIntervalLength", ImageMetaType.META_UNKNOWN);
        MinoltaDirectory.add(806, "CSIntervalMode", ImageMetaType.META_UNKNOWN);
        MinoltaDirectory.add(785, "CSIntervalNumber", ImageMetaType.META_UNKNOWN);
        MinoltaDirectory.add(776, "CSISO", ImageMetaType.META_UNKNOWN);
        MinoltaDirectory.add(804, "CSISOSetting", ImageMetaType.META_UNKNOWN);
        MinoltaDirectory.add(795, "CSLastFileNumber", ImageMetaType.META_UNKNOWN);
        MinoltaDirectory.add(779, "CSMacroMode", ImageMetaType.META_UNKNOWN);
        MinoltaDirectory.add(791, "CSMaxAperture", ImageMetaType.META_UNKNOWN);
        MinoltaDirectory.add(775, "CSMeteringMode", ImageMetaType.META_UNKNOWN);
        MinoltaDirectory.add(805, "CSModel", ImageMetaType.META_UNKNOWN);
        MinoltaDirectory.add(773, "CSQuality", ImageMetaType.META_UNKNOWN);
        MinoltaDirectory.add(799, "CSSaturation", ImageMetaType.META_UNKNOWN);
        MinoltaDirectory.add(801, "CSSharpness", ImageMetaType.META_UNKNOWN);
        MinoltaDirectory.add(777, "CSShutterSpeed", ImageMetaType.META_UNKNOWN);
        MinoltaDirectory.add(819, "CSSpotFocusX", ImageMetaType.META_UNKNOWN);
        MinoltaDirectory.add(820, "CSSpotFocusY", ImageMetaType.META_UNKNOWN);
        MinoltaDirectory.add(802, "CSSubjectProgram", ImageMetaType.META_UNKNOWN);
        MinoltaDirectory.add(790, "CSTime", ImageMetaType.META_UNKNOWN);
        MinoltaDirectory.add(771, "CSWhiteBalance", ImageMetaType.META_UNKNOWN);
        MinoltaDirectory.add(821, "CSWideFocusZone", ImageMetaType.META_UNKNOWN);
        MinoltaDirectory.add(259, "ImageSize", ImageMetaType.META_ULONG);
        MinoltaDirectory.add(263, "ImageStabilization", ImageMetaType.META_ULONG);
        MinoltaDirectory.add(268, "LensID", ImageMetaType.META_ULONG);
        MinoltaDirectory.add(0, "MakerNotesVersion", ImageMetaType.META_UNKNOWN);
        MinoltaDirectory.add(137, "PreviewImageLength", ImageMetaType.META_ULONG);
        MinoltaDirectory.add(136, "PreviewImageStart", ImageMetaType.META_ULONG);
        MinoltaDirectory.add(258, "Quality", ImageMetaType.META_ULONG);
        MinoltaDirectory.add(259, "Quality2", ImageMetaType.META_ULONG);
        MinoltaDirectory.add(256, "SceneMode", ImageMetaType.META_ULONG);
        MinoltaDirectory.add(266, "ZoneMatching", ImageMetaType.META_ULONG);
    }
}

