/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.metadata.makernotes;

import com.lightcrafts.image.BadImageFileException;
import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.UnknownImageTypeException;
import com.lightcrafts.image.metadata.ImageMetaTagInfo;
import com.lightcrafts.image.metadata.ImageMetaTags;
import com.lightcrafts.image.metadata.ImageMetaType;
import com.lightcrafts.image.metadata.makernotes.MakerNotesDirectory;
import com.lightcrafts.image.metadata.makernotes.NikonTags;
import com.lightcrafts.image.metadata.providers.FocalLengthProvider;
import com.lightcrafts.image.metadata.providers.ISOProvider;
import com.lightcrafts.image.metadata.providers.ImageMetadataProvider;
import com.lightcrafts.image.metadata.providers.LensProvider;
import com.lightcrafts.image.metadata.providers.PreviewImageProvider;
import com.lightcrafts.image.metadata.values.FloatMetaValue;
import com.lightcrafts.image.metadata.values.ImageMetaValue;
import com.lightcrafts.image.metadata.values.LongMetaValue;
import com.lightcrafts.image.metadata.values.StringMetaValue;
import com.lightcrafts.image.metadata.values.UndefinedMetaValue;
import com.lightcrafts.image.metadata.values.UnsignedByteMetaValue;
import com.lightcrafts.image.metadata.values.UnsignedLongMetaValue;
import com.lightcrafts.image.metadata.values.UnsignedShortMetaValue;
import com.lightcrafts.image.types.NEFImageType;
import com.lightcrafts.utils.NumberUtil;
import com.lightcrafts.utils.TextUtil;
import com.lightcrafts.utils.bytebuffer.LCByteBuffer;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public final class NikonDirectory
extends MakerNotesDirectory
implements FocalLengthProvider,
ISOProvider,
LensProvider,
PreviewImageProvider {
    private int m_decryptCount;
    private static final byte[][] m_decrypt = new byte[][]{{-63, -65, 109, 13, 89, -59, 19, -99, -125, 97, 107, 79, -57, 127, 61, 61, 83, 89, -29, -57, -23, 47, -107, -89, -107, 31, -33, 127, 43, 41, -57, 13, -33, 7, -17, 113, -119, 61, 19, 61, 59, 19, -5, 13, -119, -63, 101, 31, -77, 13, 107, 41, -29, -5, -17, -93, 107, 71, 127, -107, 53, -89, 71, 79, -57, -15, 89, -107, 53, 17, 41, 97, -15, 61, -77, 43, 13, 67, -119, -63, -99, -99, -119, 101, -15, -23, -33, -65, 61, 127, 83, -105, -27, -23, -107, 23, 29, 61, -117, -5, -57, -29, 103, -89, 7, -15, 113, -89, 83, -75, 41, -119, -27, 43, -89, 23, 41, -23, 79, -59, 101, 109, 107, -17, 13, -119, 73, 47, -77, 67, 83, 101, 29, 73, -93, 19, -119, 89, -17, 107, -17, 101, 29, 11, 89, 19, -29, 79, -99, -77, 41, 67, 43, 7, 29, -107, 89, 89, 71, -5, -27, -23, 97, 71, 47, 53, 127, 23, 127, -17, 127, -107, -107, 113, -45, -93, 11, 113, -93, -83, 11, 59, -75, -5, -93, -65, 79, -125, 29, -83, -23, 47, 113, 101, -93, -27, 7, 53, 61, 13, -75, -23, -27, 71, 59, -99, -17, 53, -93, -65, -77, -33, 83, -45, -105, 83, 73, 113, 7, 53, 97, 113, 47, 67, 47, 17, -33, 23, -105, -5, -107, 59, 127, 107, -45, 37, -65, -83, -57, -59, -59, -75, -117, -17, 47, -45, 7, 107, 37, 73, -107, 37, 73, 109, 113, -57}, {-89, -68, -55, -83, -111, -33, -123, -27, -44, 120, -43, 23, 70, 124, 41, 76, 77, 3, -23, 37, 104, 17, -122, -77, -67, -9, 111, 97, 34, -94, 38, 52, 42, -66, 30, 70, 20, 104, -99, 68, 24, -62, 64, -12, 126, 95, 27, -83, 11, -108, -74, 103, -76, 11, -31, -22, -107, -100, 102, -36, -25, 93, 108, 5, -38, -43, -33, 122, -17, -10, -37, 31, -126, 76, -64, 104, 71, -95, -67, -18, 57, 80, 86, 74, -35, -33, -91, -8, -58, -38, -54, -112, -54, 1, 66, -99, -117, 12, 115, 67, 117, 5, -108, -34, 36, -77, -128, 52, -27, 44, -36, -101, 63, -54, 51, 69, -48, -37, 95, -11, 82, -61, 33, -38, -30, 34, 114, 107, 62, -48, 91, -88, -121, -116, 6, 93, 15, -35, 9, 25, -109, -48, -71, -4, -117, 15, -124, 96, 51, 28, -101, 69, -15, -16, -93, -108, 58, 18, 119, 51, 77, 68, 120, 40, 60, -98, -3, 101, 87, 22, -108, 107, -5, 89, -48, -56, 34, 54, -37, -46, 99, -104, 67, -95, 4, -121, -122, -9, -90, 38, -69, -42, 89, 77, -65, 106, 46, -86, 43, -17, -26, 120, -74, 78, -32, 47, -36, 124, -66, 87, 25, 50, 126, 42, -48, -72, -70, 41, 0, 60, 82, 125, -88, 73, 59, 45, -21, 37, 73, -6, -93, -86, 57, -89, -59, -89, 80, 17, 54, -5, -58, 103, 74, -11, -91, 18, 101, 126, -80, -33, -81, 78, -77, 97, 127, 47}};
    private static final ResourceBundle m_tagBundle = ResourceBundle.getBundle("com.lightcrafts.image.metadata.makernotes.NikonTags");
    private static final Map<Integer, ImageMetaTagInfo> m_tagsByID = new HashMap<Integer, ImageMetaTagInfo>();
    private static final Map<String, ImageMetaTagInfo> m_tagsByName = new HashMap<String, ImageMetaTagInfo>();

    @Override
    public float getFocalLength() {
        ImageMetaValue value = this.getValue(9969930);
        return value != null ? value.getFloatValue() : 0.0f;
    }

    @Override
    public int getISO() {
        ImageMetaValue value = this.getValue(2);
        if (value == null) {
            value = this.getValue(15);
        }
        if (value == null) {
            value = this.getValue(19);
        }
        if (value == null) {
            value = this.getValue(9478);
        }
        if (value == null) {
            value = this.getValue(9472);
        }
        return value != null ? value.getIntValue() : 0;
    }

    @Override
    public String getLens() {
        ImageMetaValue lensValue = this.getLensData(9965574, 9969931);
        String label = NikonDirectory.hasTagValueLabelFor(9965574, lensValue);
        if (label != null) {
            return label;
        }
        lensValue = this.getValue(132);
        if (lensValue != null) {
            return lensValue.toString();
        }
        return NikonDirectory.makeLensLabelFrom(this.getLensData(9965576, 9969933), this.getLensData(9965577, 9969934), null);
    }

    @Override
    public int[] getMakerNotesAdjustments(LCByteBuffer buf, int offset) throws IOException {
        byte[] header = buf.getBytes(offset, 7);
        if (Arrays.equals(header, "Nikon\u0000\u0002".getBytes("ASCII"))) {
            return new int[]{18, offset + 10};
        }
        if (Arrays.equals(header, "Nikon\u0000\u0001".getBytes("ASCII"))) {
            return new int[]{8, 0};
        }
        return null;
    }

    @Override
    public String getName() {
        return "Nikon";
    }

    @Override
    public RenderedImage getPreviewImage(ImageInfo imageInfo, int maxWidth, int maxHeight) throws BadImageFileException, IOException, UnknownImageTypeException {
        return NEFImageType.INSTANCE.getPreviewImage(imageInfo, maxWidth, maxHeight);
    }

    @Override
    public ImageMetaTagInfo getTagInfoFor(Integer id) {
        return m_tagsByID.get(id);
    }

    @Override
    public ImageMetaTagInfo getTagInfoFor(String name) {
        return m_tagsByName.get(name);
    }

    @Override
    public void putValue(Integer tagID, ImageMetaValue value) {
        block0 : switch (tagID) {
            case 2: 
            case 15: 
            case 19: {
                if (!(value instanceof UnsignedShortMetaValue)) {
                    return;
                }
                long[] values = ((LongMetaValue)value).getLongValues();
                if (values.length <= 1) break;
                value = new UnsignedShortMetaValue((int)values[1]);
                break;
            }
            case 37: {
                byte[] data = ((UndefinedMetaValue)value).getUndefinedValue();
                this.explodeSubfields(tagID, data, 0);
                return;
            }
            case 9472: 
            case 9478: {
                double n = value.getIntValue();
                int iso = (int)(100.0 * Math.pow(2.0, n / 12.0 - 5.0) + 0.5);
                if (iso <= 0) {
                    return;
                }
                value = new UnsignedLongMetaValue(iso);
                break;
            }
            case 9969925: 
            case 9969935: 
            case 9969936: 
            case 9969938: {
                short n = value.getUnsignedByteValue();
                value = new FloatMetaValue((float)NumberUtil.tenths(Math.pow(2.0, (double)n / 24.0)));
                break;
            }
            case 9965576: 
            case 9965577: 
            case 9969930: {
                short n = value.getUnsignedByteValue();
                value = new FloatMetaValue((float)NumberUtil.tenths(5.0 * Math.pow(2.0, (double)n / 24.0)));
                break;
            }
            case 9969929: {
                if (!(value instanceof UnsignedByteMetaValue)) break;
                short n = value.getUnsignedByteValue();
                value = new StringMetaValue(TextUtil.tenths(Math.pow(10.0, (double)n / 40.0)) + "cm");
                break;
            }
            case 9969932: {
                short n = value.getUnsignedByteValue();
                value = new FloatMetaValue((float)NumberUtil.tenths((double)n / 12.0));
                break;
            }
            case 152: {
                byte[] data = ((UndefinedMetaValue)value).getUndefinedValue();
                byte[] versionBuf = new byte[4];
                System.arraycopy(data, 0, versionBuf, 0, 4);
                int version = versionBuf[0] - 48 << 12 | versionBuf[1] - 48 << 8 | versionBuf[2] - 48 << 4 | versionBuf[3] - 48;
                super.putValue(0x980000, new UnsignedShortMetaValue(version));
                switch (version) {
                    case 256: 
                    case 257: {
                        this.explodeSubfields(tagID << 8 | 0x10, data, 4);
                        break;
                    }
                    case 513: {
                        ++this.m_decryptCount;
                        break block0;
                    }
                }
                return;
            }
            case 131: {
                if (!(value instanceof UnsignedByteMetaValue)) break;
                short lensType = value.getUnsignedByteValue();
                String[] labels = this.explodeBits(tagID, lensType);
                value = new StringMetaValue(labels);
                break;
            }
            case 29: 
            case 167: {
                ++this.m_decryptCount;
                break;
            }
            case 137: {
                if (!value.isNumeric()) break;
                int shootingMode = value.getIntValue();
                if ((shootingMode & 0x87) == 0) {
                    shootingMode = shootingMode == 0 ? 8 : (shootingMode |= 8);
                }
                String[] labels = this.explodeBits(tagID, shootingMode);
                value = new StringMetaValue(labels);
            }
        }
        super.putValue(tagID, value);
        if (this.m_decryptCount == 3) {
            byte[] lensData = ((UndefinedMetaValue)this.removeValue(152)).getUndefinedValue();
            long serialNumber = this.getValue(29).getLongValue();
            long shutterCount = this.getValue(167).getLongValue();
            NikonDirectory.decrypt(lensData, 4, serialNumber, shutterCount);
            this.m_decryptCount = Integer.MIN_VALUE;
            this.explodeSubfields(38945, lensData, 4);
        }
    }

    @Override
    public String valueToString(ImageMetaValue value) {
        switch (value.getOwningTagID()) {
            case 27: {
                if (!(value instanceof LongMetaValue)) {
                    return "?";
                }
                long[] v = ((LongMetaValue)value).getLongValues();
                if (v.length != 7) {
                    return "?";
                }
                if (v[0] == 0L) {
                    return this.getTagValueLabelFor(27, v[0]);
                }
                return v[1] + 120L + v[2] + " -> " + v[3] + 'x' + v[4] + " @ " + v[5] + ',' + v[6];
            }
            case 18: 
            case 24: {
                long n = value.getLongValue() >>> 24;
                return TextUtil.tenths((double)n / 6.0);
            }
            case 9969930: {
                return value.getStringValue() + "mm";
            }
            case 9965574: 
            case 9969931: {
                String label = this.hasTagValueLabelFor(9965574);
                return label != null ? label : "unknown";
            }
            case 9965576: 
            case 9965577: 
            case 9969933: 
            case 9969934: {
                short n = value.getUnsignedByteValue();
                return TextUtil.tenths(5.0 * Math.pow(2.0, (double)n / 24.0)) + "mm";
            }
            case 132: {
                String lensLabel = NikonDirectory.makeLensLabelFrom(value);
                if (lensLabel == null) break;
                return lensLabel;
            }
            case 139: {
                if (!(value instanceof UndefinedMetaValue)) {
                    return "?";
                }
                byte[] b = ((UndefinedMetaValue)value).getUndefinedValue();
                float f = b[2] != 0 ? (float)b[0] * ((float)b[1] / (float)b[2]) : 0.0f;
                return TextUtil.tenths(f);
            }
        }
        return super.valueToString(value);
    }

    @Override
    protected int getProviderPriorityFor(Class<? extends ImageMetadataProvider> provider) {
        return provider == FocalLengthProvider.class ? 0 : super.getProviderPriorityFor(provider);
    }

    @Override
    protected ResourceBundle getTagLabelBundle() {
        return m_tagBundle;
    }

    @Override
    protected Class<? extends ImageMetaTags> getTagsInterface() {
        return NikonTags.class;
    }

    private static void add(int id, String name, ImageMetaType type) {
        ImageMetaTagInfo tagInfo = new ImageMetaTagInfo(id, name, type, false);
        m_tagsByID.put(id, tagInfo);
        m_tagsByName.put(name, tagInfo);
    }

    private static int count1BitsOf(int n) {
        int count = 0;
        while (n != 0) {
            ++count;
            n &= n - 1;
        }
        return count;
    }

    private static void decrypt(byte[] buf, int offset, long serialNumber, long shutterCount) {
        int key = 0;
        for (int i = 0; i < 4; ++i) {
            key = (int)((long)key ^ shutterCount >>> i * 8 & 0xFFL);
        }
        int ci = m_decrypt[0][(int)(serialNumber & 0xFFL)] & 0xFF;
        int cj = m_decrypt[1][key] & 0xFF;
        int ck = 96;
        int i = offset;
        while (i < buf.length) {
            cj = cj + ci * ck & 0xFF;
            ck = ck + 1 & 0xFF;
            int n = i++;
            buf[n] = (byte)(buf[n] ^ cj);
        }
    }

    private String[] explodeBits(int tagID, int bits) {
        int num1Bits = NikonDirectory.count1BitsOf(bits);
        String[] labels = new String[num1Bits];
        int i = 0;
        for (int bit = 0; bit < 32; ++bit) {
            if ((bits & 1 << bit) == 0) continue;
            labels[i++] = this.getTagValueLabelFor(tagID, bit);
        }
        return labels;
    }

    private void explodeSubfields(int tagID, byte[] buf, int offset) {
        tagID <<= 8;
        tagID += offset;
        for (int i = offset; i < buf.length; ++i) {
            this.putValue(tagID++, new UnsignedByteMetaValue(buf[i] & 0xFF));
        }
    }

    private ImageMetaValue getLensData(int tag0100, int tag0201) {
        ImageMetaValue version = this.getValue(0x980000);
        if (version != null) {
            switch (version.getUnsignedShortValue()) {
                case 256: 
                case 257: {
                    return this.getValue(tag0100);
                }
                case 513: {
                    return this.getValue(tag0201);
                }
            }
        }
        return null;
    }

    static {
        NikonDirectory.add(136, "AFPoint", ImageMetaType.META_ULONG);
        NikonDirectory.add(173, "AFResponse", ImageMetaType.META_STRING);
        NikonDirectory.add(138, "AutoBracketRelease", ImageMetaType.META_USHORT);
        NikonDirectory.add(130, "AuxiliaryLens", ImageMetaType.META_STRING);
        NikonDirectory.add(141, "ColorHue", ImageMetaType.META_STRING);
        NikonDirectory.add(3, "ColorMode", ImageMetaType.META_STRING);
        NikonDirectory.add(30, "ColorSpace", ImageMetaType.META_USHORT);
        NikonDirectory.add(27, "CropHighSpeed", ImageMetaType.META_STRING);
        NikonDirectory.add(134, "DigitalZoom", ImageMetaType.META_URATIONAL);
        NikonDirectory.add(25, "ExposureBracketValue", ImageMetaType.META_URATIONAL);
        NikonDirectory.add(14, "ExposureDifference", ImageMetaType.META_UNDEFINED);
        NikonDirectory.add(1, "FirmwareVersion", ImageMetaType.META_STRING);
        NikonDirectory.add(24, "FlashExposureBracketValue", ImageMetaType.META_ULONG);
        NikonDirectory.add(18, "FlashExposureCompensation", ImageMetaType.META_ULONG);
        NikonDirectory.add(135, "FlashMode", ImageMetaType.META_UBYTE);
        NikonDirectory.add(8, "FlashSetting", ImageMetaType.META_STRING);
        NikonDirectory.add(9, "FlashType", ImageMetaType.META_STRING);
        NikonDirectory.add(7, "FocusMode", ImageMetaType.META_STRING);
        NikonDirectory.add(177, "HighISONoiseReduction", ImageMetaType.META_USHORT);
        NikonDirectory.add(146, "HueAdjustment", ImageMetaType.META_SSHORT);
        NikonDirectory.add(128, "ImageAdjustment", ImageMetaType.META_STRING);
        NikonDirectory.add(162, "ImageDataSize", ImageMetaType.META_ULONG);
        NikonDirectory.add(169, "ImageOptimization", ImageMetaType.META_UNKNOWN);
        NikonDirectory.add(26, "ImageProcessing", ImageMetaType.META_STRING);
        NikonDirectory.add(172, "ImageStabilization", ImageMetaType.META_STRING);
        NikonDirectory.add(2, "ISO", ImageMetaType.META_USHORT);
        NikonDirectory.add(15, "ISO_D70", ImageMetaType.META_USHORT);
        NikonDirectory.add(19, "ISO_D70_2", ImageMetaType.META_USHORT);
        NikonDirectory.add(0x980000, "LDVersion", ImageMetaType.META_UNKNOWN);
        NikonDirectory.add(9965579, "LD1XApertureAtMaxFocal", ImageMetaType.META_UNKNOWN);
        NikonDirectory.add(9965578, "LD1XApertureAtMinFocal", ImageMetaType.META_UNKNOWN);
        NikonDirectory.add(9965575, "LD1XLensFstops", ImageMetaType.META_UNKNOWN);
        NikonDirectory.add(9965574, "LD1XLensId", ImageMetaType.META_UNKNOWN);
        NikonDirectory.add(9965577, "LD1XMaxFocalLength", ImageMetaType.META_UNKNOWN);
        NikonDirectory.add(9965580, "LD1XMcuVersion", ImageMetaType.META_UNKNOWN);
        NikonDirectory.add(9969933, "LD21MinFocalLength", ImageMetaType.META_UNKNOWN);
        NikonDirectory.add(9969925, "LD21AFAperture", ImageMetaType.META_UNKNOWN);
        NikonDirectory.add(9969936, "LD21ApertureAtMaxFocal", ImageMetaType.META_UNKNOWN);
        NikonDirectory.add(9969935, "LD21ApertureAtMinFocal", ImageMetaType.META_UNKNOWN);
        NikonDirectory.add(9969938, "LD21EffectiveMaxAperture", ImageMetaType.META_UNKNOWN);
        NikonDirectory.add(9969930, "LD21FocalLength", ImageMetaType.META_UNKNOWN);
        NikonDirectory.add(9969929, "LD21FocusDistance", ImageMetaType.META_UNKNOWN);
        NikonDirectory.add(9969928, "LD21FocusPosition", ImageMetaType.META_UNKNOWN);
        NikonDirectory.add(9969932, "LD21LensFstops", ImageMetaType.META_UNKNOWN);
        NikonDirectory.add(9969931, "LD21LensId", ImageMetaType.META_UNKNOWN);
        NikonDirectory.add(9969934, "LD21MaxFocalLength", ImageMetaType.META_UNKNOWN);
        NikonDirectory.add(9969937, "LD21McuVersion", ImageMetaType.META_UNKNOWN);
        NikonDirectory.add(9969933, "LD21MinFocalLength", ImageMetaType.META_UNKNOWN);
        NikonDirectory.add(132, "Lens", ImageMetaType.META_URATIONAL);
        NikonDirectory.add(152, "LensData", ImageMetaType.META_UNDEFINED);
        NikonDirectory.add(139, "LensFStops", ImageMetaType.META_UNDEFINED);
        NikonDirectory.add(131, "LensType", ImageMetaType.META_UBYTE);
        NikonDirectory.add(144, "LightSource", ImageMetaType.META_STRING);
        NikonDirectory.add(133, "ManualFocusDistance", ImageMetaType.META_URATIONAL);
        NikonDirectory.add(149, "NoiseReduction", ImageMetaType.META_STRING);
        NikonDirectory.add(17, "PreviewImageIFDPointer", ImageMetaType.META_ULONG);
        NikonDirectory.add(4, "Quality", ImageMetaType.META_STRING);
        NikonDirectory.add(170, "Saturation", ImageMetaType.META_STRING);
        NikonDirectory.add(143, "SceneMode", ImageMetaType.META_STRING);
        NikonDirectory.add(154, "SensorPixelSize", ImageMetaType.META_URATIONAL);
        NikonDirectory.add(29, "SerialNumber", ImageMetaType.META_STRING);
        NikonDirectory.add(160, "SerialNumber2", ImageMetaType.META_UNKNOWN);
        NikonDirectory.add(6, "Sharpening", ImageMetaType.META_STRING);
        NikonDirectory.add(137, "ShootingMode", ImageMetaType.META_USHORT);
        NikonDirectory.add(167, "ShutterCount", ImageMetaType.META_ULONG);
        NikonDirectory.add(129, "ToneCompensation", ImageMetaType.META_STRING);
        NikonDirectory.add(171, "VariProgram", ImageMetaType.META_STRING);
        NikonDirectory.add(5, "WhiteBalance", ImageMetaType.META_STRING);
        NikonDirectory.add(11, "WhiteBalanceFineTune", ImageMetaType.META_USHORT);
    }
}

