/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.metadata.makernotes;

import com.lightcrafts.image.metadata.ImageMetaTagInfo;
import com.lightcrafts.image.metadata.ImageMetaTags;
import com.lightcrafts.image.metadata.ImageMetaType;
import com.lightcrafts.image.metadata.ImageOrientation;
import com.lightcrafts.image.metadata.MetadataUtil;
import com.lightcrafts.image.metadata.makernotes.MakerNotesDirectory;
import com.lightcrafts.image.metadata.makernotes.PanasonicTags;
import com.lightcrafts.image.metadata.providers.OrientationProvider;
import com.lightcrafts.image.metadata.values.ImageMetaValue;
import com.lightcrafts.image.metadata.values.LongMetaValue;
import com.lightcrafts.image.metadata.values.UndefinedMetaValue;
import com.lightcrafts.image.metadata.values.UnsignedByteMetaValue;
import com.lightcrafts.image.metadata.values.UnsignedShortMetaValue;
import com.lightcrafts.utils.bytebuffer.LCByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PanasonicDirectory
extends MakerNotesDirectory
implements OrientationProvider {
    private static final Pattern m_serialNumberPattern = Pattern.compile("^([A-Z]\\d{2})(\\d{2})(\\d{2})(\\d{2})(\\d{4})");
    private static final Map<Integer, ImageMetaTagInfo> m_tagsByID = new HashMap<Integer, ImageMetaTagInfo>();
    private static final Map<String, ImageMetaTagInfo> m_tagsByName = new HashMap<String, ImageMetaTagInfo>();
    private static final ResourceBundle m_tagBundle = ResourceBundle.getBundle("com.lightcrafts.image.metadata.makernotes.PanasonicTags");

    @Override
    public int[] getMakerNotesAdjustments(LCByteBuffer buf, int offset) {
        return new int[]{12, offset};
    }

    @Override
    public String getName() {
        return "Panasonic";
    }

    @Override
    public ImageOrientation getOrientation() {
        ImageMetaValue value = this.getValue(48);
        if (value != null) {
            switch (value.getIntValue()) {
                case 1: {
                    return ImageOrientation.ORIENTATION_LANDSCAPE;
                }
                case 6: {
                    return ImageOrientation.ORIENTATION_90CW;
                }
                case 8: {
                    return ImageOrientation.ORIENTATION_90CCW;
                }
            }
        }
        return ImageOrientation.ORIENTATION_UNKNOWN;
    }

    @Override
    public ImageMetaTagInfo getTagInfoFor(Integer id) {
        return m_tagsByID.get(id);
    }

    @Override
    public ImageMetaTagInfo getTagInfoFor(String name) {
        return m_tagsByName.get(name);
    }

    @Override
    public void putValue(Integer tagID, ImageMetaValue value) {
        switch (tagID) {
            case 44: {
                if (!value.isNumeric()) {
                    return;
                }
                int n = value.getIntValue();
                if (n < 256) break;
                value = new UnsignedShortMetaValue(n >>> 4 & 3);
                break;
            }
            case 15: {
                if (!(value instanceof LongMetaValue) || value.getValueCount() != 2) {
                    return;
                }
                LongMetaValue n = (LongMetaValue)value;
                value = new UnsignedByteMetaValue(n.getLongValueAt(1));
                break;
            }
        }
        super.putValue(tagID, value);
    }

    @Override
    public String valueToString(ImageMetaValue value) {
        switch (value.getOwningTagID()) {
            case 2: {
                if (!(value instanceof UndefinedMetaValue)) {
                    return "unknown";
                }
                UndefinedMetaValue u = (UndefinedMetaValue)value;
                byte[] buf = u.getUndefinedValue();
                StringBuilder sb = new StringBuilder();
                boolean dot = false;
                for (byte b : buf) {
                    if (!dot) {
                        dot = true;
                    } else {
                        sb.append('.');
                    }
                    sb.append((char)b);
                }
                return sb.toString();
            }
            case 37: {
                Matcher m = m_serialNumberPattern.matcher(value.getStringValue());
                if (!m.matches()) break;
                try {
                    int year = Integer.parseInt(m.group(2));
                    return '(' + m.group(1) + ") " + (year += year < 70 ? 2000 : 1900) + ':' + m.group(3) + ':' + m.group(4) + " #" + m.group(5);
                }
                catch (NumberFormatException e) {
                    break;
                }
            }
            case 35: {
                if (!value.isNumeric()) break;
                double bias = value.getFloatValue() / 3.0f;
                return MetadataUtil.convertBiasFromAPEX(bias);
            }
        }
        return super.valueToString(value);
    }

    @Override
    protected ResourceBundle getTagLabelBundle() {
        return m_tagBundle;
    }

    @Override
    protected Class<? extends ImageMetaTags> getTagsInterface() {
        return PanasonicTags.class;
    }

    private static void add(int id, String name, ImageMetaType type) {
        ImageMetaTagInfo tagInfo = new ImageMetaTagInfo(id, name, type, false);
        m_tagsByID.put(id, tagInfo);
        m_tagsByName.put(name, tagInfo);
    }

    static {
        PanasonicDirectory.add(32, "Audio", ImageMetaType.META_USHORT);
        PanasonicDirectory.add(42, "BurstMode", ImageMetaType.META_USHORT);
        PanasonicDirectory.add(40, "ColorEffect", ImageMetaType.META_USHORT);
        PanasonicDirectory.add(50, "ColorMode", ImageMetaType.META_USHORT);
        PanasonicDirectory.add(44, "Contrast", ImageMetaType.META_USHORT);
        PanasonicDirectory.add(2, "FirmwareVersion", ImageMetaType.META_UNDEFINED);
        PanasonicDirectory.add(36, "FlashBias", ImageMetaType.META_SSHORT);
        PanasonicDirectory.add(7, "FocusMode", ImageMetaType.META_USHORT);
        PanasonicDirectory.add(1, "ImageQuality", ImageMetaType.META_USHORT);
        PanasonicDirectory.add(26, "ImageStabilizer", ImageMetaType.META_USHORT);
        PanasonicDirectory.add(37, "InternalSerialNumber", ImageMetaType.META_UNDEFINED);
        PanasonicDirectory.add(28, "MacroMode", ImageMetaType.META_USHORT);
        PanasonicDirectory.add(45, "NoiseReduction", ImageMetaType.META_USHORT);
        PanasonicDirectory.add(48, "Rotation", ImageMetaType.META_USHORT);
        PanasonicDirectory.add(46, "SelfTimer", ImageMetaType.META_USHORT);
        PanasonicDirectory.add(43, "SequenceNumber", ImageMetaType.META_ULONG);
        PanasonicDirectory.add(31, "ShootingMode", ImageMetaType.META_USHORT);
        PanasonicDirectory.add(15, "SpotMode", ImageMetaType.META_UBYTE);
        PanasonicDirectory.add(3, "WhiteBalance", ImageMetaType.META_USHORT);
        PanasonicDirectory.add(35, "WhiteBalanceBias", ImageMetaType.META_SSHORT);
    }
}

