/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.types;

import com.lightcrafts.image.BadImageFileException;
import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.UnknownImageTypeException;
import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.metadata.MetadataUtil;
import com.lightcrafts.image.metadata.TIFFMetadataReader;
import com.lightcrafts.image.types.JPEGImageType;
import com.lightcrafts.image.types.RawImageType;
import com.lightcrafts.utils.bytebuffer.LCByteBuffer;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.ByteOrder;

public final class CR2ImageType
extends RawImageType {
    public static final CR2ImageType INSTANCE = new CR2ImageType();
    private static final String[] EXTENSIONS = new String[]{"cr2"};

    @Override
    public String[] getExtensions() {
        return EXTENSIONS;
    }

    @Override
    public String getName() {
        return "CR2";
    }

    @Override
    public RenderedImage getPreviewImage(ImageInfo imageInfo, int maxWidth, int maxHeight) throws BadImageFileException, IOException, UnknownImageTypeException {
        LCByteBuffer buf = imageInfo.getByteBuffer();
        ByteOrder origOrder = buf.order();
        buf.order(ByteOrder.LITTLE_ENDIAN);
        int offset = (int)buf.getLong(98);
        int length = (int)buf.getLong(122);
        buf.order(origOrder);
        RenderedImage image = JPEGImageType.getImageFromBuffer(buf, offset, length, null, maxWidth, maxHeight);
        return image != null ? image : super.getPreviewImage(imageInfo, maxWidth, maxHeight);
    }

    @Override
    public boolean hasFastPreview() {
        return true;
    }

    @Override
    public RenderedImage getThumbnailImage(ImageInfo imageInfo) throws BadImageFileException, IOException, UnknownImageTypeException {
        return this.getPreviewImage(imageInfo, 640, 480);
    }

    @Override
    public void readMetadata(ImageInfo imageInfo) throws BadImageFileException, IOException {
        TIFFMetadataReader reader = new TIFFMetadataReader(imageInfo);
        ImageMetadata metadata = reader.readMetadata();
        MetadataUtil.removePreviewMetadataFrom(metadata);
        MetadataUtil.removeWidthHeightFrom(metadata);
    }

    private CR2ImageType() {
    }
}

