/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.types;

import com.lightcrafts.image.BadImageFileException;
import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.UnknownImageTypeException;
import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.metadata.ImageOrientation;
import com.lightcrafts.image.metadata.MetadataUtil;
import com.lightcrafts.image.metadata.TIFFMetadataReader;
import com.lightcrafts.image.types.RawImageType;
import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.operator.TransposeType;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.IOException;

public final class DCRImageType
extends RawImageType {
    public static final DCRImageType INSTANCE = new DCRImageType();
    private static final String[] EXTENSIONS = new String[]{"dcr"};

    @Override
    public String[] getExtensions() {
        return EXTENSIONS;
    }

    @Override
    public String getName() {
        return "DCR";
    }

    @Override
    public RenderedImage getThumbnailImage(ImageInfo imageInfo) throws BadImageFileException, IOException, UnknownImageTypeException {
        RenderedImage thumb = super.getThumbnailImage(imageInfo);
        ImageMetadata metaData = imageInfo.getMetadata();
        ImageOrientation orientation = metaData.getOrientation();
        TransposeType transpose = orientation.getCorrection();
        if (transpose == null) {
            return thumb;
        }
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(thumb);
        pb.add(transpose);
        return JAI.create((String)"Transpose", (ParameterBlock)pb, null);
    }

    @Override
    public void readMetadata(ImageInfo imageInfo) throws BadImageFileException, IOException {
        TIFFMetadataReader reader = new TIFFMetadataReader(imageInfo);
        MetadataUtil.removePreviewMetadataFrom(reader.readMetadata());
    }

    private DCRImageType() {
    }
}

