/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.types;

import com.lightcrafts.image.BadImageFileException;
import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.UnknownImageTypeException;
import com.lightcrafts.image.metadata.ImageMetadataDirectory;
import com.lightcrafts.image.metadata.MetadataUtil;
import com.lightcrafts.image.metadata.TIFFMetadataReader;
import com.lightcrafts.image.metadata.makernotes.OlympusDirectory;
import com.lightcrafts.image.types.JPEGImageType;
import com.lightcrafts.image.types.RawImageType;
import java.awt.image.RenderedImage;
import java.io.IOException;

public final class ORFImageType
extends RawImageType {
    public static final ORFImageType INSTANCE = new ORFImageType();
    private static final String[] EXTENSIONS = new String[]{"orf"};

    @Override
    public String[] getExtensions() {
        return EXTENSIONS;
    }

    @Override
    public String getName() {
        return "ORF";
    }

    @Override
    public RenderedImage getPreviewImage(ImageInfo imageInfo, int maxWidth, int maxHeight) throws BadImageFileException, IOException, UnknownImageTypeException {
        RenderedImage image = null;
        ImageMetadataDirectory dir = imageInfo.getMetadata().getDirectoryFor(OlympusDirectory.class);
        if (dir != null) {
            image = JPEGImageType.getImageFromBuffer(imageInfo.getByteBuffer(), dir.getValue(136), 0, dir.getValue(137), maxWidth, maxHeight);
            if (image == null) {
                image = JPEGImageType.getImageFromBuffer(imageInfo.getByteBuffer(), dir.getValue(4150), 0, dir.getValue(4151), maxWidth, maxHeight);
            }
            if (image == null) {
                image = JPEGImageType.getImageFromBuffer(imageInfo.getByteBuffer(), dir.getValue(12545), 0, dir.getValue(12546), maxWidth, maxHeight);
            }
        }
        return image != null ? image : super.getPreviewImage(imageInfo, maxWidth, maxHeight);
    }

    @Override
    public boolean hasFastPreview() {
        return true;
    }

    @Override
    public void readMetadata(ImageInfo imageInfo) throws BadImageFileException, IOException {
        TIFFMetadataReader reader = new TIFFMetadataReader(imageInfo);
        MetadataUtil.removePreviewMetadataFrom(reader.readMetadata());
    }

    private ORFImageType() {
    }
}

