/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.types;

import com.lightcrafts.image.BadImageFileException;
import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.UnknownImageTypeException;
import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.metadata.ImageMetadataDirectory;
import com.lightcrafts.image.metadata.MetadataUtil;
import com.lightcrafts.image.metadata.TIFFDirectory;
import com.lightcrafts.image.metadata.TIFFMetadataReader;
import com.lightcrafts.image.types.JPEGImageType;
import com.lightcrafts.image.types.RawImageType;
import java.awt.image.RenderedImage;
import java.io.IOException;

public final class SRWImageType
extends RawImageType {
    public static final SRWImageType INSTANCE = new SRWImageType();
    private static final String[] EXTENSIONS = new String[]{"srw"};

    @Override
    public String[] getExtensions() {
        return EXTENSIONS;
    }

    @Override
    public String getName() {
        return "SRW";
    }

    @Override
    public RenderedImage getPreviewImage(ImageInfo imageInfo, int maxWidth, int maxHeight) throws BadImageFileException, IOException, UnknownImageTypeException {
        RenderedImage image;
        ImageMetadataDirectory dir = imageInfo.getMetadata().getDirectoryFor(TIFFDirectory.class);
        if (dir != null && (image = JPEGImageType.getImageFromBuffer(imageInfo.getByteBuffer(), dir.getValue(273), 0, dir.getValue(279), maxWidth, maxHeight)) != null) {
            return image;
        }
        return super.getPreviewImage(imageInfo, maxWidth, maxHeight);
    }

    @Override
    public boolean hasFastPreview() {
        return true;
    }

    @Override
    public RenderedImage getThumbnailImage(ImageInfo imageInfo) throws BadImageFileException, IOException, UnknownImageTypeException {
        return this.getPreviewImage(imageInfo, 640, 480);
    }

    @Override
    public void readMetadata(ImageInfo imageInfo) throws BadImageFileException, IOException {
        TIFFMetadataReader reader = new TIFFMetadataReader(imageInfo);
        ImageMetadata metadata = reader.readMetadata();
        MetadataUtil.removePreviewMetadataFrom(metadata);
        MetadataUtil.removeWidthHeightFrom(metadata);
    }

    private SRWImageType() {
    }
}

