/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.jai;

import com.lightcrafts.jai.opimage.ShapedMask;
import com.lightcrafts.mediax.jai.ROIShape;
import com.lightcrafts.model.Contour;
import com.lightcrafts.model.Region;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.Raster;
import java.util.LinkedList;
import java.util.List;

public class LCROIShape
extends ROIShape {
    private Region region;
    private AffineTransform transform;
    private List<Object> contours = new LinkedList<Object>();
    private ShapedMask theMask = null;

    public LCROIShape(Region r, AffineTransform transform) {
        super(r.getOuterShape());
        this.transform = transform;
        this.region = r;
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public Region getRegion() {
        return this.region;
    }

    public boolean intersects(Rectangle rect) {
        return this.intersects(new Rectangle2D.Double(rect.x, rect.y, rect.width, rect.height));
    }

    public boolean intersects(Rectangle2D rect) {
        for (Contour c : this.region.getContours()) {
            AffineTransform combined = this.transform;
            if (c.getTranslation() != null) {
                combined = AffineTransform.getTranslateInstance(c.getTranslation().getX(), c.getTranslation().getY());
                combined.preConcatenate(this.transform);
            }
            Rectangle2D translatedRect = rect;
            if (!combined.isIdentity()) {
                try {
                    AffineTransform inverse = combined.createInverse();
                    translatedRect = inverse.createTransformedShape(rect).getBounds2D();
                }
                catch (NoninvertibleTransformException e) {
                    e.printStackTrace();
                }
            }
            Rectangle bounds = c.getOuterShape().getBounds();
            bounds.grow((int)c.getWidth(), (int)c.getWidth());
            if (!bounds.intersects(translatedRect)) continue;
            return true;
        }
        return false;
    }

    public Rectangle getOuterBounds() {
        return ShapedMask.getOuterBounds(this.region, this.transform);
    }

    private synchronized boolean somethingChanged() {
        int i = 0;
        for (Contour c : this.region.getContours()) {
            if (c != this.contours.get(i)) {
                return true;
            }
            if (c.getTranslation() != null) {
                if (this.contours.size() > i + 1 && c.getTranslation() != this.contours.get(i + 1)) {
                    return true;
                }
                i += 2;
                continue;
            }
            ++i;
        }
        return this.contours.size() != i;
    }

    public synchronized Raster getData(Rectangle rect) {
        if (this.theMask == null || this.somethingChanged()) {
            for (Contour c : this.region.getContours()) {
                this.contours.add(c);
                if (c.getTranslation() == null) continue;
                this.contours.add(c.getTranslation());
            }
            this.theMask = new ShapedMask(this.region, this);
        }
        return this.theMask.getData(rect);
    }
}

