/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.jai.opimage;

import com.lightcrafts.mediax.jai.AreaOpImage;
import com.lightcrafts.mediax.jai.BorderExtender;
import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.RasterAccessor;
import com.lightcrafts.mediax.jai.RasterFormatTag;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;

public final class BilateralFilterOpImage
extends AreaOpImage {
    private int wr;
    private int ws;
    private float[] kernel;
    private float scale_r;

    private static float SQR(float x) {
        return x * x;
    }

    public BilateralFilterOpImage(RenderedImage source, BorderExtender extender, Map config, ImageLayout layout, float sigma_d, float sigma_r) {
        super(source, layout, config, true, extender, (int)Math.ceil(sigma_d), (int)Math.ceil(sigma_d), (int)Math.ceil(sigma_d), (int)Math.ceil(sigma_d));
        this.wr = (int)Math.ceil(sigma_d);
        this.ws = 2 * this.wr + 1;
        this.kernel = new float[this.ws];
        for (int i = -this.wr; i <= this.wr; ++i) {
            this.kernel[this.wr + i] = (float)((double)(1.0f / (2.0f * BilateralFilterOpImage.SQR(sigma_d)) * (float)i * (float)i) + 0.25);
        }
        this.scale_r = 1.0f / (2.0f * BilateralFilterOpImage.SQR(sigma_r));
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        Raster source = sources[0];
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        RasterAccessor srcAccessor = new RasterAccessor(source, srcRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor dstAccessor = new RasterAccessor((Raster)dest, destRect, formatTags[1], this.getColorModel());
        switch (dstAccessor.getDataType()) {
            case 1: {
                this.ushortLoop(srcAccessor, dstAccessor);
                break;
            }
        }
        if (dstAccessor.isDataCopy()) {
            dstAccessor.clampDataArrays();
            dstAccessor.copyDataToRaster();
        }
    }

    protected void ushortLoop(RasterAccessor src, RasterAccessor dst) {
        int swidth = src.getWidth();
        int sheight = src.getHeight();
        short[][] dstDataArrays = dst.getShortDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstScanlineStride = dst.getScanlineStride();
        short[][] srcDataArrays = src.getShortDataArrays();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcScanlineStride = src.getScanlineStride();
        short[] dstData = dstDataArrays[0];
        short[] srcData = srcDataArrays[0];
        if (src.getNumBands() == 1) {
            BilateralFilterOpImage.bilateralFilterMonoRLM(srcData, dstData, this.wr, this.ws, 4.0f * this.scale_r, this.kernel, swidth, sheight, src.getPixelStride(), dst.getPixelStride(), srcBandOffsets[0], dstBandOffsets[0], srcScanlineStride, dstScanlineStride);
        } else {
            BilateralFilterOpImage.bilateralFilterChromaRLM(srcData, dstData, this.wr, this.ws, 4.0f * this.scale_r, this.kernel, swidth, sheight, srcBandOffsets[0], srcBandOffsets[1], srcBandOffsets[2], dstBandOffsets[0], dstBandOffsets[1], dstBandOffsets[2], srcScanlineStride, dstScanlineStride);
        }
    }

    static native void bilateralFilterChromaRLM(short[] var0, short[] var1, int var2, int var3, float var4, float[] var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15);

    static native void bilateralFilterMonoRLM(short[] var0, short[] var1, int var2, int var3, float var4, float[] var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13);
}

