/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.jai.opimage;

import com.lightcrafts.mediax.jai.AreaOpImage;
import com.lightcrafts.mediax.jai.BorderExtender;
import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.RasterAccessor;
import com.lightcrafts.mediax.jai.RasterFormatTag;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;

final class BilateralFilterOpImage2
extends AreaOpImage {
    private int wr;
    private int ws;
    private float[] kernel;
    private float scale_r;
    private float[] elut;

    private static double SQR(double x) {
        return x * x;
    }

    public BilateralFilterOpImage2(RenderedImage source, BorderExtender extender, Map config, ImageLayout layout, float sigma_d, float sigma_r) {
        super(source, layout, config, true, extender, (int)Math.ceil(sigma_d * 2.0f), (int)Math.ceil(sigma_d * 2.0f), (int)Math.ceil(sigma_d * 2.0f), (int)Math.ceil(sigma_d * 2.0f));
        int i;
        this.wr = (int)Math.ceil(sigma_d * 2.0f);
        this.ws = 2 * this.wr + 1;
        this.kernel = new float[this.ws];
        this.kernel = new float[this.ws];
        for (i = -this.wr; i <= this.wr; ++i) {
            this.kernel[this.wr + i] = (float)(256.0 / (2.0 * BilateralFilterOpImage2.SQR(sigma_d)) * (double)i * (double)i + 0.25);
        }
        this.scale_r = (float)(256.0 / (2.0 * BilateralFilterOpImage2.SQR(sigma_r)));
        this.elut = new float[4096];
        for (i = 0; i < 4096; ++i) {
            this.elut[i] = (float)Math.exp((double)(-i) / 256.0);
        }
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        Raster source = sources[0];
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        RasterAccessor srcAccessor = new RasterAccessor(source, srcRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor dstAccessor = new RasterAccessor((Raster)dest, destRect, formatTags[1], this.getColorModel());
        switch (dstAccessor.getDataType()) {
            case 1: {
                this.ushortLoop(srcAccessor, dstAccessor);
                break;
            }
        }
        if (dstAccessor.isDataCopy()) {
            dstAccessor.clampDataArrays();
            dstAccessor.copyDataToRaster();
        }
    }

    protected void ushortLoop(RasterAccessor src, RasterAccessor dst) {
        int srcPixelOffset;
        int j;
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        short[][] dstDataArrays = dst.getShortDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        short[][] srcDataArrays = src.getShortDataArrays();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        float[][] tmpBuffer = new float[3][this.ws * dwidth];
        int tmpBufferSize = this.ws * dwidth;
        short[] dstData = dstDataArrays[0];
        short[] srcData = srcDataArrays[0];
        int srcScanlineOffset = srcBandOffsets[0];
        int dstScanlineOffset = dstBandOffsets[0];
        int revolver = 0;
        int kvRevolver = 0;
        for (j = 0; j < this.ws - 1; ++j) {
            srcPixelOffset = srcScanlineOffset;
            for (int i = 0; i < dwidth; ++i) {
                int imageOffset = srcPixelOffset;
                float sa = 0.0f;
                float sb = 0.0f;
                float ss = 0.0f;
                int g0 = srcData[this.wr + imageOffset + 1] & 0xFFFF;
                int a0 = g0 - (srcData[this.wr + imageOffset] & 0xFFFF);
                int b0 = g0 - (srcData[this.wr + imageOffset + 2] & 0xFFFF);
                for (int v = 0; v < this.ws; ++v) {
                    int g = srcData[imageOffset + 1] & 0xFFFF;
                    int a = g - (srcData[imageOffset] & 0xFFFF);
                    int b = g - (srcData[imageOffset + 2] & 0xFFFF);
                    int sep = (int)((BilateralFilterOpImage2.SQR(a - a0) + BilateralFilterOpImage2.SQR(b - b0)) * (double)this.scale_r + (double)this.kernel[this.wr] + (double)this.kernel[v]) / 65536;
                    if (sep < 4096) {
                        float exp = this.elut[sep];
                        sa += exp * (float)a;
                        sb += exp * (float)b;
                        ss += exp;
                    }
                    imageOffset += srcPixelStride;
                }
                tmpBuffer[0][revolver + i] = g0;
                tmpBuffer[1][revolver + i] = sa / ss;
                tmpBuffer[2][revolver + i] = sb / ss;
                srcPixelOffset += srcPixelStride;
            }
            revolver += dwidth;
            srcScanlineOffset += srcScanlineStride;
        }
        for (j = 0; j < dheight; ++j) {
            srcPixelOffset = srcScanlineOffset;
            int dstPixelOffset = dstScanlineOffset;
            for (int i = 0; i < dwidth; ++i) {
                int imageOffset = srcPixelOffset;
                float sa = 0.0f;
                float sb = 0.0f;
                float ss = 0.0f;
                float g0 = srcData[this.wr + imageOffset + 1] & 0xFFFF;
                float a0 = g0 - (float)(srcData[this.wr + imageOffset] & 0xFFFF);
                float b0 = g0 - (float)(srcData[this.wr + imageOffset + 2] & 0xFFFF);
                for (int v = 0; v < this.ws; ++v) {
                    float g = srcData[imageOffset + 1] & 0xFFFF;
                    float a = g - (float)(srcData[imageOffset] & 0xFFFF);
                    float b = g - (float)(srcData[imageOffset + 2] & 0xFFFF);
                    int sep = (int)((BilateralFilterOpImage2.SQR(a - a0) + BilateralFilterOpImage2.SQR(b - b0)) * (double)this.scale_r + (double)this.kernel[this.wr] + (double)this.kernel[v]) / 65536;
                    if (sep < 4096) {
                        float exp = this.elut[sep];
                        sa += exp * a;
                        sb += exp * b;
                        ss += exp;
                    }
                    imageOffset += srcPixelStride;
                }
                tmpBuffer[0][revolver + i] = g0;
                tmpBuffer[1][revolver + i] = sa / ss;
                tmpBuffer[2][revolver + i] = sb / ss;
                int bb = kvRevolver + i;
                ss = 0.0f;
                sb = 0.0f;
                sa = 0.0f;
                int idx0 = bb;
                for (int m = 0; m < this.wr; ++m) {
                    if ((idx0 += dwidth) < tmpBufferSize) continue;
                    idx0 -= tmpBufferSize;
                }
                g0 = tmpBuffer[0][idx0];
                a0 = tmpBuffer[1][idx0];
                b0 = tmpBuffer[2][idx0];
                for (int aa = 0; aa < this.ws; ++aa) {
                    float a = tmpBuffer[1][bb];
                    float b = tmpBuffer[2][bb];
                    int sep = (int)((BilateralFilterOpImage2.SQR(a - a0) + BilateralFilterOpImage2.SQR(b - b0)) * (double)this.scale_r + (double)this.kernel[this.wr] + (double)this.kernel[aa]) / 65536;
                    if (sep < 4096) {
                        float exp = this.elut[sep];
                        sa += exp * a;
                        sb += exp * b;
                        ss += exp;
                    }
                    if ((bb += dwidth) < tmpBufferSize) continue;
                    bb -= tmpBufferSize;
                }
                int g = (int)g0;
                int r = g - (int)(sa / ss);
                int b = g - (int)(sb / ss);
                dstData[dstPixelOffset + 0] = (short)(0xFFFF & (r < 0 ? 0 : (r > 65535 ? 65535 : r)));
                dstData[dstPixelOffset + 1] = (short)(0xFFFF & g);
                dstData[dstPixelOffset + 2] = (short)(0xFFFF & (b < 0 ? 0 : (b > 65535 ? 65535 : b)));
                srcPixelOffset += srcPixelStride;
                dstPixelOffset += dstPixelStride;
            }
            if ((revolver += dwidth) == tmpBufferSize) {
                revolver = 0;
            }
            if ((kvRevolver += dwidth) == tmpBufferSize) {
                kvRevolver = 0;
            }
            srcScanlineOffset += srcScanlineStride;
            dstScanlineOffset += dstScanlineStride;
        }
    }
}

