/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.jai.opimage;

import com.lightcrafts.jai.LCROIShape;
import com.lightcrafts.jai.opimage.PixelBlender;
import com.lightcrafts.media.jai.util.ImageUtil;
import com.lightcrafts.media.jai.util.JDKWorkarounds;
import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.PointOpImage;
import com.lightcrafts.mediax.jai.ROI;
import com.lightcrafts.mediax.jai.RasterAccessor;
import com.lightcrafts.mediax.jai.RasterFactory;
import com.lightcrafts.mediax.jai.RasterFormatTag;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class BlendOpImage
extends PointOpImage {
    private int s1bd = 1;
    private int s2bd = 1;
    private boolean areBinarySampleModels = false;
    private int blendModeId;
    private double opacity;
    private ROI mask;
    private final RenderedImage colorSelection;
    private static Map<String, BlendingMode> modes = new HashMap<String, BlendingMode>();
    ColorModel grayCm = new ComponentColorModel(ColorSpace.getInstance(1003), false, false, 1, 0);

    public static Set<String> availableModes() {
        return modes.keySet();
    }

    public BlendOpImage(RenderedImage source1, RenderedImage source2, String blendingMode, Double opacity, ROI mask, RenderedImage colorSelection, Map config, ImageLayout layout) {
        super(source1, source2, layout, config, true);
        if (source1.getSampleModel().getDataType() != 1 || source2.getSampleModel().getDataType() != 1) {
            throw new RuntimeException("Unsupported data type, only USHORT allowed.");
        }
        BlendingMode mode = modes.get(blendingMode);
        if (mode == null) {
            String className = ((Object)((Object)this)).getClass().getName();
            throw new RuntimeException(className + " unrecognized blending mode: " + blendingMode);
        }
        this.blendModeId = mode.id;
        this.opacity = opacity.floatValue();
        if (ImageUtil.isBinary((SampleModel)this.getSampleModel()) && ImageUtil.isBinary((SampleModel)source1.getSampleModel()) && ImageUtil.isBinary((SampleModel)source2.getSampleModel())) {
            this.areBinarySampleModels = true;
        } else {
            SampleModel sm;
            int numBandsDst;
            int numBands1 = source1.getSampleModel().getNumBands();
            int numBands2 = source2.getSampleModel().getNumBands();
            if (layout != null && layout.isValid(256) && (numBandsDst = (sm = layout.getSampleModel(null)).getNumBands()) > 1 && (numBands1 == 1 && numBands2 > 1 || numBands2 == 1 && numBands1 > 1)) {
                numBandsDst = Math.min(Math.max(numBands1, numBands2), numBandsDst);
                if (numBandsDst != this.sampleModel.getNumBands()) {
                    this.sampleModel = RasterFactory.createComponentSampleModel((SampleModel)sm, (int)this.sampleModel.getTransferType(), (int)this.sampleModel.getWidth(), (int)this.sampleModel.getHeight(), (int)numBandsDst);
                    if (this.colorModel != null && !JDKWorkarounds.areCompatibleDataModels((SampleModel)this.sampleModel, (ColorModel)this.colorModel)) {
                        this.colorModel = ImageUtil.getCompatibleColorModel((SampleModel)this.sampleModel, (Map)config);
                    }
                }
                this.s1bd = numBands1 == 1 ? 0 : 1;
                this.s2bd = numBands2 == 1 ? 0 : 1;
            }
        }
        this.mask = mask;
        this.colorSelection = colorSelection;
    }

    public boolean computesUniqueTiles() {
        return false;
    }

    public boolean hasMask() {
        return this.mask != null;
    }

    public Raster getTile(int tileX, int tileY) {
        Rectangle destRect = this.getTileRect(tileX, tileY);
        if (this.hasMask() && !this.mask.intersects(destRect) && this.opacity > 0.0) {
            return this.getSourceImage(1).getTile(tileX, tileY);
        }
        return super.getTile(tileX, tileY);
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        if (this.areBinarySampleModels) {
            String className = ((Object)((Object)this)).getClass().getName();
            throw new RuntimeException(className + " does not implement computeRect" + " for binary data");
        }
        RasterFormatTag[] formatTags = this.getFormatTags();
        RasterAccessor s1 = new RasterAccessor(sources[0], destRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor s2 = new RasterAccessor(sources[1], destRect, formatTags[1], this.getSourceImage(1).getColorModel());
        RasterAccessor d = new RasterAccessor((Raster)dest, destRect, formatTags[2], this.getColorModel());
        Raster roi = null;
        if (this.hasMask()) {
            LCROIShape lcROI = (LCROIShape)this.mask;
            if (lcROI.intersects(destRect)) {
                roi = lcROI.getData(destRect);
            } else if (this.opacity > 0.0) {
                assert (dest.getBounds().equals(sources[1].getBounds()));
                JDKWorkarounds.setRect((WritableRaster)dest, (Raster)sources[1], (int)0, (int)0);
                return;
            }
        }
        RasterAccessor m = null;
        if (roi != null) {
            SampleModel roiSM = roi.getSampleModel();
            int roiFormatTagID = RasterAccessor.findCompatibleTag(null, (SampleModel)roiSM);
            RasterFormatTag roiFormatTag = new RasterFormatTag(roiSM, roiFormatTagID);
            m = new RasterAccessor(roi, destRect, roiFormatTag, this.grayCm);
        }
        RasterAccessor cs = null;
        if (this.colorSelection != null) {
            int tiley;
            int tilex = sources[0].getMinX() / sources[0].getWidth();
            Raster csRaster = this.colorSelection.getTile(tilex, tiley = sources[0].getMinY() / sources[0].getHeight());
            if (csRaster == null) {
                csRaster = this.colorSelection.getData(destRect);
            }
            SampleModel csRasterSM = csRaster.getSampleModel();
            int csRasterFormatTagID = RasterAccessor.findCompatibleTag(null, (SampleModel)csRasterSM);
            RasterFormatTag csRasterFormatTag = new RasterFormatTag(csRasterSM, csRasterFormatTagID);
            cs = new RasterAccessor(csRaster, destRect, csRasterFormatTag, this.grayCm);
        }
        switch (d.getDataType()) {
            case 1: {
                this.computeRectUShort(s1, s2, m, cs, d);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported data type: " + d.getDataType());
            }
        }
        if (d.needsClamping()) {
            d.clampDataArrays();
        }
        d.copyDataToRaster();
    }

    private void computeRectUShort(RasterAccessor src1, RasterAccessor src2, RasterAccessor mask, RasterAccessor colorSelection, RasterAccessor dst) {
        int s1LineStride = src1.getScanlineStride();
        int s1PixelStride = src1.getPixelStride();
        int[] s1BandOffsets = src1.getBandOffsets();
        short[][] s1Data = src1.getShortDataArrays();
        int s2LineStride = src2.getScanlineStride();
        int s2PixelStride = src2.getPixelStride();
        int[] s2BandOffsets = src2.getBandOffsets();
        short[][] s2Data = src2.getShortDataArrays();
        int mLineStride = 0;
        int mPixelStride = 0;
        int mBandOffset = 0;
        byte[] mData = null;
        if (mask != null) {
            mLineStride = mask.getScanlineStride();
            mPixelStride = mask.getPixelStride();
            mBandOffset = mask.getBandOffsets()[0];
            mData = mask.getByteDataArrays()[0];
        }
        int csLineStride = 0;
        int csPixelStride = 0;
        int csBandOffset = 0;
        byte[] csData = null;
        if (colorSelection != null) {
            csLineStride = colorSelection.getScanlineStride();
            csPixelStride = colorSelection.getPixelStride();
            csBandOffset = colorSelection.getBandOffsets()[0];
            csData = colorSelection.getByteDataArrays()[0];
        }
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int bands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        short[][] dData = dst.getShortDataArrays();
        int intOpacity = (int)(65535.0 * this.opacity + 0.5);
        short[] s1 = s1Data[0];
        short[] s2 = s2Data[0];
        byte[] m = mData;
        byte[] cs = csData;
        short[] d = dData[0];
        int s1LineOffset = s1BandOffsets[0];
        int s2LineOffset = s2BandOffsets[0];
        int mLineOffset = mBandOffset;
        int csLineOffset = csBandOffset;
        int dLineOffset = dBandOffsets[0];
        PixelBlender.cUShortLoopCS(s1, s2, d, m, cs, bands, this.s1bd, this.s2bd, s1LineOffset, s2LineOffset, dLineOffset, mLineOffset, csLineOffset, s1LineStride, s2LineStride, dLineStride, mLineStride, csLineStride, s1PixelStride, s2PixelStride, dPixelStride, mPixelStride, csPixelStride, dheight, dwidth, intOpacity, this.blendModeId);
    }

    static {
        for (BlendingMode b : BlendingMode.values()) {
            modes.put(b.name, b);
        }
    }

    public static enum BlendingMode {
        NORMAL("Normal", 0),
        AVERAGE("Average", 1),
        MULTIPLY("Multiply", 2),
        SCREEN("Screen", 3),
        DARKEN("Darken", 4),
        LIGHTEN("Lighten", 5),
        DIFFERENCE("Difference", 6),
        NEGATION("Negation", 7),
        EXCLUSION("Exclusion", 8),
        OVERLAY("Overlay", 9),
        HARD_LIGHT("Hard Light", 10),
        SOFT_LIGHT("Soft Light", 11),
        COLOR_DODGE("Color Dodge", 12),
        COLOR_BURN("Color Burn", 13),
        SOFT_DODGE("Soft Dodge", 14),
        SOFT_BURN("Soft Burn", 15),
        SHADOWS("Shadows", 19),
        MID_HILIGHTS("Mid+Hilights", 20),
        MIDTONES("Midtones", 21);

        private final String name;
        private final int id;

        private BlendingMode(String value, int id) {
            this.name = value;
            this.id = id;
        }

        public String getName() {
            return this.name;
        }
    }
}

