/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.jai.opimage;

import Jama.Matrix;
import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.PointOpImage;
import com.lightcrafts.mediax.jai.RasterAccessor;
import com.lightcrafts.mediax.jai.RasterFormatTag;
import com.lightcrafts.utils.ColorScience;
import com.lightcrafts.utils.HSB;
import java.awt.Rectangle;
import java.awt.color.ICC_ProfileRGB;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;

public class FilteredGrayscaleOpImage
extends PointOpImage {
    private final float[][] toLinearsRGB;
    private final float[] filter;
    private final float angle;

    public FilteredGrayscaleOpImage(RenderedImage source, float[] filter, float angle, float strength, Map config) {
        super(source, new ImageLayout(source), config, true);
        this.permitInPlaceOperation();
        ICC_ProfileRGB sRGB = (ICC_ProfileRGB)JAIContext.sRGBColorProfile;
        ICC_ProfileRGB linRGB = (ICC_ProfileRGB)JAIContext.linearProfile;
        this.toLinearsRGB = new Matrix(sRGB.getMatrix()).inverse().times(new Matrix(linRGB.getMatrix())).getArrayFloat();
        this.filter = (float[])filter.clone();
        this.angle = angle;
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        RasterAccessor src = new RasterAccessor(sources[0], destRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor dst = new RasterAccessor((Raster)dest, destRect, formatTags[1], this.getColorModel());
        switch (dst.getDataType()) {
            case 1: {
                this.ushortLoop(src, dst);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported data type: " + dst.getDataType());
            }
        }
        if (dst.needsClamping()) {
            dst.clampDataArrays();
        }
        dst.copyDataToRaster();
    }

    private static float angleDiff(float a, float b) {
        float result = Math.abs(a - b);
        if ((double)result > Math.PI) {
            result = (float)(Math.PI * 2 - (double)result);
        }
        return result;
    }

    protected void ushortLoop(RasterAccessor src, RasterAccessor dst) {
        int width = src.getWidth();
        int height = src.getHeight();
        short[] dstData = dst.getShortDataArray(0);
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        short[] srcData = src.getShortDataArray(0);
        int[] srcBandOffsets = src.getBandOffsets();
        int srcLineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int srcROffset = srcBandOffsets[0];
        int srcGOffset = srcBandOffsets[1];
        int srcBOffset = srcBandOffsets[2];
        int dstROffset = dstBandOffsets[0];
        int dstGOffset = dstBandOffsets[1];
        int dstBOffset = dstBandOffsets[2];
        float[] hsb = new float[3];
        HSB.fromRGB(this.filter, hsb);
        float filterHue = (float)(Math.PI * 2 * (double)hsb[0] - Math.PI);
        float filterSat = hsb[1];
        float[] rgb = new float[3];
        float[] hsb2 = new float[3];
        for (int row = 0; row < height; ++row) {
            for (int col = 0; col < width; ++col) {
                int srcPixOffset = srcPixelStride * col + row * srcLineStride;
                int r = 0xFFFF & srcData[srcPixOffset + srcROffset];
                int g = 0xFFFF & srcData[srcPixOffset + srcGOffset];
                int b = 0xFFFF & srcData[srcPixOffset + srcBOffset];
                rgb[0] = this.toLinearsRGB[0][0] * (float)r + this.toLinearsRGB[0][1] * (float)g + this.toLinearsRGB[0][2] * (float)b;
                rgb[1] = this.toLinearsRGB[1][0] * (float)r + this.toLinearsRGB[1][1] * (float)g + this.toLinearsRGB[1][2] * (float)b;
                rgb[2] = this.toLinearsRGB[2][0] * (float)r + this.toLinearsRGB[2][1] * (float)g + this.toLinearsRGB[2][2] * (float)b;
                HSB.fromRGB(rgb, hsb2);
                float hue = (float)(Math.PI * 2 * (double)hsb2[0] - Math.PI);
                float hueDiff = FilteredGrayscaleOpImage.angleDiff(hue, filterHue);
                float mask = (float)Math.cos(Math.PI * (double)hueDiff / (double)this.angle);
                mask = 1.0f - filterSat + filterSat * mask;
                float gray = ColorScience.Wr * (float)r + ColorScience.Wg * (float)g + ColorScience.Wb * (float)b;
                int rr = (int)(gray * mask);
                int gg = (int)(gray * mask);
                int bb = (int)(gray * mask);
                int dstPixOffset = dstPixelStride * col + row * dstLineStride;
                dstData[dstPixOffset + dstROffset] = (short)(rr < 0 ? 0 : (rr > 65535 ? 65535 : rr));
                dstData[dstPixOffset + dstGOffset] = (short)(gg < 0 ? 0 : (gg > 65535 ? 65535 : gg));
                dstData[dstPixOffset + dstBOffset] = (short)(bb < 0 ? 0 : (bb > 65535 ? 65535 : bb));
            }
        }
    }
}

