/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.jai.opimage;

import com.lightcrafts.media.jai.util.ImageUtil;
import com.lightcrafts.media.jai.util.JDKWorkarounds;
import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.PointOpImage;
import com.lightcrafts.mediax.jai.RasterAccessor;
import com.lightcrafts.mediax.jai.RasterFactory;
import com.lightcrafts.mediax.jai.RasterFormatTag;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;

final class LCBandCombineOpImage
extends PointOpImage {
    private double[][] matrix;

    public LCBandCombineOpImage(RenderedImage source, Map config, ImageLayout layout, double[][] matrix) {
        super(source, layout, config, true);
        this.matrix = matrix;
        int numBands = matrix.length;
        if (this.getSampleModel().getNumBands() != numBands) {
            this.sampleModel = RasterFactory.createComponentSampleModel((SampleModel)this.sampleModel, (int)this.sampleModel.getDataType(), (int)this.tileWidth, (int)this.tileHeight, (int)numBands);
            if (this.colorModel != null && !JDKWorkarounds.areCompatibleDataModels((SampleModel)this.sampleModel, (ColorModel)this.colorModel)) {
                this.colorModel = ImageUtil.getCompatibleColorModel((SampleModel)this.sampleModel, (Map)config);
            }
        }
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        RasterAccessor s = new RasterAccessor(sources[0], destRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor d = new RasterAccessor((Raster)dest, destRect, formatTags[1], this.getColorModel());
        switch (d.getDataType()) {
            case 0: {
                this.computeRectByte(s, d);
                break;
            }
            case 1: {
                this.computeRectUShort(s, d);
                break;
            }
            case 2: {
                this.computeRectShort(s, d);
                break;
            }
            case 3: {
                this.computeRectInt(s, d);
                break;
            }
            case 4: {
                this.computeRectFloat(s, d);
                break;
            }
            case 5: {
                this.computeRectDouble(s, d);
            }
        }
        if (d.isDataCopy()) {
            d.clampDataArrays();
            d.copyDataToRaster();
        }
    }

    private void computeRectByte(RasterAccessor src, RasterAccessor dst) {
        int sLineStride = src.getScanlineStride();
        int sPixelStride = src.getPixelStride();
        int sbands = src.getNumBands();
        int[] sBandOffsets = src.getBandOffsets();
        byte[][] sData = src.getByteDataArrays();
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int dbands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        byte[][] dData = dst.getByteDataArrays();
        if (sbands > 1 && sPixelStride > 1 && (dbands == 1 || dbands > 1 && dPixelStride > 1)) {
            byte[] ddData = dData[0];
            byte[] ssData = sData[0];
            int rows = this.matrix.length;
            int cols = this.matrix[0].length;
            int[][] sortedMatrix = new int[rows][cols];
            int[] bandOffsets = src.getOffsetsForBands();
            int minBandOffset = sBandOffsets[0];
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < cols - 1; ++j) {
                    sortedMatrix[i][j] = (int)(this.matrix[i][j < cols - 1 ? bandOffsets[j] : j] * 256.0 + 0.5);
                    if (j >= cols - 1) continue;
                    minBandOffset = sBandOffsets[j] < minBandOffset ? sBandOffsets[j] : minBandOffset;
                }
            }
            int sso = minBandOffset;
            int dso = 0;
            if (sbands == 3 && dbands == 3) {
                for (int h = 0; h < dheight; ++h) {
                    int spo = sso;
                    int dpo = dso;
                    for (int w = 0; w < dwidth; ++w) {
                        int[] mat = sortedMatrix[0];
                        int sum = mat[0] * (ssData[spo + 0] & 0xFF) + mat[1] * (ssData[spo + 1] & 0xFF) + mat[2] * (ssData[spo + 2] & 0xFF);
                        ddData[dpo + dBandOffsets[0]] = ImageUtil.clampByte((int)(sum / 256 + mat[3]));
                        mat = sortedMatrix[1];
                        sum = mat[0] * (ssData[spo + 0] & 0xFF) + mat[1] * (ssData[spo + 1] & 0xFF) + mat[2] * (ssData[spo + 2] & 0xFF);
                        ddData[dpo + dBandOffsets[1]] = ImageUtil.clampByte((int)(sum / 256 + mat[3]));
                        mat = sortedMatrix[2];
                        sum = mat[0] * (ssData[spo + 0] & 0xFF) + mat[1] * (ssData[spo + 1] & 0xFF) + mat[2] * (ssData[spo + 2] & 0xFF);
                        ddData[dpo + dBandOffsets[2]] = ImageUtil.clampByte((int)(sum / 256 + mat[3]));
                        spo += sPixelStride;
                        dpo += dPixelStride;
                    }
                    sso += sLineStride;
                    dso += dLineStride;
                }
            } else if (sbands == 3 && dbands == 1) {
                for (int h = 0; h < dheight; ++h) {
                    int spo = sso;
                    int dpo = dso;
                    for (int w = 0; w < dwidth; ++w) {
                        int[] mat = sortedMatrix[0];
                        int sum = mat[0] * (ssData[spo + 0] & 0xFF) + mat[1] * (ssData[spo + 1] & 0xFF) + mat[2] * (ssData[spo + 2] & 0xFF);
                        ddData[dpo + dBandOffsets[0]] = ImageUtil.clampByte((int)(sum / 256 + mat[3]));
                        spo += sPixelStride;
                        dpo += dPixelStride;
                    }
                    sso += sLineStride;
                    dso += dLineStride;
                }
            } else {
                for (int h = 0; h < dheight; ++h) {
                    int spo = sso;
                    int dpo = dso;
                    for (int w = 0; w < dwidth; ++w) {
                        for (int b = 0; b < dbands; ++b) {
                            int sum = 0;
                            int[] mat = sortedMatrix[b];
                            for (int k = 0; k < sbands; ++k) {
                                sum += mat[k] * (ssData[spo + k] & 0xFF) / 256;
                            }
                            ddData[dpo + dBandOffsets[b]] = ImageUtil.clampByte((int)(sum + mat[sbands]));
                        }
                        spo += sPixelStride;
                        dpo += dPixelStride;
                    }
                    sso += sLineStride;
                    dso += dLineStride;
                }
            }
        } else {
            int rows = this.matrix.length;
            int cols = this.matrix[0].length;
            int[][] intMatrix = new int[rows][cols];
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < cols - 1; ++j) {
                    intMatrix[i][j] = (int)(this.matrix[i][j] * 256.0 + 0.5);
                }
            }
            int sso = 0;
            int dso = 0;
            for (int h = 0; h < dheight; ++h) {
                int spo = sso;
                int dpo = dso;
                for (int w = 0; w < dwidth; ++w) {
                    for (int b = 0; b < dbands; ++b) {
                        int sum = 0;
                        int[] mat = intMatrix[b];
                        for (int k = 0; k < sbands; ++k) {
                            sum += mat[k] * (sData[k][spo + sBandOffsets[k]] & 0xFF) / 256;
                        }
                        dData[b][dpo + dBandOffsets[b]] = ImageUtil.clampByte((int)(sum + mat[sbands]));
                    }
                    spo += sPixelStride;
                    dpo += dPixelStride;
                }
                sso += sLineStride;
                dso += dLineStride;
            }
        }
    }

    private void computeRectUShort(RasterAccessor src, RasterAccessor dst) {
        int sLineStride = src.getScanlineStride();
        int sPixelStride = src.getPixelStride();
        int sbands = src.getNumBands();
        int[] sBandOffsets = src.getBandOffsets();
        short[][] sData = src.getShortDataArrays();
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int dbands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        short[][] dData = dst.getShortDataArrays();
        if (sbands > 1 && sPixelStride > 1 && (dbands == 1 || dbands > 1 && dPixelStride > 1)) {
            short[] ddData = dData[0];
            short[] ssData = sData[0];
            int rows = this.matrix.length;
            int cols = this.matrix[0].length;
            int[][] sortedMatrix = new int[rows][cols];
            int minBandOffset = sBandOffsets[0];
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < cols - 1; ++j) {
                    sortedMatrix[i][j] = (int)(this.matrix[i][j < cols - 1 ? sBandOffsets[j] : j] * 65536.0 + 0.5);
                    if (j >= cols - 1) continue;
                    minBandOffset = sBandOffsets[j] < minBandOffset ? sBandOffsets[j] : minBandOffset;
                }
            }
            int sso = minBandOffset;
            int dso = 0;
            if (sbands == 3 && dbands == 3) {
                for (int h = 0; h < dheight; ++h) {
                    int spo = sso;
                    int dpo = dso;
                    for (int w = 0; w < dwidth; ++w) {
                        int[] mat = sortedMatrix[0];
                        long sum = (long)mat[0] * (long)(ssData[spo + 0] & 0xFFFF) + (long)mat[1] * (long)(ssData[spo + 1] & 0xFFFF) + (long)mat[2] * (long)(ssData[spo + 2] & 0xFFFF);
                        ddData[dpo + dBandOffsets[0]] = ImageUtil.clampUShort((int)((int)(sum / 65536L + (long)mat[3])));
                        mat = sortedMatrix[1];
                        sum = (long)mat[0] * (long)(ssData[spo + 0] & 0xFFFF) + (long)mat[1] * (long)(ssData[spo + 1] & 0xFFFF) + (long)mat[2] * (long)(ssData[spo + 2] & 0xFFFF);
                        ddData[dpo + dBandOffsets[1]] = ImageUtil.clampUShort((int)((int)(sum / 65536L + (long)mat[3])));
                        mat = sortedMatrix[2];
                        sum = (long)mat[0] * (long)(ssData[spo + 0] & 0xFFFF) + (long)mat[1] * (long)(ssData[spo + 1] & 0xFFFF) + (long)mat[2] * (long)(ssData[spo + 2] & 0xFFFF);
                        ddData[dpo + dBandOffsets[2]] = ImageUtil.clampUShort((int)((int)(sum / 65536L + (long)mat[3])));
                        spo += sPixelStride;
                        dpo += dPixelStride;
                    }
                    sso += sLineStride;
                    dso += dLineStride;
                }
            } else if (sbands == 3 && dbands == 1) {
                for (int h = 0; h < dheight; ++h) {
                    int spo = sso;
                    int dpo = dso;
                    for (int w = 0; w < dwidth; ++w) {
                        int[] mat = sortedMatrix[0];
                        long sum = (long)mat[0] * (long)(ssData[spo + 0] & 0xFFFF) + (long)mat[1] * (long)(ssData[spo + 1] & 0xFFFF) + (long)mat[2] * (long)(ssData[spo + 2] & 0xFFFF);
                        ddData[dpo + dBandOffsets[0]] = ImageUtil.clampUShort((int)((int)(sum / 65536L + (long)mat[3])));
                        spo += sPixelStride;
                        dpo += dPixelStride;
                    }
                    sso += sLineStride;
                    dso += dLineStride;
                }
            } else {
                for (int h = 0; h < dheight; ++h) {
                    int spo = sso;
                    int dpo = dso;
                    for (int w = 0; w < dwidth; ++w) {
                        for (int b = 0; b < dbands; ++b) {
                            long sum = 0L;
                            int[] mat = sortedMatrix[b];
                            for (int k = 0; k < sbands; ++k) {
                                sum += (long)mat[k] * (long)(ssData[spo + k] & 0xFFFF) / 65536L;
                            }
                            ddData[dpo + dBandOffsets[b]] = ImageUtil.clampUShort((int)((int)(sum + (long)mat[sbands])));
                        }
                        spo += sPixelStride;
                        dpo += dPixelStride;
                    }
                    sso += sLineStride;
                    dso += dLineStride;
                }
            }
        } else {
            int rows = this.matrix.length;
            int cols = this.matrix[0].length;
            int[][] intMatrix = new int[rows][cols];
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < cols - 1; ++j) {
                    intMatrix[i][j] = (int)(this.matrix[i][j] * 65536.0 + 0.5);
                }
            }
            int sso = 0;
            int dso = 0;
            for (int h = 0; h < dheight; ++h) {
                int spo = sso;
                int dpo = dso;
                for (int w = 0; w < dwidth; ++w) {
                    for (int b = 0; b < dbands; ++b) {
                        long sum = 0L;
                        int[] mat = intMatrix[b];
                        for (int k = 0; k < sbands; ++k) {
                            sum += (long)mat[k] * (long)(sData[k][spo + sBandOffsets[k]] & 0xFFFF) / 65536L;
                        }
                        dData[b][dpo + dBandOffsets[b]] = ImageUtil.clampUShort((int)((int)(sum + (long)mat[sbands])));
                    }
                    spo += sPixelStride;
                    dpo += dPixelStride;
                }
                sso += sLineStride;
                dso += dLineStride;
            }
        }
    }

    private void computeRectShort(RasterAccessor src, RasterAccessor dst) {
        int sLineStride = src.getScanlineStride();
        int sPixelStride = src.getPixelStride();
        int sbands = src.getNumBands();
        int[] sBandOffsets = src.getBandOffsets();
        short[][] sData = src.getShortDataArrays();
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int dbands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        short[][] dData = dst.getShortDataArrays();
        int sso = 0;
        int dso = 0;
        for (int h = 0; h < dheight; ++h) {
            int spo = sso;
            int dpo = dso;
            for (int w = 0; w < dwidth; ++w) {
                for (int b = 0; b < dbands; ++b) {
                    double sum = 0.0;
                    double[] mat = this.matrix[b];
                    for (int k = 0; k < sbands; ++k) {
                        sum += mat[k] * (double)sData[k][spo + sBandOffsets[k]];
                    }
                    dData[b][dpo + dBandOffsets[b]] = ImageUtil.clampUShort((int)((int)(sum + mat[sbands])));
                }
                spo += sPixelStride;
                dpo += dPixelStride;
            }
            sso += sLineStride;
            dso += dLineStride;
        }
    }

    private void computeRectInt(RasterAccessor src, RasterAccessor dst) {
        int sLineStride = src.getScanlineStride();
        int sPixelStride = src.getPixelStride();
        int sbands = src.getNumBands();
        int[] sBandOffsets = src.getBandOffsets();
        int[][] sData = src.getIntDataArrays();
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int dbands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        int[][] dData = dst.getIntDataArrays();
        int sso = 0;
        int dso = 0;
        for (int h = 0; h < dheight; ++h) {
            int spo = sso;
            int dpo = dso;
            for (int w = 0; w < dwidth; ++w) {
                for (int b = 0; b < dbands; ++b) {
                    double sum = 0.0;
                    double[] mat = this.matrix[b];
                    for (int k = 0; k < sbands; ++k) {
                        sum += mat[k] * (double)sData[k][spo + sBandOffsets[k]];
                    }
                    dData[b][dpo + dBandOffsets[b]] = ImageUtil.clampRoundInt((double)(sum + mat[sbands]));
                }
                spo += sPixelStride;
                dpo += dPixelStride;
            }
            sso += sLineStride;
            dso += dLineStride;
        }
    }

    private void computeRectFloat(RasterAccessor src, RasterAccessor dst) {
        int sLineStride = src.getScanlineStride();
        int sPixelStride = src.getPixelStride();
        int sbands = src.getNumBands();
        int[] sBandOffsets = src.getBandOffsets();
        float[][] sData = src.getFloatDataArrays();
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int dbands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        float[][] dData = dst.getFloatDataArrays();
        int sso = 0;
        int dso = 0;
        for (int h = 0; h < dheight; ++h) {
            int spo = sso;
            int dpo = dso;
            for (int w = 0; w < dwidth; ++w) {
                for (int b = 0; b < dbands; ++b) {
                    double sum = 0.0;
                    double[] mat = this.matrix[b];
                    for (int k = 0; k < sbands; ++k) {
                        sum += mat[k] * (double)sData[k][spo + sBandOffsets[k]];
                    }
                    dData[b][dpo + dBandOffsets[b]] = (float)(sum + mat[sbands]);
                }
                spo += sPixelStride;
                dpo += dPixelStride;
            }
            sso += sLineStride;
            dso += dLineStride;
        }
    }

    private void computeRectDouble(RasterAccessor src, RasterAccessor dst) {
        int sLineStride = src.getScanlineStride();
        int sPixelStride = src.getPixelStride();
        int sbands = src.getNumBands();
        int[] sBandOffsets = src.getBandOffsets();
        double[][] sData = src.getDoubleDataArrays();
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int dbands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        double[][] dData = dst.getDoubleDataArrays();
        int sso = 0;
        int dso = 0;
        for (int h = 0; h < dheight; ++h) {
            int spo = sso;
            int dpo = dso;
            for (int w = 0; w < dwidth; ++w) {
                for (int b = 0; b < dbands; ++b) {
                    double sum = 0.0;
                    double[] mat = this.matrix[b];
                    for (int k = 0; k < sbands; ++k) {
                        sum += mat[k] * sData[k][spo + sBandOffsets[k]];
                    }
                    dData[b][dpo + dBandOffsets[b]] = sum + mat[sbands];
                }
                spo += sPixelStride;
                dpo += dPixelStride;
            }
            sso += sLineStride;
            dso += dLineStride;
        }
    }
}

