/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.jai.opimage;

import com.lightcrafts.jai.operator.LCColorConvertDescriptor;
import com.lightcrafts.mediax.jai.ColorSpaceJAI;
import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.PointOpImage;
import com.lightcrafts.mediax.jai.RasterFactory;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

final class LCColorConvertOpImage
extends PointOpImage {
    private static final ColorSpace rgbColorSpace = ColorSpace.getInstance(1000);
    private static SoftReference<Map<ArrayList<?>, ColorConvertOp>> softRef = null;
    private ImageParameters srcParam = null;
    private ImageParameters dstParam = null;
    private ImageParameters tempParam = null;
    private ColorConvertOp colorConvertOp = null;
    private int caseNumber;

    private static int intFromBigEndian(byte[] array, int index) {
        return (array[index] & 0xFF) << 24 | (array[index + 1] & 0xFF) << 16 | (array[index + 2] & 0xFF) << 8 | array[index + 3] & 0xFF;
    }

    private static void intToBigEndian(int value, byte[] array, int index) {
        array[index] = (byte)(value >> 24);
        array[index + 1] = (byte)(value >> 16);
        array[index + 2] = (byte)(value >> 8);
        array[index + 3] = (byte)value;
    }

    private static void setRenderingIntent(ICC_Profile profile, int renderingIntent) {
        byte[] theHeader = profile.getData(1751474532);
        LCColorConvertOpImage.intToBigEndian(renderingIntent, theHeader, 64);
        profile.setData(1751474532, theHeader);
    }

    private static int getRenderingIntent(ICC_Profile profile) {
        byte[] theHeader = profile.getData(1751474532);
        int renderingIntent = LCColorConvertOpImage.intFromBigEndian(theHeader, 64);
        return renderingIntent;
    }

    private static synchronized ColorConvertOp getColorConvertOp(ColorSpace src, ColorSpace dst, LCColorConvertDescriptor.RenderingIntent renderingIntent) {
        Map<Object, Object> colorConvertOpBuf;
        if (softRef == null || (colorConvertOpBuf = softRef.get()) == null) {
            colorConvertOpBuf = new HashMap();
            softRef = new SoftReference(colorConvertOpBuf);
        }
        ArrayList<ColorSpace> hashcode = new ArrayList<ColorSpace>(2);
        hashcode.add(0, src);
        hashcode.add(1, dst);
        ColorConvertOp op = (ColorConvertOp)colorConvertOpBuf.get(hashcode);
        if (op == null) {
            if (src instanceof ICC_ColorSpace && dst instanceof ICC_ColorSpace) {
                ICC_Profile dstProfile = ((ICC_ColorSpace)dst).getProfile();
                dstProfile = ICC_Profile.getInstance(dstProfile.getData());
                if (renderingIntent != LCColorConvertDescriptor.DEFAULT && LCColorConvertOpImage.getRenderingIntent(dstProfile) != renderingIntent.getValue()) {
                    dstProfile = ICC_Profile.getInstance(dstProfile.getData());
                    LCColorConvertOpImage.setRenderingIntent(dstProfile, renderingIntent.getValue());
                    dst = new ICC_ColorSpace(dstProfile);
                }
            }
            op = new ColorConvertOp(src, dst, null);
            colorConvertOpBuf.put(hashcode, op);
        }
        return op;
    }

    private static float getMinValue(int dataType) {
        float minValue;
        switch (dataType) {
            case 0: {
                minValue = 0.0f;
                break;
            }
            case 2: {
                minValue = -32768.0f;
                break;
            }
            case 1: {
                minValue = 0.0f;
                break;
            }
            case 3: {
                minValue = -2.1474836E9f;
                break;
            }
            default: {
                minValue = 0.0f;
            }
        }
        return minValue;
    }

    private static float getRange(int dataType) {
        float range;
        switch (dataType) {
            case 0: {
                range = 255.0f;
                break;
            }
            case 2: {
                range = 65535.0f;
                break;
            }
            case 1: {
                range = 65535.0f;
                break;
            }
            case 3: {
                range = 4.2949673E9f;
                break;
            }
            default: {
                range = 1.0f;
            }
        }
        return range;
    }

    public LCColorConvertOpImage(RenderedImage source, Map config, ImageLayout layout, ColorModel colorModel, LCColorConvertDescriptor.RenderingIntent renderingIntent) {
        super(source, layout, config, true);
        this.colorModel = colorModel;
        this.srcParam = new ImageParameters(source.getColorModel(), source.getSampleModel());
        this.dstParam = new ImageParameters(colorModel, this.sampleModel);
        ColorSpace srcColorSpace = this.srcParam.getColorModel().getColorSpace();
        ColorSpace dstColorSpace = this.dstParam.getColorModel().getColorSpace();
        if (srcColorSpace instanceof ColorSpaceJAI && dstColorSpace instanceof ColorSpaceJAI) {
            this.caseNumber = 1;
            this.tempParam = this.createTempParam();
        } else if (srcColorSpace instanceof ColorSpaceJAI) {
            if (dstColorSpace != rgbColorSpace) {
                this.caseNumber = 2;
                this.tempParam = this.createTempParam();
                this.colorConvertOp = LCColorConvertOpImage.getColorConvertOp(rgbColorSpace, dstColorSpace, renderingIntent);
            } else {
                this.caseNumber = 3;
            }
        } else if (dstColorSpace instanceof ColorSpaceJAI) {
            if (srcColorSpace != rgbColorSpace) {
                this.caseNumber = 4;
                this.tempParam = this.createTempParam();
                this.colorConvertOp = LCColorConvertOpImage.getColorConvertOp(srcColorSpace, rgbColorSpace, renderingIntent);
            } else {
                this.caseNumber = 5;
            }
        } else {
            this.caseNumber = 6;
            this.colorConvertOp = LCColorConvertOpImage.getColorConvertOp(srcColorSpace, dstColorSpace, renderingIntent);
        }
        this.permitInPlaceOperation();
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        switch (this.caseNumber) {
            case 1: {
                WritableRaster tempRas = this.computeRectColorSpaceJAIToRGB(sources[0], this.srcParam, null, this.tempParam);
                this.computeRectColorSpaceJAIFromRGB(tempRas, this.tempParam, dest, this.dstParam);
                break;
            }
            case 2: {
                WritableRaster tempRas = this.computeRectColorSpaceJAIToRGB(sources[0], this.srcParam, null, this.tempParam);
                this.computeRectNonColorSpaceJAI(tempRas, this.tempParam, dest, this.dstParam, destRect);
                break;
            }
            case 3: {
                this.computeRectColorSpaceJAIToRGB(sources[0], this.srcParam, dest, this.dstParam);
                break;
            }
            case 4: {
                WritableRaster tempRas = this.createTempWritableRaster(sources[0]);
                this.computeRectNonColorSpaceJAI(sources[0], this.srcParam, tempRas, this.tempParam, destRect);
                this.computeRectColorSpaceJAIFromRGB(tempRas, this.tempParam, dest, this.dstParam);
                break;
            }
            case 5: {
                this.computeRectColorSpaceJAIFromRGB(sources[0], this.srcParam, dest, this.dstParam);
                break;
            }
            case 6: {
                this.computeRectNonColorSpaceJAI(sources[0], this.srcParam, dest, this.dstParam, destRect);
            }
        }
    }

    private WritableRaster computeRectColorSpaceJAIToRGB(Raster src, ImageParameters srcParam, WritableRaster dest, ImageParameters dstParam) {
        src = this.convertRasterToUnsigned(src);
        ColorSpaceJAI colorSpaceJAI = (ColorSpaceJAI)srcParam.getColorModel().getColorSpace();
        dest = colorSpaceJAI.toRGB(src, srcParam.getComponentSize(), dest, dstParam.getComponentSize());
        dest = this.convertRasterToSigned(dest);
        return dest;
    }

    private WritableRaster computeRectColorSpaceJAIFromRGB(Raster src, ImageParameters srcParam, WritableRaster dest, ImageParameters dstParam) {
        src = this.convertRasterToUnsigned(src);
        ColorSpaceJAI colorSpaceJAI = (ColorSpaceJAI)dstParam.getColorModel().getColorSpace();
        dest = colorSpaceJAI.fromRGB(src, srcParam.getComponentSize(), dest, dstParam.getComponentSize());
        dest = this.convertRasterToSigned(dest);
        return dest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void computeRectNonColorSpaceJAI(Raster src, ImageParameters srcParam, WritableRaster dest, ImageParameters dstParam, Rectangle destRect) {
        if (!srcParam.isFloat() && !dstParam.isFloat()) {
            WritableRaster d;
            Raster s = src;
            if (s.getMinX() != destRect.x || s.getMinY() != destRect.y || s.getWidth() != destRect.width || s.getHeight() != destRect.height) {
                s = s.createChild(destRect.x, destRect.y, destRect.width, destRect.height, destRect.x, destRect.y, null);
            }
            if ((d = dest).getMinX() != destRect.x || d.getMinY() != destRect.y || d.getWidth() != destRect.width || d.getHeight() != destRect.height) {
                d = d.createWritableChild(destRect.x, destRect.y, destRect.width, destRect.height, destRect.x, destRect.y, null);
            }
            Class<ColorSpace> clazz = ColorSpace.class;
            // MONITORENTER : java.awt.color.ColorSpace.class
            this.colorConvertOp.filter(s, d);
            // MONITOREXIT : clazz
            return;
        }
        ColorSpace srcColorSpace = srcParam.getColorModel().getColorSpace();
        ColorSpace dstColorSpace = dstParam.getColorModel().getColorSpace();
        boolean srcFloat = srcParam.isFloat();
        float srcMinValue = srcParam.getMinValue();
        float srcRange = srcParam.getRange();
        boolean dstFloat = dstParam.isFloat();
        float dstMinValue = dstParam.getMinValue();
        float dstRange = dstParam.getRange();
        int rectYMax = destRect.y + destRect.height;
        int rectXMax = destRect.x + destRect.width;
        int numComponents = srcColorSpace.getNumComponents();
        float[] srcPixel = new float[numComponents];
        int y = destRect.y;
        while (y < rectYMax) {
            for (int x = destRect.x; x < rectXMax; ++x) {
                srcPixel = src.getPixel(x, y, srcPixel);
                if (!srcFloat) {
                    for (int i = 0; i < numComponents; ++i) {
                        srcPixel[i] = (srcPixel[i] - srcMinValue) / srcRange;
                    }
                }
                Class<ColorSpace> i = ColorSpace.class;
                // MONITORENTER : java.awt.color.ColorSpace.class
                float[] xyzPixel = srcColorSpace.toCIEXYZ(srcPixel);
                float[] dstPixel = dstColorSpace.fromCIEXYZ(xyzPixel);
                // MONITOREXIT : i
                if (!dstFloat) {
                    for (int i2 = 0; i2 < numComponents; ++i2) {
                        dstPixel[i2] = dstPixel[i2] * dstRange + dstMinValue;
                    }
                }
                dest.setPixel(x, y, dstPixel);
            }
            ++y;
        }
    }

    private ImageParameters createTempParam() {
        SampleModel sm;
        ColorModel cm;
        if (this.srcParam.getDataType() > this.dstParam.getDataType()) {
            cm = this.srcParam.getColorModel();
            sm = this.srcParam.getSampleModel();
        } else {
            cm = this.dstParam.getColorModel();
            sm = this.dstParam.getSampleModel();
        }
        cm = new ComponentColorModel(rgbColorSpace, cm.getComponentSize(), cm.hasAlpha(), cm.isAlphaPremultiplied(), cm.getTransparency(), sm.getDataType());
        return new ImageParameters(cm, sm);
    }

    private WritableRaster createTempWritableRaster(Raster src) {
        Point origin = new Point(src.getMinX(), src.getMinY());
        return RasterFactory.createWritableRaster((SampleModel)src.getSampleModel(), (Point)origin);
    }

    private Raster convertRasterToUnsigned(Raster ras) {
        int type = ras.getSampleModel().getDataType();
        if (type == 3 || type == 2) {
            int minX = ras.getMinX();
            int minY = ras.getMinY();
            int w = ras.getWidth();
            int h = ras.getHeight();
            int[] buf = ras.getPixels(minX, minY, w, h, (int[])null);
            this.convertBufferToUnsigned(buf, type);
            WritableRaster tempRas = this.createTempWritableRaster(ras);
            tempRas.setPixels(minX, minY, w, h, buf);
            return tempRas;
        }
        return ras;
    }

    private WritableRaster convertRasterToSigned(WritableRaster ras) {
        int type = ras.getSampleModel().getDataType();
        if (type == 3 || type == 2) {
            int minX = ras.getMinX();
            int minY = ras.getMinY();
            int w = ras.getWidth();
            int h = ras.getHeight();
            int[] buf = ras.getPixels(minX, minY, w, h, (int[])null);
            this.convertBufferToSigned(buf, type);
            ras.setPixels(minX, minY, w, h, buf);
        }
        return ras;
    }

    private void convertBufferToSigned(int[] buf, int type) {
        block4: {
            block3: {
                if (buf == null) {
                    return;
                }
                if (type != 2) break block3;
                int i = 0;
                while (i < buf.length) {
                    int n = i++;
                    buf[n] = buf[n] + Short.MIN_VALUE;
                }
                break block4;
            }
            if (type != 3) break block4;
            for (int i = 0; i < buf.length; ++i) {
                buf[i] = (int)(((long)buf[i] & 0xFFFFFFFFL) + Integer.MIN_VALUE);
            }
        }
    }

    private void convertBufferToUnsigned(int[] buf, int type) {
        block4: {
            block3: {
                if (buf == null) {
                    return;
                }
                if (type != 2) break block3;
                int i = 0;
                while (i < buf.length) {
                    int n = i++;
                    buf[n] = buf[n] - Short.MIN_VALUE;
                }
                break block4;
            }
            if (type != 3) break block4;
            for (int i = 0; i < buf.length; ++i) {
                buf[i] = (int)(((long)buf[i] & 0xFFFFFFFFL) - Integer.MIN_VALUE);
            }
        }
    }

    private final class ImageParameters {
        private boolean isFloat;
        private ColorModel colorModel;
        private SampleModel sampleModel;
        private float minValue;
        private float range;
        private int[] componentSize;
        private int dataType;

        ImageParameters(ColorModel cm, SampleModel sm) {
            this.colorModel = cm;
            this.sampleModel = sm;
            this.dataType = sm.getDataType();
            this.isFloat = this.dataType == 4 || this.dataType == 5;
            this.minValue = LCColorConvertOpImage.getMinValue(this.dataType);
            this.range = LCColorConvertOpImage.getRange(this.dataType);
            this.componentSize = cm.getComponentSize();
        }

        public boolean isFloat() {
            return this.isFloat;
        }

        public ColorModel getColorModel() {
            return this.colorModel;
        }

        public SampleModel getSampleModel() {
            return this.sampleModel;
        }

        public float getMinValue() {
            return this.minValue;
        }

        public float getRange() {
            return this.range;
        }

        public int[] getComponentSize() {
            return this.componentSize;
        }

        public int getDataType() {
            return this.dataType;
        }
    }
}

