/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.jai.opimage;

import com.lightcrafts.jai.opimage.Convolutions;
import com.lightcrafts.mediax.jai.AreaOpImage;
import com.lightcrafts.mediax.jai.BorderExtender;
import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.KernelJAI;
import com.lightcrafts.mediax.jai.RasterAccessor;
import com.lightcrafts.mediax.jai.RasterFormatTag;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;

final class LCSeparableConvolveOpImage
extends AreaOpImage {
    protected KernelJAI kernel;
    protected int kw;
    protected int kh;
    protected int kx;
    protected int ky;
    private float[] hValues;
    private float[] vValues;
    private final boolean INTERLEAVED3OPT = true;

    public LCSeparableConvolveOpImage(RenderedImage source, BorderExtender extender, Map config, ImageLayout layout, KernelJAI kernel) {
        super(source, layout, config, true, extender, kernel.getLeftPadding(), kernel.getRightPadding(), kernel.getTopPadding(), kernel.getBottomPadding());
        this.kernel = kernel;
        this.kw = kernel.getWidth();
        this.kh = kernel.getHeight();
        this.kx = kernel.getXOrigin();
        this.ky = kernel.getYOrigin();
        this.hValues = kernel.getHorizontalKernelData();
        this.vValues = kernel.getVerticalKernelData();
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        Raster source = sources[0];
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        RasterAccessor srcAccessor = new RasterAccessor(source, srcRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor dstAccessor = new RasterAccessor((Raster)dest, destRect, formatTags[1], this.getColorModel());
        switch (dstAccessor.getDataType()) {
            case 0: {
                this.byteLoop(srcAccessor, dstAccessor);
                break;
            }
            case 3: {
                this.intLoop(srcAccessor, dstAccessor);
                break;
            }
            case 2: {
                this.shortLoop(srcAccessor, dstAccessor);
                break;
            }
            case 1: {
                this.ushortLoop(srcAccessor, dstAccessor);
                break;
            }
            case 4: {
                this.floatLoop(srcAccessor, dstAccessor);
                break;
            }
            case 5: {
                this.doubleLoop(srcAccessor, dstAccessor);
                break;
            }
        }
        if (dstAccessor.isDataCopy()) {
            dstAccessor.clampDataArrays();
            dstAccessor.copyDataToRaster();
        }
    }

    protected void byteLoop(RasterAccessor src, RasterAccessor dst) {
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int dnumBands = dst.getNumBands();
        byte[][] dstDataArrays = dst.getByteDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        byte[][] srcDataArrays = src.getByteDataArrays();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        if (dstPixelStride == 3 && dstPixelStride == srcPixelStride) {
            int band0 = 0;
            for (int k = 1; k < dnumBands; ++k) {
                if (dstBandOffsets[k] >= dstBandOffsets[band0]) continue;
                band0 = k;
            }
            byte[] dstData = dstDataArrays[band0];
            byte[] srcData = srcDataArrays[band0];
            int srcScanlineOffset = srcBandOffsets[band0];
            int dstScanlineOffset = dstBandOffsets[band0];
            Convolutions.cInterleaved3ByteLoop(srcData, dstData, srcScanlineOffset, dstScanlineOffset, srcScanlineStride, dstScanlineStride, dheight, dwidth, this.kw, this.kh, this.hValues, this.vValues);
        } else {
            for (int k = 0; k < dnumBands; ++k) {
                byte[] dstData = dstDataArrays[k];
                byte[] srcData = srcDataArrays[k];
                int srcScanlineOffset = srcBandOffsets[k];
                int dstScanlineOffset = dstBandOffsets[k];
                Convolutions.cByteLoop(srcData, dstData, srcScanlineOffset, dstScanlineOffset, srcScanlineStride, dstScanlineStride, srcPixelStride, dstPixelStride, dheight, dwidth, this.kw, this.kh, this.hValues, this.vValues);
            }
        }
    }

    protected void shortLoop(RasterAccessor src, RasterAccessor dst) {
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int dnumBands = dst.getNumBands();
        short[][] dstDataArrays = dst.getShortDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        short[][] srcDataArrays = src.getShortDataArrays();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        if (dstPixelStride == 3 && dstPixelStride == srcPixelStride) {
            int band0 = 0;
            for (int k = 1; k < dnumBands; ++k) {
                if (dstBandOffsets[k] >= dstBandOffsets[band0]) continue;
                band0 = k;
            }
            short[] dstData = dstDataArrays[band0];
            short[] srcData = srcDataArrays[band0];
            int srcScanlineOffset = srcBandOffsets[band0];
            int dstScanlineOffset = dstBandOffsets[band0];
            Convolutions.cInterleaved3ShortLoop(srcData, dstData, srcScanlineOffset, dstScanlineOffset, srcScanlineStride, dstScanlineStride, dheight, dwidth, this.kw, this.kh, this.hValues, this.vValues);
        } else {
            for (int k = 0; k < dnumBands; ++k) {
                short[] dstData = dstDataArrays[k];
                short[] srcData = srcDataArrays[k];
                int srcScanlineOffset = srcBandOffsets[k];
                int dstScanlineOffset = dstBandOffsets[k];
                Convolutions.cShortLoop(srcData, dstData, srcScanlineOffset, dstScanlineOffset, srcScanlineStride, dstScanlineStride, srcPixelStride, dstPixelStride, dheight, dwidth, this.kw, this.kh, this.hValues, this.vValues);
            }
        }
    }

    protected void ushortLoop(RasterAccessor src, RasterAccessor dst) {
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int dnumBands = dst.getNumBands();
        short[][] dstDataArrays = dst.getShortDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        short[][] srcDataArrays = src.getShortDataArrays();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        if (dstPixelStride == 3 && dstPixelStride == srcPixelStride) {
            int band0 = 0;
            for (int k = 1; k < dnumBands; ++k) {
                if (dstBandOffsets[k] >= dstBandOffsets[band0]) continue;
                band0 = k;
            }
            short[] dstData = dstDataArrays[band0];
            short[] srcData = srcDataArrays[band0];
            int srcScanlineOffset = srcBandOffsets[band0];
            int dstScanlineOffset = dstBandOffsets[band0];
            Convolutions.cInterleaved3UShortLoop(srcData, dstData, srcScanlineOffset, dstScanlineOffset, srcScanlineStride, dstScanlineStride, dheight, dwidth, this.kw, this.kh, this.hValues, this.vValues);
        } else {
            for (int k = 0; k < dnumBands; ++k) {
                short[] dstData = dstDataArrays[k];
                short[] srcData = srcDataArrays[k];
                int srcScanlineOffset = srcBandOffsets[k];
                int dstScanlineOffset = dstBandOffsets[k];
                Convolutions.cUShortLoop(srcData, dstData, srcScanlineOffset, dstScanlineOffset, srcScanlineStride, dstScanlineStride, srcPixelStride, dstPixelStride, dheight, dwidth, this.kw, this.kh, this.hValues, this.vValues);
            }
        }
    }

    protected void intLoop(RasterAccessor src, RasterAccessor dst) {
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int dnumBands = dst.getNumBands();
        int[][] dstDataArrays = dst.getIntDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        int[][] srcDataArrays = src.getIntDataArrays();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        if (dstPixelStride == 3 && dstPixelStride == srcPixelStride) {
            int band0 = 0;
            for (int k = 1; k < dnumBands; ++k) {
                if (dstBandOffsets[k] >= dstBandOffsets[band0]) continue;
                band0 = k;
            }
            int[] dstData = dstDataArrays[band0];
            int[] srcData = srcDataArrays[band0];
            int srcScanlineOffset = srcBandOffsets[band0];
            int dstScanlineOffset = dstBandOffsets[band0];
            Convolutions.cInterleaved3IntLoop(srcData, dstData, srcScanlineOffset, dstScanlineOffset, srcScanlineStride, dstScanlineStride, dheight, dwidth, this.kw, this.kh, this.hValues, this.vValues);
        } else {
            for (int k = 0; k < dnumBands; ++k) {
                int[] dstData = dstDataArrays[k];
                int[] srcData = srcDataArrays[k];
                int srcScanlineOffset = srcBandOffsets[k];
                int dstScanlineOffset = dstBandOffsets[k];
                Convolutions.cIntLoop(srcData, dstData, srcScanlineOffset, dstScanlineOffset, srcScanlineStride, dstScanlineStride, srcPixelStride, dstPixelStride, dheight, dwidth, this.kw, this.kh, this.hValues, this.vValues);
            }
        }
    }

    protected void floatLoop(RasterAccessor src, RasterAccessor dst) {
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int dnumBands = dst.getNumBands();
        float[][] dstDataArrays = dst.getFloatDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        float[][] srcDataArrays = src.getFloatDataArrays();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        for (int k = 0; k < dnumBands; ++k) {
            float[] dstData = dstDataArrays[k];
            float[] srcData = srcDataArrays[k];
            int srcScanlineOffset = srcBandOffsets[k];
            int dstScanlineOffset = dstBandOffsets[k];
            Convolutions.cFloatLoop(srcData, dstData, srcScanlineOffset, dstScanlineOffset, srcScanlineStride, dstScanlineStride, srcPixelStride, dstPixelStride, dheight, dwidth, this.kw, this.kh, this.hValues, this.vValues);
        }
    }

    protected void doubleLoop(RasterAccessor src, RasterAccessor dst) {
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int dnumBands = dst.getNumBands();
        double[][] dstDataArrays = dst.getDoubleDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        double[][] srcDataArrays = src.getDoubleDataArrays();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        for (int k = 0; k < dnumBands; ++k) {
            double[] dstData = dstDataArrays[k];
            double[] srcData = srcDataArrays[k];
            int srcScanlineOffset = srcBandOffsets[k];
            int dstScanlineOffset = dstBandOffsets[k];
            Convolutions.cDoubleLoop(srcData, dstData, srcScanlineOffset, dstScanlineOffset, srcScanlineStride, dstScanlineStride, srcPixelStride, dstPixelStride, dheight, dwidth, this.kw, this.kh, this.hValues, this.vValues);
        }
    }

    static {
        System.loadLibrary("JAI");
    }
}

