/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.jai.opimage;

import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.PointOpImage;
import com.lightcrafts.mediax.jai.RasterAccessor;
import com.lightcrafts.mediax.jai.RasterFormatTag;
import com.lightcrafts.model.RGBColorSelection;
import com.lightcrafts.utils.LCMS;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;

public class RGBColorSelectionMaskOpImage
extends PointOpImage {
    private static LCMS.Transform ts = new LCMS.Transform(new LCMS.Profile(JAIContext.linearProfile), LCMS.TYPE_RGB_16, new LCMS.Profile(JAIContext.labProfile), LCMS.TYPE_Lab_16, 1, 0);
    private final RGBColorSelection colorSelection;
    private final float L;
    private final float a;
    private final float b;

    private static ImageLayout createLayout(RenderedImage source) {
        ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1003), false, false, 1, 0);
        ImageLayout layout = new ImageLayout(source);
        layout.setColorModel((ColorModel)cm);
        layout.setSampleModel(((ColorModel)cm).createCompatibleSampleModel(source.getWidth(), source.getHeight()));
        return layout;
    }

    public RGBColorSelectionMaskOpImage(RenderedImage source, RGBColorSelection colorSelection, Map config) {
        super(source, RGBColorSelectionMaskOpImage.createLayout(source), config, true);
        this.colorSelection = colorSelection;
        short[] labColors = new short[3];
        ts.doTransform(new short[]{(short)(colorSelection.red * 65535.0f), (short)(colorSelection.green * 65535.0f), (short)(colorSelection.blue * 65535.0f)}, labColors);
        this.L = (float)(0xFFFF & labColors[0]) / 65535.0f;
        this.a = (float)(0xFFFF & labColors[1]) / 65535.0f;
        this.b = (float)(0xFFFF & labColors[2]) / 65535.0f;
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        Raster source = sources[0];
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        RasterAccessor src = new RasterAccessor(source, srcRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor dst = new RasterAccessor((Raster)dest, destRect, formatTags[1], this.getColorModel());
        int width = dst.getWidth();
        int height = dst.getHeight();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstLineStride = dst.getScanlineStride();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcLineStride = src.getScanlineStride();
        int dstOffset = dstBandOffsets[0];
        float[] colorSelectionArray = new float[]{this.L, this.a, this.b, this.colorSelection.isColorEnabled ? this.colorSelection.radius : -1.0f, this.colorSelection.isLuminosityEnabled ? this.colorSelection.luminosityLower : 0.0f, this.colorSelection.isLuminosityEnabled ? this.colorSelection.luminosityLowerFeather : 0.0f, this.colorSelection.isLuminosityEnabled ? this.colorSelection.luminosityUpper : 1.0f, this.colorSelection.isLuminosityEnabled ? this.colorSelection.luminosityUpperFeather : 0.0f};
        if (src.getDataType() == 3 && dst.getDataType() == 3) {
            int[] srcData = src.getIntDataArray(0);
            int[] dstData = dst.getIntDataArray(0);
            this.nativeIntLoop(srcData, dstData, width, height, srcBandOffsets, dstOffset, srcLineStride, dstLineStride, colorSelectionArray, this.colorSelection.isInverted);
        } else if (src.getDataType() == 1 && dst.getDataType() == 0) {
            short[] srcData = src.getShortDataArray(0);
            byte[] dstData = dst.getByteDataArray(0);
            this.nativeUshortLoop(srcData, dstData, width, height, srcBandOffsets, dstOffset, srcLineStride, dstLineStride, colorSelectionArray, this.colorSelection.isInverted);
        } else {
            throw new UnsupportedOperationException("Unsupported data type pair: " + src.getDataType() + ", " + dst.getDataType());
        }
        dst.copyDataToRaster();
    }

    private native void nativeIntLoop(int[] var1, int[] var2, int var3, int var4, int[] var5, int var6, int var7, int var8, float[] var9, boolean var10);

    private native void nativeUshortLoop(short[] var1, byte[] var2, int var3, int var4, int[] var5, int var6, int var7, int var8, float[] var9, boolean var10);

    private void ushortLoop(short[] srcData, byte[] dstData, int width, int height, int[] srcBandOffsets, int dstOffset, int srcLineStride, int dstLineStride, float[] colorSelection) {
        int srcROffset = srcBandOffsets[0];
        int srcGOffset = srcBandOffsets[1];
        int srcBOffset = srcBandOffsets[2];
        float sL = colorSelection[0];
        float sa = colorSelection[1];
        float sb = colorSelection[2];
        float radius = colorSelection[3];
        float luminosityLower = colorSelection[4];
        float luminosityLowerFeather = colorSelection[5];
        float luminosityUpper = colorSelection[6];
        float luminosityUpperFeather = colorSelection[7];
        for (int row = 0; row < height; ++row) {
            for (int col = 0; col < width; ++col) {
                float colorMask;
                float L = 0xFFFF & srcData[3 * col + row * srcLineStride + srcROffset];
                float a = (float)(0xFFFF & srcData[3 * col + row * srcLineStride + srcGOffset]) / 65535.0f;
                float b = (float)(0xFFFF & srcData[3 * col + row * srcLineStride + srcBOffset]) / 65535.0f;
                if (radius >= 0.0f) {
                    float rmin = 3.0f * radius / 16.0f;
                    float rmax = 5.0f * radius / 16.0f;
                    float da = sa - a;
                    float db = sb - b;
                    float m = (float)Math.sqrt(da * da + db * db);
                    colorMask = m < rmin ? 1.0f : (m < rmax ? (rmax - m) / (rmax - rmin) : 0.0f);
                } else {
                    colorMask = 1.0f;
                }
                if (luminosityLower > 0.0f || luminosityUpper < 1.0f) {
                    float luminosity = (float)(Math.log1p(L / 256.0f) / (8.0 * Math.log(2.0)));
                    float brightnessMask = luminosity >= luminosityLower && luminosity <= luminosityUpper ? 1.0f : (luminosity >= luminosityLower - luminosityLowerFeather && luminosity < luminosityLower ? (luminosity - (luminosityLower - luminosityLowerFeather)) / luminosityLowerFeather : (luminosity > luminosityUpper && luminosity <= luminosityUpper + luminosityUpperFeather ? (luminosityUpper + luminosityUpperFeather - luminosity) / luminosityUpperFeather : 0.0f));
                    colorMask *= brightnessMask;
                }
                dstData[col + row * dstLineStride + dstOffset] = (byte)(255.0f * colorMask);
            }
        }
    }
}

