/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.jai.opimage;

import com.lightcrafts.jai.utils.Functions;
import com.lightcrafts.mediax.jai.AreaOpImage;
import com.lightcrafts.mediax.jai.BorderExtender;
import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.RasterAccessor;
import com.lightcrafts.mediax.jai.RasterFormatTag;
import com.lightcrafts.utils.DCRaw;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.Map;

public class RGBDemosaicOpImage
extends AreaOpImage {
    private static final BorderExtender copyExtender = BorderExtender.createInstance((int)0);
    private final int rx;
    private final int ry;
    private final int gx;
    private final int gy;
    private final int bx;
    private final int by;
    private ThreadLocal<Raster> tltmp = new ThreadLocal();

    public RGBDemosaicOpImage(RenderedImage source, Map config, int rawFilters) {
        this(source, config, new ImageLayout(source), rawFilters);
    }

    public RGBDemosaicOpImage(RenderedImage source, Map config, ImageLayout layout, int rawFilters) {
        super(source, layout, config, true, copyExtender, 4, 4, 4, 4);
        switch (rawFilters) {
            case 0x16161616: {
                this.rx = 1;
                this.ry = 1;
                this.gx = 1;
                this.gy = 0;
                this.bx = 0;
                this.by = 0;
                break;
            }
            case 0x61616161: {
                this.rx = 1;
                this.ry = 0;
                this.gx = 0;
                this.gy = 0;
                this.bx = 0;
                this.by = 1;
                break;
            }
            case 0x49494949: {
                this.rx = 0;
                this.ry = 1;
                this.gx = 0;
                this.gy = 0;
                this.bx = 1;
                this.by = 0;
                break;
            }
            case -1802201964: {
                this.rx = 0;
                this.ry = 0;
                this.gx = 1;
                this.gy = 0;
                this.bx = 1;
                this.by = 1;
                break;
            }
            default: {
                this.rx = 0;
                this.ry = 0;
                this.gx = 0;
                this.gy = 0;
                this.bx = 0;
                this.by = 0;
            }
        }
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        Rectangle imageRect = this.getBounds();
        imageRect.width -= 6;
        imageRect.height -= 6;
        if ((destRect = destRect.intersection(imageRect)).isEmpty()) {
            return;
        }
        Raster source = sources[0];
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        Rectangle tmpRect = new Rectangle(destRect.x - 4, destRect.y - 4, destRect.width + 8, destRect.height + 8);
        Raster tmp = this.tltmp.get();
        if (tmp == null || tmp.getWidth() != tmpRect.width || tmp.getHeight() != tmpRect.height) {
            tmp = Raster.createInterleavedRaster(1, tmpRect.width, tmpRect.height, 3, new Point(tmpRect.x, tmpRect.y));
            this.tltmp.set(tmp);
        } else {
            Arrays.fill(((DataBufferUShort)tmp.getDataBuffer()).getData(), (short)0);
            tmp = tmp.createTranslatedChild(tmpRect.x, tmpRect.y);
        }
        RasterAccessor srcAccessor = new RasterAccessor(source, srcRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor dstAccessor = new RasterAccessor((Raster)dest, destRect, formatTags[1], this.getColorModel());
        RasterAccessor tmpAccessor = new RasterAccessor(tmp, tmpRect, formatTags[1], this.getColorModel());
        assert (dstAccessor.getDataType() == 1);
        this.ushortLoop(srcAccessor, tmpAccessor);
        Functions.copyData(dest, tmp);
        if (dstAccessor.isDataCopy()) {
            dstAccessor.clampDataArrays();
            dstAccessor.copyDataToRaster();
        }
    }

    protected void ushortLoop(RasterAccessor src, RasterAccessor dst) {
        short[][] dstDataArrays = dst.getShortDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstScanlineStride = dst.getScanlineStride() / 3;
        short[][] srcDataArrays = src.getShortDataArrays();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcScanlineStride = src.getScanlineStride();
        short[] destData = dstDataArrays[0];
        short[] srcData = srcDataArrays[0];
        int srcOffset = srcBandOffsets[0];
        int rOffset = dstBandOffsets[0];
        int gOffset = dstBandOffsets[1];
        int bOffset = dstBandOffsets[2];
        int dWidth = dst.getWidth();
        int dHeight = dst.getHeight();
        DCRaw.interpolateGreen(srcData, destData, dWidth, dHeight, srcScanlineStride, dstScanlineStride, srcOffset, rOffset, gOffset, bOffset, this.gx, this.gy, this.ry);
        DCRaw.interpolateRedBlue(destData, dWidth, dHeight, dstScanlineStride, rOffset, gOffset, bOffset, this.rx, this.ry, this.bx, this.by);
    }
}

