/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.jai.utils;

import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.jai.operator.LCMSColorConvertDescriptor;
import com.lightcrafts.media.jai.util.ImageUtil;
import com.lightcrafts.mediax.jai.BorderExtender;
import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.Interpolation;
import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.KernelJAI;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.mediax.jai.RasterAccessor;
import com.lightcrafts.mediax.jai.RasterFormatTag;
import com.lightcrafts.mediax.jai.RenderedOp;
import com.lightcrafts.model.ImageEditor.ImageProcessor;
import com.lightcrafts.model.ImageEditor.Rendering;
import com.lightcrafts.model.Operation;
import com.lightcrafts.utils.ColorProfileInfo;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class Functions {
    public static boolean DEBUG = false;
    static NumberFormat fmt = DecimalFormat.getInstance();
    private static final ColorModel sRGBColorModel = new ComponentColorModel(JAIContext.sRGBColorSpace, false, false, 1, 0);

    public static RenderedOp crop(RenderedImage image, float x, float y, float width, float height, RenderingHints hints) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(image);
        pb.add(x);
        pb.add(y);
        pb.add(width);
        pb.add(height);
        return JAI.create((String)"Crop", (ParameterBlock)pb, (RenderingHints)hints);
    }

    public static PlanarImage scaledRendering(Rendering rendering, Operation op, float scale, boolean cheap) {
        Rendering newRendering = rendering.clone();
        float oldScale = rendering.getScaleFactor();
        newRendering.cheapScale = cheap;
        newRendering.setScaleFactor(scale * oldScale);
        return newRendering.getRendering(rendering.indexOf(op));
    }

    public static RenderedOp gaussianBlur(RenderedImage image, Rendering rendering, Operation op, double radius) {
        return Functions.gaussianBlur(image, rendering, op, null, radius);
    }

    public static RenderedOp gaussianBlur(RenderedImage image, Rendering rendering, Operation op, ImageProcessor processor, double radius) {
        RenderedImage scaleDown;
        double newRadius = radius;
        float rescale = 1.0f;
        int size = Math.min(image.getWidth(), image.getHeight());
        if (size > 256) {
            while (newRadius > 32.0) {
                newRadius /= 2.0;
                rescale /= 2.0f;
            }
        }
        RenderingHints extenderHints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
        Interpolation interp = Interpolation.getInstance((int)2);
        if (rescale != 1.0f) {
            scaleDown = Functions.scaledRendering(rendering, op, rescale, true);
            if (processor != null) {
                scaleDown = processor.process(scaleDown);
            }
        } else {
            scaleDown = processor != null ? processor.process(image) : image;
        }
        KernelJAI kernel = Functions.getGaussKernel(newRadius);
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(scaleDown);
        pb.add(kernel);
        RenderedOp blur = JAI.create((String)"LCSeparableConvolve", (ParameterBlock)pb, (RenderingHints)extenderHints);
        if (rescale != 1.0f) {
            pb = new ParameterBlock();
            pb.addSource(blur);
            pb.add(AffineTransform.getScaleInstance((double)image.getWidth() / (double)blur.getWidth(), (double)image.getHeight() / (double)blur.getHeight()));
            pb.add(interp);
            RenderingHints sourceLayoutHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, new ImageLayout(0, 0, 512, 512, null, null));
            sourceLayoutHints.add(extenderHints);
            return JAI.create((String)"Affine", (ParameterBlock)pb, (RenderingHints)sourceLayoutHints);
        }
        return blur;
    }

    public static ImageLayout getImageLayout(RenderedImage image) {
        return Functions.getImageLayout(image.getSampleModel().getDataType(), image.getColorModel().getColorSpace());
    }

    public static ImageLayout getImageLayout(RenderedImage image, int tileWidth, int tileHeight) {
        return Functions.getImageLayout(image.getSampleModel().getDataType(), image.getColorModel().getColorSpace(), tileWidth, tileHeight);
    }

    public static ImageLayout getImageLayout(RenderedImage image, int dataType) {
        return Functions.getImageLayout(dataType, image.getColorModel().getColorSpace());
    }

    public static ImageLayout getImageLayout(int dataType, ColorSpace cs) {
        return Functions.getImageLayout(dataType, cs, 512, 512);
    }

    public static ImageLayout getImageLayout(int dataType, ColorSpace cs, int tileWidth, int tileHeight) {
        ComponentColorModel cm = new ComponentColorModel(cs, false, false, 1, dataType);
        return new ImageLayout(0, 0, tileWidth, tileHeight, ((ColorModel)cm).createCompatibleSampleModel(tileWidth, tileHeight), (ColorModel)cm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float[] fromLinearToCS(ColorSpace target, float[] color) {
        Class<ColorSpace> clazz = ColorSpace.class;
        synchronized (ColorSpace.class) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return target.fromCIEXYZ(JAIContext.linearColorSpace.toCIEXYZ(color));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] fromLinearToCS(ColorSpace target, int[] color) {
        Class<ColorSpace> clazz = ColorSpace.class;
        synchronized (ColorSpace.class) {
            float[] converted = target.fromCIEXYZ(JAIContext.linearColorSpace.toCIEXYZ(new float[]{(float)color[0] / 255.0f, (float)color[1] / 255.0f, (float)color[2] / 255.0f}));
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return new int[]{(int)(255.0f * converted[0]), (int)(255.0f * converted[1]), (int)(255.0f * converted[2])};
        }
    }

    public static double gauss(double x, double s) {
        return Math.exp(-x * x / (2.0 * s * s));
    }

    public static double LoG(double x, double y, double s) {
        double exp = (x * x + y * y) / (2.0 * s * s);
        return -Math.exp(-exp) * (1.0 - exp);
    }

    public static double LoG(double x, double s) {
        double exp = x * x / (2.0 * s * s);
        return -Math.exp(-exp) * (1.0 - exp);
    }

    public static float[] generateLoGKernel(double theta, int kernelSize) {
        float[] logKernel = new float[kernelSize * kernelSize];
        int k = 0;
        double scale = 0.0;
        for (int j = 0; j < kernelSize; ++j) {
            for (int i = 0; i < kernelSize; ++i) {
                int x = -kernelSize / 2 + i;
                int y = -kernelSize / 2 + j;
                double value = Functions.LoG(x, y, theta);
                scale += value;
                logKernel[k++] = (float)value;
            }
        }
        int i = 0;
        while (i < logKernel.length) {
            int n = i++;
            logKernel[n] = (float)((double)logKernel[n] / scale);
        }
        return logKernel;
    }

    public static double logScale(double value, double max) {
        assert (value >= 0.0 && value <= 1.0);
        return Math.pow(max + 1.0, value) - 1.0;
    }

    public static KernelJAI LoGSharpenKernel(double radius, double gain) {
        if (radius < 1.0E-5) {
            radius = 1.0E-5;
        }
        int size = 5;
        float[] data = Functions.generateLoGKernel(radius, size);
        if (DEBUG) {
            System.out.println("kernel data: (" + radius + ") ");
        }
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                int n = i + size * j;
                data[n] = (float)((double)data[n] * gain);
                if (i == size / 2 && j == size / 2) {
                    int n2 = i + size * j;
                    data[n2] = (float)((double)data[n2] + (1.0 - gain));
                }
                if (!DEBUG) continue;
                System.out.print(fmt.format(data[i + size * j]) + " ");
            }
            if (!DEBUG) continue;
            System.out.println();
        }
        return new KernelJAI(size, size, data);
    }

    public static KernelJAI LoGSharpenKernel2(double radius, double gain) {
        if (radius < 1.0E-5) {
            radius = 1.0E-5;
        }
        int size = 5;
        float[] data = Functions.generateLoGKernel(radius, size);
        if (DEBUG) {
            System.out.println("kernel data: (" + radius + ") ");
        }
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                if (i == size / 2 && j == size / 2) {
                    data[i + size * j] = (float)(1.0 + gain * (double)(1.0f - data[i + size * j]));
                } else {
                    int n = i + size * j;
                    data[n] = (float)((double)data[n] * -gain);
                }
                if (!DEBUG) continue;
                System.out.print(fmt.format(data[i + size * j]) + " ");
            }
            if (!DEBUG) continue;
            System.out.println();
        }
        return new KernelJAI(size, size, data).getRotatedKernel();
    }

    public static KernelJAI getLoGKernel(double radius) {
        if (radius < 1.0E-5) {
            radius = 1.0E-5;
        }
        int size = (int)(6.0 * radius + 0.5);
        if ((size += 1 - size & 1) < 3) {
            size = 3;
        }
        float[] data = new float[size];
        if (DEBUG) {
            System.out.print("Radius: " + radius + ", kernel size: " + size + ", kernel data: ");
        }
        float positive = 0.0f;
        float negative = 0.0f;
        int x = -size / 2;
        int j = 0;
        while (x <= size / 2) {
            data[j] = (float)Functions.LoG(x, radius);
            if (data[j] > 0.0f) {
                positive += data[j];
            } else {
                negative += data[j];
            }
            if (DEBUG) {
                System.out.print(", " + data[j]);
            }
            ++x;
            ++j;
        }
        if (DEBUG) {
            System.out.println();
        }
        for (int i = 0; i < data.length; ++i) {
            if (!(data[i] > 0.0f)) continue;
            int n = i;
            data[n] = data[n] * (-negative / positive);
        }
        return new KernelJAI(size, size, size / 2, size / 2, data, data);
    }

    public static KernelJAI getLoGKernel(double radius, double gain) {
        if (radius < 1.0E-5) {
            radius = 1.0E-5;
        }
        int size = (int)(8.0 * radius + 0.5);
        if ((size += 1 - size & 1) < 3) {
            size = 3;
        }
        float[] data = new float[size];
        if (DEBUG) {
            System.out.print("Radius: " + radius + ", kernel size: " + size + ", kernel data: ");
        }
        float positive = 0.0f;
        float negative = 0.0f;
        float scale = 0.0f;
        int x = -size / 2;
        int j = 0;
        while (x <= size / 2) {
            data[j] = (float)Functions.LoG(x, radius);
            if (data[j] > 0.0f) {
                positive += data[j];
            } else {
                negative += data[j];
            }
            scale += data[j];
            if (DEBUG) {
                System.out.print(", " + data[j]);
            }
            ++x;
            ++j;
        }
        if (DEBUG) {
            System.out.println();
        }
        int i = 0;
        while (i < data.length) {
            int n = i++;
            data[n] = data[n] / scale;
        }
        return new KernelJAI(size, size, size / 2, size / 2, data, data);
    }

    public static KernelJAI getGaussKernel(double sigma) {
        if (sigma < 0.001) {
            sigma = 0.001;
        }
        int size = 2 * (int)Math.ceil(sigma) + 1;
        float[] data = new float[size];
        int j = 0;
        float scale = 0.0f;
        for (int x = -size / 2; x <= size / 2; ++x) {
            data[j++] = (float)Functions.gauss(x, sigma);
            scale += data[j - 1];
        }
        int i = 0;
        while (i < data.length) {
            int n = i++;
            data[n] = data[n] / scale;
        }
        return new KernelJAI(size, size, size / 2, size / 2, data, data);
    }

    public static KernelJAI getSincKernel(double sigma) {
        int size;
        if (sigma < 1.0E-5) {
            sigma = 1.0E-5;
        }
        if ((size = 4 * (int)Math.round(sigma) + 1) < 3) {
            size = 3;
        }
        float[] data = new float[size];
        if (DEBUG) {
            System.out.print("Radius: " + sigma + ", kernel size: " + size + ", kernel data: ");
        }
        int j = 0;
        float scale = 0.0f;
        for (int x = -size / 2; x <= size / 2; ++x) {
            data[j++] = x == 0 ? 1.0f : (float)Math.sin((double)x * sigma) / (float)x;
            scale += data[j - 1];
            if (!DEBUG) continue;
            System.out.print(", " + data[j - 1]);
        }
        if (DEBUG) {
            System.out.println();
        }
        int i = 0;
        while (i < data.length) {
            int n = i++;
            data[n] = data[n] / scale;
        }
        return new KernelJAI(size, size, size / 2, size / 2, data, data);
    }

    public static double lanczos2(double x) {
        if (x == 0.0) {
            return 1.0;
        }
        if (x > -2.0 && x < 2.0) {
            return Math.sin(Math.PI * x) * Math.sin(Math.PI * x / 2.0) / (Math.PI * Math.PI * x * x / 2.0);
        }
        return 0.0;
    }

    public static double lanczos3(double x) {
        if (x == 0.0) {
            return 1.0;
        }
        if (x > -3.0 && x < 3.0) {
            return Math.sin(Math.PI * x) * Math.sin(Math.PI * x / 3.0) / (Math.PI * Math.PI * x * x / 3.0);
        }
        return 0.0;
    }

    public static KernelJAI getLanczos2Kernel(int ratio) {
        int i;
        int samples = 4 * ratio + 1;
        float[] data = new float[samples];
        float sum = 0.0f;
        for (i = 0; i < samples; ++i) {
            data[i] = (float)Functions.lanczos2((double)i / (double)ratio - 2.0);
            sum += data[i];
        }
        i = 0;
        while (i < samples) {
            int n = i++;
            data[n] = data[n] / sum;
        }
        return new KernelJAI(samples, samples, samples / 2, samples / 2, data, data);
    }

    public static KernelJAI getHighPassKernel(double ratio) {
        int i;
        int samples = 4 * (int)(ratio + 0.5) + 1;
        float[] data = new float[samples];
        float sum = 0.0f;
        for (i = 0; i < samples; ++i) {
            data[i] = -((float)Functions.lanczos2((double)i / ratio - 2.0));
            sum += data[i];
        }
        i = 0;
        while (i < samples) {
            int n = i++;
            data[n] = data[n] / sum;
        }
        int n = samples / 2;
        data[n] = data[n] + 1.0f;
        return new KernelJAI(samples, samples, samples / 2, samples / 2, data, data);
    }

    public static ImageLayout getDirectImageLayout(int width, int height, ColorSpace cs) {
        ImageLayout layout = new ImageLayout();
        DirectColorModel cm = new DirectColorModel(cs, 32, 0xFF0000, 65280, 255, 0, false, 3);
        layout.setColorModel((ColorModel)cm);
        layout.setSampleModel(((ColorModel)cm).createCompatibleSampleModel(width, height));
        layout.setTileWidth(512);
        layout.setTileHeight(512);
        return layout;
    }

    public static BufferedImage toFastBufferedImage(RenderedImage image) {
        if (!(image instanceof BufferedImage) || ((BufferedImage)image).getType() != 1) {
            BufferedImage goodImage = new BufferedImage(image.getWidth(), image.getHeight(), image.getSampleModel().getNumBands() == 1 ? 10 : 1);
            Graphics2D big = (Graphics2D)goodImage.getGraphics();
            if (image instanceof PlanarImage) {
                sRGBWrapper opImage = image.getSampleModel().getNumBands() == 3 ? new sRGBWrapper(image) : PlanarImage.wrapRenderedImage((RenderedImage)image);
                big.drawRenderedImage((RenderedImage)((Object)opImage), AffineTransform.getTranslateInstance(-image.getMinX(), -image.getMinY()));
                opImage.dispose();
            } else if (image instanceof BufferedImage) {
                BufferedImage srgbImage = new BufferedImage(sRGBColorModel, ((BufferedImage)image).getRaster(), false, null);
                big.drawRenderedImage(srgbImage, new AffineTransform());
            }
            big.dispose();
            return goodImage;
        }
        return (BufferedImage)image;
    }

    public static RenderedOp fromByteToUShort(RenderedImage source, RenderingHints hints) {
        ComponentColorModel cm = new ComponentColorModel(source.getColorModel().getColorSpace(), false, false, 1, 1);
        RenderingHints formatHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, new ImageLayout(0, 0, 512, 512, cm.createCompatibleSampleModel(source.getWidth(), source.getHeight()), (ColorModel)cm));
        if (hints != null) {
            formatHints.add(hints);
        }
        double C0 = 0.0;
        double C1 = 256.0;
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(source);
        pb.add(new double[]{256.0});
        pb.add(new double[]{0.0});
        return JAI.create((String)"Rescale", (ParameterBlock)pb, (RenderingHints)formatHints);
    }

    public static RenderedOp fromShortToUShort(RenderedImage source, RenderingHints hints) {
        ComponentColorModel cm = new ComponentColorModel(source.getColorModel().getColorSpace(), false, false, 1, 1);
        RenderingHints formatHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, new ImageLayout(0, 0, 512, 512, cm.createCompatibleSampleModel(source.getWidth(), source.getHeight()), (ColorModel)cm));
        if (hints != null) {
            formatHints.add(hints);
        }
        double C0 = 0.0;
        double C1 = 1.0;
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(source);
        pb.add(new double[]{1.0});
        pb.add(new double[]{0.0});
        return JAI.create((String)"Rescale", (ParameterBlock)pb, (RenderingHints)formatHints);
    }

    public static RenderedOp fromUShortToByte(RenderedImage source, RenderingHints hints) {
        ComponentColorModel cm = new ComponentColorModel(source.getColorModel().getColorSpace(), false, false, 1, 0);
        RenderingHints formatHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, new ImageLayout(0, 0, 512, 512, cm.createCompatibleSampleModel(source.getWidth(), source.getHeight()), (ColorModel)cm));
        if (hints != null) {
            formatHints.add(hints);
        }
        double C0 = 0.0;
        double C1 = 0.00390625;
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(source);
        pb.add(new double[]{0.00390625});
        pb.add(new double[]{0.0});
        return JAI.create((String)"Rescale", (ParameterBlock)pb, (RenderingHints)formatHints);
    }

    public static PlanarImage toColorSpace(RenderedImage source, ColorSpace cs, ICC_Profile proof, LCMSColorConvertDescriptor.RenderingIntent intent, LCMSColorConvertDescriptor.RenderingIntent proofIntent, RenderingHints hints) {
        if (source.getColorModel().getColorSpace().equals(cs)) {
            return PlanarImage.wrapRenderedImage((RenderedImage)source);
        }
        ComponentColorModel cm = new ComponentColorModel(cs, false, false, 1, source.getColorModel().getTransferType());
        RenderingHints formatHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, new ImageLayout(0, 0, 512, 512, ((ColorModel)cm).createCompatibleSampleModel(source.getWidth(), source.getHeight()), (ColorModel)cm));
        if (hints != null) {
            formatHints.add(hints);
        }
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(source);
        pb.add(cm);
        if (intent != null) {
            pb.add((Object)intent);
        } else {
            pb.add((Object)LCMSColorConvertDescriptor.PERCEPTUAL);
        }
        if (proof != null) {
            pb.add(proof);
            if (proofIntent != null) {
                pb.add((Object)proofIntent);
            }
        }
        return JAI.create((String)"LCMSColorConvert", (ParameterBlock)pb, (RenderingHints)formatHints);
    }

    public static PlanarImage toColorSpace(RenderedImage source, ColorSpace cs, LCMSColorConvertDescriptor.RenderingIntent intent, RenderingHints hints) {
        return Functions.toColorSpace(source, cs, null, intent, null, hints);
    }

    public static PlanarImage toColorSpace(RenderedImage source, ColorSpace cs, RenderingHints hints) {
        return Functions.toColorSpace(source, cs, null, null, null, hints);
    }

    public static PlanarImage toUShortLinear(PlanarImage image, RenderingHints hints) {
        ICC_ColorSpace linearCS = JAIContext.linearColorSpace;
        if (image.getColorModel().getColorSpace().equals(linearCS) && image.getSampleModel().getDataType() == 1) {
            return image;
        }
        if (image.getColorModel().getColorSpace() == linearCS) {
            return image;
        }
        if (image.getSampleModel().getDataType() == 0) {
            return Functions.toColorSpace((RenderedImage)Functions.fromByteToUShort((RenderedImage)image, JAIContext.noCacheHint), linearCS, hints);
        }
        return Functions.toColorSpace((RenderedImage)image, linearCS, hints);
    }

    public static void intToBigEndian(int value, byte[] array, int index) {
        array[index] = (byte)(value >> 24);
        array[index + 1] = (byte)(value >> 16);
        array[index + 2] = (byte)(value >> 8);
        array[index + 3] = (byte)value;
    }

    public static void extractProfile(ICC_Profile profile, String path) {
        if (profile.getProfileClass() != 2) {
            byte[] theHeader = profile.getData(1751474532);
            Functions.intToBigEndian(1886549106, theHeader, 12);
            profile.setData(1751474532, theHeader);
        }
        String profileName = ColorProfileInfo.getNameOf(profile);
        try {
            profile.write(path + profileName + ".icc");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static WritableRaster copyData(WritableRaster raster, Raster source) {
        Rectangle region;
        if (raster == null) {
            region = source.getBounds();
            SampleModel sm = source.getSampleModel();
            if (sm.getWidth() != region.width || sm.getHeight() != region.height) {
                sm = sm.createCompatibleSampleModel(region.width, region.height);
            }
            raster = Raster.createWritableRaster(sm, region.getLocation());
        } else {
            region = raster.getBounds().intersection(source.getBounds());
            if (region.isEmpty()) {
                return raster;
            }
        }
        SampleModel[] sampleModels = new SampleModel[]{source.getSampleModel()};
        int tagID = RasterAccessor.findCompatibleTag((SampleModel[])sampleModels, (SampleModel)raster.getSampleModel());
        RasterFormatTag srcTag = new RasterFormatTag(source.getSampleModel(), tagID);
        RasterFormatTag dstTag = new RasterFormatTag(raster.getSampleModel(), tagID);
        Rectangle subRegion = region.intersection(source.getBounds());
        RasterAccessor s = new RasterAccessor(source, subRegion, srcTag, null);
        RasterAccessor d = new RasterAccessor((Raster)raster, subRegion, dstTag, null);
        if (source.getSampleModel() instanceof ComponentSampleModel && raster.getSampleModel() instanceof ComponentSampleModel) {
            ComponentSampleModel ssm = (ComponentSampleModel)source.getSampleModel();
            if (ssm.getPixelStride() == ssm.getNumBands() && source.getSampleModel().getNumBands() == raster.getSampleModel().getNumBands()) {
                Functions.fastCopyRaster(s, d);
            } else {
                ImageUtil.copyRaster((RasterAccessor)s, (RasterAccessor)d);
            }
        } else {
            ImageUtil.copyRaster((RasterAccessor)s, (RasterAccessor)d);
        }
        return raster;
    }

    private static void fastCopyRaster(RasterAccessor src, RasterAccessor dst) {
        Object[] d;
        Object[] s;
        int srcLineStride = src.getScanlineStride();
        int[] srcBandOffsets = src.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstLineStride = dst.getScanlineStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        int width = dst.getWidth() * dstPixelStride;
        int height = dst.getHeight() * dstLineStride;
        int dataType = src.getDataType();
        if (dataType == 0) {
            s = src.getByteDataArray(0);
            d = dst.getByteDataArray(0);
        } else if (dataType == 2 || dataType == 1) {
            s = src.getShortDataArray(0);
            d = dst.getShortDataArray(0);
        } else if (dataType == 3) {
            s = src.getIntDataArray(0);
            d = dst.getIntDataArray(0);
        } else if (dataType == 4) {
            s = src.getFloatDataArray(0);
            d = dst.getFloatDataArray(0);
        } else if (dataType == 5) {
            s = src.getDoubleDataArray(0);
            d = dst.getDoubleDataArray(0);
        } else {
            throw new IllegalArgumentException();
        }
        int srcOffset = Integer.MAX_VALUE;
        for (int offset : srcBandOffsets) {
            if (offset >= srcOffset) continue;
            srcOffset = offset;
        }
        int dstOffset = Integer.MAX_VALUE;
        for (int offset : dstBandOffsets) {
            if (offset >= dstOffset) continue;
            dstOffset = offset;
        }
        int heightEnd = dstOffset + height;
        int dstLineOffset = dstOffset;
        int srcLineOffset = srcOffset;
        while (dstLineOffset < heightEnd) {
            System.arraycopy(s, srcLineOffset, d, dstLineOffset, width);
            dstLineOffset += dstLineStride;
            srcLineOffset += srcLineStride;
        }
    }

    public static class CSWrapper
    extends PlanarImage {
        final RenderedImage source;

        static ImageLayout patchColorModel(ImageLayout layout, ColorModel cm) {
            layout.setColorModel(cm);
            return layout;
        }

        public CSWrapper(RenderedImage source, ColorSpace cs) {
            super(CSWrapper.patchColorModel(new ImageLayout(source), new ComponentColorModel(cs, false, false, 1, source.getColorModel().getTransferType())), null, null);
            this.source = source;
        }

        public Raster getTile(int tileX, int tileY) {
            return this.source.getTile(tileX, tileY);
        }
    }

    public static class sRGBWrapper
    extends PlanarImage {
        final RenderedImage source;

        static ImageLayout patchColorModel(ImageLayout layout, ColorModel cm) {
            layout.setColorModel(cm);
            return layout;
        }

        public sRGBWrapper(RenderedImage source) {
            super(sRGBWrapper.patchColorModel(new ImageLayout(source), new ComponentColorModel(source.getSampleModel().getNumBands() == 3 ? JAIContext.sRGBColorSpace : (source.getSampleModel().getNumBands() == 4 ? JAIContext.CMYKColorSpace : JAIContext.gray22ColorSpace), false, false, 1, 0)), null, null);
            this.source = source;
        }

        public Raster getTile(int tileX, int tileY) {
            return this.source.getTile(tileX, tileY);
        }
    }
}

