/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.jai.utils;

import com.lightcrafts.jai.utils.Job;
import com.lightcrafts.jai.utils.Request;
import com.lightcrafts.jai.utils.RequestJob;
import com.lightcrafts.jai.utils.TileJob;
import com.lightcrafts.jai.utils.WorkerThread;
import com.lightcrafts.media.jai.util.ImageUtil;
import com.lightcrafts.mediax.jai.OpImage;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.mediax.jai.TileCache;
import com.lightcrafts.mediax.jai.TileComputationListener;
import com.lightcrafts.mediax.jai.TileRequest;
import com.lightcrafts.mediax.jai.TileScheduler;
import com.lightcrafts.mediax.jai.util.ImagingException;
import com.lightcrafts.mediax.jai.util.ImagingListener;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class LCTileScheduler
implements TileScheduler {
    private static final int NUM_THREADS_DEFAULT = 2;
    private static final int NUM_PREFETCH_THREADS_DEFAULT = 1;
    private static int numInstances = 0;
    private ThreadGroup rootGroup;
    private ThreadGroup standardGroup;
    private ThreadGroup prefetchGroup;
    private int parallelism = 2;
    private int prefetchParallelism = 1;
    private int priority = 5;
    private int prefetchPriority = 1;
    private final LinkedList<Object> queue;
    private final LinkedList<Object> prefetchQueue;
    private LinkedList<Thread> workers = new LinkedList();
    private LinkedList<Thread> prefetchWorkers = new LinkedList();
    private int numWorkerThreads = 0;
    private int numPrefetchThreads = 0;
    private final Map<Object, Object[]> tilesInProgress = new HashMap<Object, Object[]>();
    final Map<Object, List<Request>> tileRequests = new HashMap<Object, List<Request>>();
    Map<Object, Job> tileJobs = new HashMap<Object, Job>();
    private String nameOfThisInstance;

    static Object tileKey(PlanarImage owner, int tileX, int tileY) {
        long idx = (long)tileY * (long)owner.getNumXTiles() + (long)tileX;
        BigInteger imageID = (BigInteger)owner.getImageID();
        byte[] buf = imageID.toByteArray();
        int length = buf.length;
        byte[] buf1 = new byte[length + 8];
        System.arraycopy(buf, 0, buf1, 0, length);
        int i = 7;
        int j = 0;
        while (i >= 0) {
            buf1[length++] = (byte)(idx >> j);
            --i;
            j += 8;
        }
        return new BigInteger(buf1);
    }

    static Set<TileComputationListener> getListeners(List<Request> reqList) {
        HashSet<TileComputationListener> listeners = null;
        for (Request req : reqList) {
            if (req.listeners == null || req.listeners.isEmpty()) continue;
            if (listeners == null) {
                listeners = new HashSet<TileComputationListener>();
            }
            listeners.addAll(req.listeners);
        }
        return listeners;
    }

    public LCTileScheduler(int parallelism, int priority, int prefetchParallelism, int prefetchPriority) {
        this();
        this.setParallelism(parallelism);
        this.setPriority(priority);
        this.setPrefetchParallelism(prefetchParallelism);
        this.setPrefetchPriority(prefetchPriority);
    }

    public LCTileScheduler() {
        this.queue = new LinkedList();
        this.prefetchQueue = new LinkedList();
        String name = "LCTileSchedulerName";
        this.nameOfThisInstance = name + numInstances;
        this.rootGroup = new ThreadGroup(this.nameOfThisInstance);
        this.rootGroup.setDaemon(true);
        this.standardGroup = new ThreadGroup(this.rootGroup, this.nameOfThisInstance + "Standard");
        this.standardGroup.setDaemon(true);
        this.prefetchGroup = new ThreadGroup(this.rootGroup, this.nameOfThisInstance + "Prefetch");
        this.prefetchGroup.setDaemon(true);
        ++numInstances;
    }

    Exception compute(PlanarImage owner, Point[] tileIndices, Raster[] tiles, int offset, int numTiles, Request request) {
        Exception exception = null;
        int j = offset;
        if (request == null || request.listeners == null) {
            int i = 0;
            while (i < numTiles) {
                Point p = tileIndices[j];
                try {
                    tiles[j] = owner.getTile(p.x, p.y);
                }
                catch (Exception e) {
                    exception = e;
                    break;
                }
                ++i;
                ++j;
            }
        } else {
            TileRequest[] reqs = new Request[]{request};
            int i = 0;
            while (i < numTiles) {
                Point p = tileIndices[j];
                Integer tileStatus = 1;
                request.tileStatus.put(p, tileStatus);
                try {
                    tiles[j] = owner.getTile(p.x, p.y);
                    for (TileComputationListener listener : request.listeners) {
                        tileStatus = 2;
                        request.tileStatus.put(p, tileStatus);
                        listener.tileComputed((Object)this, reqs, owner, p.x, p.y, tiles[j]);
                    }
                }
                catch (Exception e) {
                    exception = e;
                    break;
                }
                ++i;
                ++j;
            }
        }
        if (exception != null && request != null && request.listeners != null) {
            int lastOffset = j;
            int numFailed = numTiles - (lastOffset - offset);
            int k = lastOffset;
            for (int i = 0; i < numFailed; ++i) {
                Integer tileStatus = 4;
                request.tileStatus.put(tileIndices[k++], tileStatus);
            }
            TileRequest[] reqs = new Request[]{request};
            int k2 = lastOffset;
            for (int i = 0; i < numFailed; ++i) {
                Point p = tileIndices[k2++];
                for (TileComputationListener listener : request.listeners) {
                    listener.tileComputationFailure((Object)this, reqs, owner, p.x, p.y, (Throwable)exception);
                }
            }
        }
        return exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Raster scheduleTile(OpImage owner, int tileX, int tileY) {
        Raster tile;
        block22: {
            Object[] cache;
            block23: {
                boolean computeTile;
                if (owner == null) {
                    throw new IllegalArgumentException("Null owner");
                }
                tile = null;
                Object tileID = LCTileScheduler.tileKey((PlanarImage)owner, tileX, tileY);
                Map<Object, Object[]> map = this.tilesInProgress;
                synchronized (map) {
                    computeTile = !this.tilesInProgress.containsKey(tileID);
                    if (computeTile) {
                        cache = new Object[1];
                        this.tilesInProgress.put(tileID, cache);
                    } else {
                        cache = this.tilesInProgress.get(tileID);
                    }
                }
                if (!computeTile) break block23;
                try {
                    try {
                        tile = owner.computeTile(tileX, tileY);
                    }
                    catch (OutOfMemoryError e) {
                        block21: {
                            TileCache tileCache = owner.getTileCache();
                            if (tileCache != null) {
                                tileCache.removeTiles((RenderedImage)owner);
                            }
                            try {
                                tile = owner.computeTile(tileX, tileY);
                            }
                            catch (OutOfMemoryError e1) {
                                if (tileCache == null) break block21;
                                tileCache.flush();
                            }
                        }
                        tile = owner.computeTile(tileX, tileY);
                    }
                    cache[0] = tile != null ? tile : new Object();
                }
                catch (Throwable e) {
                    try {
                        if (e instanceof Error) {
                            throw (Error)e;
                        }
                        this.sendExceptionToListener("RuntimeException", e);
                        cache[0] = tile != null ? tile : new Object();
                    }
                    catch (Throwable throwable) {
                        cache[0] = tile != null ? tile : new Object();
                        cache.notifyAll();
                        this.tilesInProgress.remove(tileID);
                        throw throwable;
                    }
                    cache.notifyAll();
                    this.tilesInProgress.remove(tileID);
                    break block22;
                }
                cache.notifyAll();
                this.tilesInProgress.remove(tileID);
                break block22;
            }
            if (cache[0] == null) {
                try {
                    cache.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (cache[0] instanceof Raster) {
                tile = (Raster)cache[0];
            } else {
                throw new RuntimeException("Not a Raster instance?");
            }
        }
        return tile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object scheduleJob(PlanarImage owner, Point[] tileIndices, boolean isBlocking, boolean isPrefetch, TileComputationListener[] listeners) {
        Exception e;
        int numThreads;
        Raster[] tiles;
        if (owner == null || tileIndices == null) {
            throw new IllegalArgumentException();
        }
        if ((isBlocking || isPrefetch) && listeners != null) {
            throw new IllegalArgumentException();
        }
        if (isBlocking && isPrefetch) {
            throw new IllegalArgumentException();
        }
        int numTiles = tileIndices.length;
        Object returnValue = tiles = new Raster[numTiles];
        Job[] jobs = null;
        int numJobs = 0;
        LinkedList<Thread> linkedList = this.getWorkers(isPrefetch);
        synchronized (linkedList) {
            numThreads = this.getNumThreads(isPrefetch);
            if (numThreads > 0) {
                if (numTiles <= numThreads || !isBlocking && !isPrefetch) {
                    jobs = new Job[numTiles];
                    if (!isBlocking && !isPrefetch) {
                        Request request = new Request(this, owner, tileIndices, listeners);
                        returnValue = request;
                        while (numJobs < numTiles) {
                            Point p = tileIndices[numJobs];
                            Object tileID = LCTileScheduler.tileKey(owner, p.x, p.y);
                            Map<Object, List<Request>> map = this.tileRequests;
                            synchronized (map) {
                                List<Request> reqList = this.tileRequests.get(tileID);
                                if (reqList != null) {
                                    reqList.add(request);
                                    --numTiles;
                                } else {
                                    reqList = new ArrayList<Request>();
                                    reqList.add(request);
                                    this.tileRequests.put(tileID, reqList);
                                    jobs[numJobs] = new RequestJob(this, owner, p.x, p.y, tiles, numJobs);
                                    this.tileJobs.put(tileID, jobs[numJobs]);
                                    this.addJob(jobs[numJobs++], false);
                                }
                            }
                        }
                    } else {
                        while (numJobs < numTiles) {
                            jobs[numJobs] = new TileJob(this, isBlocking, owner, tileIndices, tiles, numJobs, 1);
                            this.addJob(jobs[numJobs++], isPrefetch);
                        }
                    }
                } else {
                    float frac = 1.0f / (2.0f * (float)numThreads);
                    int minTilesPerThread = numThreads == 1 ? numTiles : Math.min(Math.max(1, (int)(frac * (float)numTiles / 2.0f + 0.5f)), numTiles);
                    int maxNumJobs = numThreads == 1 ? 1 : (int)((float)numTiles / (float)minTilesPerThread + 0.5f);
                    jobs = new TileJob[maxNumJobs];
                    int numTilesQueued = 0;
                    int numTilesLeft = numTiles - numTilesQueued;
                    while (numTilesLeft > 0) {
                        int numTilesInThread = (int)(frac * (float)numTilesLeft + 0.5f);
                        if (numTilesInThread < minTilesPerThread) {
                            numTilesInThread = minTilesPerThread;
                        }
                        if (numTilesInThread > numTilesLeft) {
                            numTilesInThread = numTilesLeft;
                        }
                        if ((numTilesLeft -= numTilesInThread) < minTilesPerThread) {
                            numTilesInThread += numTilesLeft;
                            numTilesLeft = 0;
                        }
                        jobs[numJobs] = new TileJob(this, isBlocking, owner, tileIndices, tiles, numTilesQueued, numTilesInThread);
                        this.addJob(jobs[numJobs++], isPrefetch);
                        numTilesQueued += numTilesInThread;
                    }
                }
            }
        }
        if (numThreads != 0) {
            if (isBlocking) {
                for (int i = 0; i < numJobs; ++i) {
                    LCTileScheduler frac = this;
                    synchronized (frac) {
                        while (jobs[i].notDone()) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException minTilesPerThread) {}
                        }
                    }
                    e = jobs[i].getException();
                    if (e == null) continue;
                    String message = "Exception while scheduling tiles: ";
                    this.sendExceptionToListener(message, (Throwable)new ImagingException(message, (Throwable)e));
                }
            }
        } else {
            Request request = null;
            if (!isBlocking && !isPrefetch) {
                request = new Request(this, owner, tileIndices, listeners);
                returnValue = request;
            }
            if ((e = this.compute(owner, tileIndices, tiles, 0, numTiles, request)) != null) {
                String message = "Exception while scheduling tiles: ";
                this.sendExceptionToListener(message, (Throwable)new ImagingException(message, (Throwable)e));
            }
        }
        return returnValue;
    }

    public Raster[] scheduleTiles(OpImage owner, Point[] tileIndices) {
        if (owner == null || tileIndices == null) {
            throw new IllegalArgumentException("Null owner or TileIndices");
        }
        return (Raster[])this.scheduleJob((PlanarImage)owner, tileIndices, true, false, null);
    }

    public TileRequest scheduleTiles(PlanarImage target, Point[] tileIndices, TileComputationListener[] tileListeners) {
        if (target == null || tileIndices == null) {
            throw new IllegalArgumentException("Null owner or TileIndices");
        }
        return (TileRequest)this.scheduleJob(target, tileIndices, false, false, tileListeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelTiles(TileRequest request, Point[] tileIndices) {
        if (request == null) {
            throw new IllegalArgumentException("Null TileRequest");
        }
        Request req = (Request)request;
        Map<Object, List<Request>> map = this.tileRequests;
        synchronized (map) {
            Point[] indices;
            List<Point> reqIndexList = req.indices;
            if (tileIndices != null && tileIndices.length > 0) {
                List<Point> tileIndexList = Arrays.asList(tileIndices);
                tileIndexList.retainAll(reqIndexList);
                indices = tileIndexList.toArray(new Point[tileIndexList.size()]);
            } else {
                indices = reqIndexList.toArray(new Point[reqIndexList.size()]);
            }
            Integer tileStatus = 3;
            for (Point p : indices) {
                Object tileID = LCTileScheduler.tileKey(req.image, p.x, p.y);
                List<Request> reqList = this.tileRequests.get(tileID);
                if (reqList == null) continue;
                reqList.remove(req);
                if (reqList.isEmpty()) {
                    LinkedList<Object> linkedList = this.queue;
                    synchronized (linkedList) {
                        Job job = this.tileJobs.remove(tileID);
                        if (job != null) {
                            this.queue.remove(job);
                        }
                    }
                    this.tileRequests.remove(tileID);
                }
                req.tileStatus.put(p, tileStatus);
                if (req.listeners == null) continue;
                TileRequest[] reqArray = new TileRequest[]{req};
                for (TileComputationListener listener : req.listeners) {
                    listener.tileCancelled((Object)this, reqArray, req.image, p.x, p.y);
                }
            }
        }
    }

    public void prefetchTiles(PlanarImage owner, Point[] tileIndices) {
        if (owner == null || tileIndices == null) {
            throw new IllegalArgumentException("Null owner or TileIndices");
        }
        this.scheduleJob(owner, tileIndices, false, true, null);
    }

    public void setParallelism(int parallelism) {
        if (parallelism < 0) {
            throw new IllegalArgumentException("Negative Parallelism?");
        }
        this.parallelism = parallelism;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public void setPrefetchParallelism(int parallelism) {
        if (parallelism < 0) {
            throw new IllegalArgumentException("Negative Parallelism?");
        }
        this.prefetchParallelism = parallelism;
    }

    public int getPrefetchParallelism() {
        return this.prefetchParallelism;
    }

    public void setPriority(int priority) {
        this.priority = Math.max(Math.min(priority, 10), 1);
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPrefetchPriority(int priority) {
        this.prefetchPriority = Math.max(Math.min(priority, 10), 1);
    }

    public int getPrefetchPriority() {
        return this.prefetchPriority;
    }

    private void createThreadGroup(boolean isPrefetch) {
        if (this.rootGroup == null || this.rootGroup.isDestroyed()) {
            this.rootGroup = new ThreadGroup(this.nameOfThisInstance);
            this.rootGroup.setDaemon(true);
        }
        if (isPrefetch && (this.prefetchGroup == null || this.prefetchGroup.isDestroyed())) {
            this.prefetchGroup = new ThreadGroup(this.rootGroup, this.nameOfThisInstance + "Prefetch");
            this.prefetchGroup.setDaemon(true);
        }
        if (!isPrefetch && (this.standardGroup == null || this.standardGroup.isDestroyed())) {
            this.standardGroup = new ThreadGroup(this.rootGroup, this.nameOfThisInstance + "Standard");
            this.standardGroup.setDaemon(true);
        }
        LinkedList<Thread> thr = this.getWorkers(isPrefetch);
        for (Thread t : thr) {
            if (t.isAlive()) continue;
            thr.remove(t);
        }
        if (isPrefetch) {
            this.numPrefetchThreads = thr.size();
        } else {
            this.numWorkerThreads = thr.size();
        }
    }

    private int getNumThreads(boolean isPrefetch) {
        int prty;
        int prll;
        int nthr;
        this.createThreadGroup(isPrefetch);
        LinkedList<Thread> thr = this.getWorkers(isPrefetch);
        if (isPrefetch) {
            nthr = this.numPrefetchThreads;
            prll = this.prefetchParallelism;
            prty = this.prefetchPriority;
        } else {
            nthr = this.numWorkerThreads;
            prll = this.parallelism;
            prty = this.priority;
        }
        if (nthr > 0 && thr.get(0).getPriority() != prty) {
            for (Thread t : thr) {
                if (t == null || t.getThreadGroup() == null) continue;
                t.setPriority(prty);
            }
        }
        if (nthr < prll) {
            while (nthr < prll) {
                WorkerThread t = new WorkerThread(isPrefetch ? this.prefetchGroup : this.standardGroup, this, isPrefetch);
                t.setPriority(prty);
                thr.add(t);
                ++nthr;
            }
        } else {
            while (nthr > prll) {
                this.addJob(WorkerThread.TERMINATE, isPrefetch);
                --nthr;
            }
        }
        if (isPrefetch) {
            this.numPrefetchThreads = nthr;
        } else {
            this.numWorkerThreads = nthr;
        }
        return nthr;
    }

    LinkedList<Thread> getWorkers(boolean isPrefetch) {
        return isPrefetch ? this.workers : this.prefetchWorkers;
    }

    LinkedList<Object> getQueue(boolean isPrefetch) {
        return isPrefetch ? this.prefetchQueue : this.queue;
    }

    private void addJob(Object job, boolean isPrefetch) {
        if (job == null || job != WorkerThread.TERMINATE && !(job instanceof Job)) {
            throw new IllegalArgumentException();
        }
        LinkedList<Object> jobQueue = this.getQueue(isPrefetch);
        if (isPrefetch || jobQueue.isEmpty() || job instanceof RequestJob) {
            jobQueue.addLast(job);
        } else {
            boolean inserted = false;
            for (int idx = jobQueue.size() - 1; idx >= 0; --idx) {
                if (!(jobQueue.get(idx) instanceof TileJob)) continue;
                jobQueue.add(idx + 1, job);
                inserted = true;
                break;
            }
            if (!inserted) {
                jobQueue.addFirst(job);
            }
        }
        jobQueue.notify();
    }

    protected void finalize() throws Throwable {
        this.terminateAll(false);
        this.terminateAll(true);
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminateAll(boolean isPrefetch) {
        LinkedList<Thread> linkedList = this.getWorkers(isPrefetch);
        synchronized (linkedList) {
            int numThreads = isPrefetch ? this.numPrefetchThreads : this.numWorkerThreads;
            for (int i = 0; i < numThreads; ++i) {
                this.addJob(WorkerThread.TERMINATE, isPrefetch);
                if (isPrefetch) {
                    --this.numPrefetchThreads;
                    continue;
                }
                --this.numWorkerThreads;
            }
        }
    }

    void sendExceptionToListener(String message, Throwable e) {
        ImagingListener listener = ImageUtil.getImagingListener((RenderingHints)null);
        listener.errorOccurred(message, e, (Object)this, false);
    }
}

