/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.jai.utils;

import com.lightcrafts.jai.utils.Job;
import com.lightcrafts.jai.utils.LCTileScheduler;
import com.lightcrafts.jai.utils.Request;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.mediax.jai.TileComputationListener;
import com.lightcrafts.mediax.jai.TileRequest;
import java.awt.Point;
import java.awt.image.Raster;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class RequestJob
implements Job {
    final LCTileScheduler scheduler;
    final PlanarImage owner;
    final int tileX;
    final int tileY;
    final Raster[] tiles;
    final int offset;
    boolean done = false;
    Exception exception = null;

    RequestJob(LCTileScheduler scheduler, PlanarImage owner, int tileX, int tileY, Raster[] tiles, int offset) {
        this.scheduler = scheduler;
        this.owner = owner;
        this.tileX = tileX;
        this.tileY = tileY;
        this.tiles = tiles;
        this.offset = offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void compute() {
        block31: {
            List<Request> reqList;
            Map<Object, List<Request>> map = this.scheduler.tileRequests;
            synchronized (map) {
                Object tileID = LCTileScheduler.tileKey(this.owner, this.tileX, this.tileY);
                reqList = this.scheduler.tileRequests.remove(tileID);
                this.scheduler.tileJobs.remove(tileID);
            }
            if (reqList != null && !reqList.isEmpty()) {
                TileRequest[] requests;
                Point p = new Point(this.tileX, this.tileY);
                Integer tileStatus = 1;
                for (Request r : reqList) {
                    r.tileStatus.put(p, tileStatus);
                }
                try {
                    this.tiles[this.offset] = this.owner.getTile(this.tileX, this.tileY);
                }
                catch (Exception e) {
                    this.exception = e;
                    Set<TileComputationListener> listeners = LCTileScheduler.getListeners(reqList);
                    if (listeners == null || listeners.isEmpty()) break block31;
                    requests = reqList.toArray(new TileRequest[reqList.size()]);
                    tileStatus = this.exception == null ? 2 : 4;
                    for (TileRequest r : requests) {
                        ((Request)r).tileStatus.put(p, tileStatus);
                    }
                    if (this.exception == null) {
                        for (TileComputationListener listener : listeners) {
                            listener.tileComputed((Object)this.scheduler, requests, this.owner, this.tileX, this.tileY, this.tiles[this.offset]);
                        }
                    }
                    for (TileComputationListener listener : listeners) {
                        listener.tileComputationFailure((Object)this.scheduler, requests, this.owner, this.tileX, this.tileY, (Throwable)this.exception);
                    }
                }
                Set<TileComputationListener> listeners = LCTileScheduler.getListeners(reqList);
                if (listeners != null && !listeners.isEmpty()) {
                    requests = reqList.toArray(new TileRequest[reqList.size()]);
                    tileStatus = this.exception == null ? 2 : 4;
                    for (TileRequest r : requests) {
                        ((Request)r).tileStatus.put(p, tileStatus);
                    }
                    if (this.exception == null) {
                        for (TileComputationListener listener : listeners) {
                            listener.tileComputed((Object)this.scheduler, requests, this.owner, this.tileX, this.tileY, this.tiles[this.offset]);
                        }
                    } else {
                        for (TileComputationListener listener : listeners) {
                            listener.tileComputationFailure((Object)this.scheduler, requests, this.owner, this.tileX, this.tileY, (Throwable)this.exception);
                        }
                    }
                }
                break block31;
                break block31;
                catch (Error e2) {
                    this.exception = new Exception(e2);
                    listeners = LCTileScheduler.getListeners(reqList);
                    if (listeners == null || listeners.isEmpty()) break block31;
                    requests = reqList.toArray(new TileRequest[reqList.size()]);
                    tileStatus = this.exception == null ? 2 : 4;
                    for (TileRequest r : requests) {
                        ((Request)r).tileStatus.put(p, tileStatus);
                    }
                    if (this.exception == null) {
                        for (TileComputationListener listener : listeners) {
                            listener.tileComputed((Object)this.scheduler, requests, this.owner, this.tileX, this.tileY, this.tiles[this.offset]);
                        }
                    }
                    for (TileComputationListener listener : listeners) {
                        listener.tileComputationFailure((Object)this.scheduler, requests, this.owner, this.tileX, this.tileY, (Throwable)this.exception);
                    }
                    {
                        catch (Throwable throwable) {
                            Set<TileComputationListener> listeners2 = LCTileScheduler.getListeners(reqList);
                            if (listeners2 != null && !listeners2.isEmpty()) {
                                TileRequest[] requests2 = reqList.toArray(new TileRequest[reqList.size()]);
                                tileStatus = this.exception == null ? 2 : 4;
                                for (TileRequest r : requests2) {
                                    ((Request)r).tileStatus.put(p, tileStatus);
                                }
                                if (this.exception == null) {
                                    for (TileComputationListener listener : listeners2) {
                                        listener.tileComputed((Object)this.scheduler, requests2, this.owner, this.tileX, this.tileY, this.tiles[this.offset]);
                                    }
                                } else {
                                    for (TileComputationListener listener : listeners2) {
                                        listener.tileComputationFailure((Object)this.scheduler, requests2, this.owner, this.tileX, this.tileY, (Throwable)this.exception);
                                    }
                                }
                            }
                            throw throwable;
                        }
                    }
                }
            }
        }
        this.done = true;
    }

    @Override
    public boolean notDone() {
        return !this.done;
    }

    @Override
    public PlanarImage getOwner() {
        return this.owner;
    }

    @Override
    public boolean isBlocking() {
        return true;
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    public String toString() {
        String tString = "null";
        if (this.tiles[this.offset] != null) {
            tString = this.tiles[this.offset].toString();
        }
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + ": owner = " + this.owner.toString() + " tileX = " + Integer.toString(this.tileX) + " tileY = " + Integer.toString(this.tileY) + " tile = " + tString;
    }
}

