/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.model.ImageEditor;

import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.jai.utils.Functions;
import com.lightcrafts.jai.utils.Transform;
import com.lightcrafts.mediax.jai.BorderExtender;
import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.mediax.jai.RenderedOp;
import com.lightcrafts.model.ImageEditor.BlendedOperation;
import com.lightcrafts.model.ImageEditor.OperationTypeImpl;
import com.lightcrafts.model.ImageEditor.Rendering;
import com.lightcrafts.model.OperationType;
import com.lightcrafts.model.SliderConfig;
import com.lightcrafts.utils.ColorScience;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.text.DecimalFormat;

public class AdvancedNoiseReductionOperation
extends BlendedOperation {
    private static final String COLOR_RADIUS = "Color_Radius";
    private static final String COLOR_INTENSITY = "Color_Intensity";
    private static final String GRAIN_RADIUS = "Grain_Radius";
    private static final String GRAIN_INTENSITY = "Grain_Intensity";
    private static final String COLOR_NOISE = "Color_Noise";
    private static final String GRAIN_NOISE = "Grain_Noise";
    static final OperationType typeV1 = new OperationTypeImpl("Advanced Noise Reduction");
    static final OperationType typeV2 = new OperationTypeImpl("Advanced Noise Reduction V2");
    static final OperationType typeV3 = new OperationTypeImpl("Advanced Noise Reduction V3");
    private float chroma_domain = 2.0f;
    private float chroma_range = 4.0f;
    private float luma_domain = 3.0f;
    private float luma_range = 0.0f;

    public AdvancedNoiseReductionOperation(Rendering rendering, OperationType type) {
        super(rendering, type);
        this.colorInputOnly = true;
        DecimalFormat format = new DecimalFormat("0.0");
        if (type == typeV3) {
            this.addSliderKey(COLOR_NOISE);
            this.setSliderConfig(COLOR_NOISE, new SliderConfig(0.0, 20.0, this.chroma_domain, 1.0, false, format));
            this.addSliderKey(GRAIN_NOISE);
            this.setSliderConfig(GRAIN_NOISE, new SliderConfig(0.0, 20.0, this.luma_range, 1.0, false, format));
        } else {
            this.addSliderKey(COLOR_RADIUS);
            this.setSliderConfig(COLOR_RADIUS, new SliderConfig(0.0, 10.0, this.chroma_domain, 1.0, false, format));
            this.addSliderKey(COLOR_INTENSITY);
            this.setSliderConfig(COLOR_INTENSITY, new SliderConfig(0.0, 20.0, this.chroma_range, 1.0, false, format));
            if (type == typeV1) {
                this.addSliderKey(GRAIN_RADIUS);
                this.setSliderConfig(GRAIN_RADIUS, new SliderConfig(0.0, 10.0, this.luma_domain, 0.1, false, format));
            }
            this.addSliderKey(GRAIN_INTENSITY);
            this.setSliderConfig(GRAIN_INTENSITY, new SliderConfig(0.0, 10.0, this.luma_range, 0.1, false, format));
        }
    }

    @Override
    public boolean neutralDefault() {
        return false;
    }

    @Override
    public void setSliderValue(String key, double value) {
        value = this.roundValue(key, value);
        if (key.equals(COLOR_NOISE) && (double)this.chroma_domain != value) {
            this.chroma_domain = (float)value;
            this.chroma_range = (float)(2.0 * value);
        } else if (key.equals(GRAIN_NOISE) && (double)this.luma_range != value) {
            this.luma_range = (float)value;
            this.luma_domain = (float)(value / 2.0);
        } else if (key.equals(COLOR_RADIUS) && (double)this.chroma_domain != value) {
            this.chroma_domain = (float)value;
        } else if (key.equals(COLOR_INTENSITY) && (double)this.chroma_range != value) {
            this.chroma_range = (float)value;
        } else if (key.equals(GRAIN_RADIUS) && (double)this.luma_domain != value) {
            this.luma_domain = (float)value;
        } else if (key.equals(GRAIN_INTENSITY) && (double)this.luma_range != value) {
            this.luma_range = (float)value;
        } else {
            return;
        }
        super.setSliderValue(key, value);
    }

    @Override
    protected void updateOp(Transform op) {
        op.update();
    }

    @Override
    protected BlendedOperation.BlendedTransform createBlendedOp(PlanarImage source) {
        return new NoiseReduction(source);
    }

    @Override
    public OperationType getType() {
        return this.type;
    }

    private class NoiseReduction
    extends BlendedOperation.BlendedTransform {
        NoiseReduction(PlanarImage source) {
            super(AdvancedNoiseReductionOperation.this, source);
        }

        @Override
        public PlanarImage setFront() {
            if (AdvancedNoiseReductionOperation.this.chroma_domain == 0.0f && AdvancedNoiseReductionOperation.this.chroma_range == 0.0f && AdvancedNoiseReductionOperation.this.luma_domain == 0.0f && AdvancedNoiseReductionOperation.this.luma_range == 0.0f) {
                return this.back;
            }
            ColorScience.YST transform = new ColorScience.YST();
            double[][] rgb2yst = transform.fromRGB(this.back.getSampleModel().getDataType());
            double[][] yst2rgb = transform.toRGB(this.back.getSampleModel().getDataType());
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(this.back);
            pb.add(rgb2yst);
            RenderedOp ystImage = JAI.create((String)"BandCombine", (ParameterBlock)pb, null);
            RenderingHints mfHints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
            if (AdvancedNoiseReductionOperation.this.chroma_domain != 0.0f && AdvancedNoiseReductionOperation.this.chroma_range != 0.0f) {
                pb = new ParameterBlock();
                pb.addSource(ystImage);
                pb.add(AdvancedNoiseReductionOperation.this.chroma_domain * AdvancedNoiseReductionOperation.this.scale);
                pb.add(0.02f + 0.001f * AdvancedNoiseReductionOperation.this.chroma_domain);
                ystImage = JAI.create((String)"BilateralFilter", (ParameterBlock)pb, (RenderingHints)mfHints);
                ystImage.setProperty("LCPersistentCache", (Object)Boolean.TRUE);
            }
            if (AdvancedNoiseReductionOperation.this.luma_domain != 0.0f && AdvancedNoiseReductionOperation.this.luma_range != 0.0f) {
                pb = new ParameterBlock();
                pb.addSource(ystImage);
                pb.add(new int[]{0});
                RenderedOp y = JAI.create((String)"bandselect", (ParameterBlock)pb, null);
                pb = new ParameterBlock();
                pb.addSource(ystImage);
                pb.add(new int[]{1, 2});
                RenderedOp cc = JAI.create((String)"bandselect", (ParameterBlock)pb, (RenderingHints)JAIContext.noCacheHint);
                pb = new ParameterBlock();
                pb.addSource(y);
                pb.add((2.0f + AdvancedNoiseReductionOperation.this.luma_domain / 10.0f) * AdvancedNoiseReductionOperation.this.scale);
                pb.add(0.005f * AdvancedNoiseReductionOperation.this.luma_domain);
                y = JAI.create((String)"BilateralFilter", (ParameterBlock)pb, (RenderingHints)mfHints);
                RenderingHints layoutHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, Functions.getImageLayout((RenderedImage)ystImage));
                pb = new ParameterBlock();
                pb.addSource(y);
                pb.addSource(cc);
                layoutHints.add(JAIContext.noCacheHint);
                ystImage = JAI.create((String)"BandMerge", (ParameterBlock)pb, (RenderingHints)layoutHints);
            }
            pb = new ParameterBlock();
            pb.addSource(ystImage);
            pb.add(yst2rgb);
            RenderedOp front = JAI.create((String)"BandCombine", (ParameterBlock)pb, null);
            front.setProperty("LCPersistentCache", (Object)Boolean.TRUE);
            return front;
        }
    }
}

