/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.model.ImageEditor;

import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.jai.LCROIShape;
import com.lightcrafts.jai.operator.LCMSColorConvertDescriptor;
import com.lightcrafts.jai.opimage.BlendOpImage;
import com.lightcrafts.jai.opimage.RGBColorSelectionMaskOpImage;
import com.lightcrafts.jai.utils.Functions;
import com.lightcrafts.jai.utils.Transform;
import com.lightcrafts.mediax.jai.BorderExtender;
import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.KernelJAI;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.mediax.jai.RenderedOp;
import com.lightcrafts.mediax.jai.TileCache;
import com.lightcrafts.model.ImageEditor.GenericOperationImpl;
import com.lightcrafts.model.ImageEditor.LayerModeImpl;
import com.lightcrafts.model.ImageEditor.Rendering;
import com.lightcrafts.model.LayerConfig;
import com.lightcrafts.model.OperationType;
import com.lightcrafts.model.RGBColorSelection;
import com.lightcrafts.model.Region;
import com.lightcrafts.utils.ColorScience;
import com.lightcrafts.utils.LCMS;
import com.lightcrafts.utils.LCMS_ColorSpace;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;

public abstract class BlendedOperation
extends GenericOperationImpl
implements Cloneable {
    private double opacity = 1.0;
    private String blendingMode = "Normal";
    private LCROIShape mask = null;
    private PlanarImage colorSelectionMask = null;
    private RGBColorSelection lastColorSelection = null;
    protected boolean colorInputOnly = false;
    protected AffineTransform lastTransform = null;
    static List<LayerModeImpl> blendingModes = new ArrayList<LayerModeImpl>();
    private Point2D clickPoint = null;
    private Color selectedColor = null;

    public BlendedOperation clone(Rendering rendering) {
        try {
            BlendedOperation object = (BlendedOperation)this.clone();
            object.rendering = rendering;
            object.operation = null;
            object.lastTransform = null;
            return object;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean validRegion(Region region) {
        return region != null && region.getOuterShape().getBounds().height > 0 && region.getOuterShape().getBounds().width > 0;
    }

    public boolean hasMask() {
        return this.mask != null;
    }

    @Override
    public void setRegion(Region region) {
        if (this.validRegion(region)) {
            this.mask = new LCROIShape(region, this.rendering.getInputTransform());
        } else if (region == null || region.getContours().size() == 0) {
            this.mask = null;
        }
        this.lastTransform = this.rendering.getInputTransform();
        super.setRegion(region);
    }

    @Override
    public void setRegionInverted(boolean inverted) {
        super.setRegionInverted(inverted);
    }

    BlendedOperation(Rendering rendering, OperationType type) {
        super(rendering, type);
    }

    static float arctan2(float y, float x) {
        float angle;
        float coeff_1 = 0.7853982f;
        float coeff_2 = 2.3561945f;
        float abs_y = Math.abs(y) + 1.0E-10f;
        if (x >= 0.0f) {
            float r = (x - abs_y) / (x + abs_y);
            angle = 0.7853982f - 0.7853982f * r;
        } else {
            float r = (x + abs_y) / (abs_y - x);
            angle = 2.3561945f - 0.7853982f * r;
        }
        return y < 0.0f ? -angle : angle;
    }

    public static float hue(float r, float g, float b) {
        float x = r - (g + b) / 2.0f;
        float y = (g - b) * (float)Math.sqrt(3.0) / 2.0f;
        return BlendedOperation.arctan2(y, x) + (float)Math.PI;
    }

    @Override
    public void setColorSelection(RGBColorSelection selection) {
        super.setColorSelection(selection);
    }

    public PlanarImage getColorSelectionMask() {
        return this.colorSelectionMask;
    }

    @Override
    public RGBColorSelection getColorSelectionAt(Point2D p) {
        System.out.println("setColorSelection(): " + p);
        this.clickPoint = p;
        this.settingsChanged();
        if (this.selectedColor != null) {
            float r = (float)this.selectedColor.getRed() / 255.0f;
            float g = (float)this.selectedColor.getGreen() / 255.0f;
            float b = (float)this.selectedColor.getBlue() / 255.0f;
            this.selectedColor = null;
            float feather = 0.1f;
            float luminosity = (float)(Math.log1p(255.0f * ColorScience.Wr * r + 255.0f * ColorScience.Wg * g + 255.0f * ColorScience.Wb * b) / (8.0 * Math.log(2.0)));
            float minLuminosity = Math.max(luminosity - feather, 0.0f);
            float minLuminosityFeather = Math.min(minLuminosity, feather);
            float maxLuminosity = Math.min(luminosity + feather, 1.0f);
            float maxLuminosityFeather = Math.min(1.0f - maxLuminosity, feather);
            return new RGBColorSelection(r, g, b, 0.4f, minLuminosity, minLuminosityFeather, maxLuminosity, maxLuminosityFeather, false, true, true);
        }
        return new RGBColorSelection();
    }

    protected abstract BlendedTransform createBlendedOp(PlanarImage var1);

    @Override
    protected Transform createOp(PlanarImage source) {
        return this.createBlendedOp(source);
    }

    @Override
    public void setLayerConfig(LayerConfig layer) {
        if (!this.blendingMode.equals(layer.getMode().getName()) || this.opacity != layer.getOpacity()) {
            this.blendingMode = layer.getMode().getName();
            this.opacity = layer.getOpacity();
            this.settingsChanged();
        }
    }

    @Override
    public LayerConfig getDefaultLayerConfig() {
        return new LayerConfig(new LayerModeImpl("Normal"), 1.0);
    }

    static {
        for (BlendOpImage.BlendingMode b : BlendOpImage.BlendingMode.values()) {
            blendingModes.add(new LayerModeImpl(b.getName()));
        }
    }

    abstract class BlendedTransform
    extends Transform {
        PlanarImage back;
        SoftReference<PlanarImage> softFront = new SoftReference<Object>(null);
        SoftReference<PlanarImage> softBlender = new SoftReference<Object>(null);
        SoftReference<PlanarImage> softResult = new SoftReference<Object>(null);
        private CachedImage cachedImage = null;

        int[] pointToPixel(Point2D p) {
            if (p == null) {
                return null;
            }
            Point2D pp = BlendedOperation.this.rendering.getTransform().transform(p, null);
            int x = (int)pp.getX();
            int y = (int)pp.getY();
            if (BlendedOperation.this.rendering.getScaleFactor() > 1.0f) {
                x = (int)((float)x / BlendedOperation.this.rendering.getScaleFactor());
                y = (int)((float)y / BlendedOperation.this.rendering.getScaleFactor());
            }
            if (!this.back.getBounds().contains(x, y)) {
                return null;
            }
            int tx = this.back.XToTileX(x);
            int ty = this.back.YToTileY(y);
            Raster tile = this.back.getTile(tx, ty);
            int averagePixels = 3;
            Rectangle tileBounds = tile.getBounds();
            Rectangle sampleRect = new Rectangle(x - 1, y - 1, 3, 3);
            Rectangle intersection = tileBounds.intersection(sampleRect);
            int[] pixel = new int[]{0, 0, 0};
            int[] currentPixel = new int[3];
            for (int i = intersection.x; i < intersection.x + intersection.width; ++i) {
                for (int j = intersection.y; j < intersection.y + intersection.height; ++j) {
                    currentPixel = tile.getPixel(i, j, currentPixel);
                    for (int k = 0; k < 3; ++k) {
                        pixel[k] = (pixel[k] + currentPixel[k]) / 2;
                    }
                }
            }
            return pixel;
        }

        public abstract PlanarImage setFront();

        @Override
        public void dispose() {
            this.back.removeSinks();
            this.back.dispose();
            this.back = null;
            BlendedOperation.this.mask = null;
            this.cachedImage = null;
        }

        private RenderedOp createBlender(PlanarImage front) {
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(front);
            pb.addSource(this.back);
            pb.add(BlendedOperation.this.blendingMode);
            pb.add(new Double(BlendedOperation.this.invertedRegion ? -BlendedOperation.this.opacity : BlendedOperation.this.opacity));
            pb.add((Object)BlendedOperation.this.mask);
            pb.add(BlendedOperation.this.colorSelectionMask);
            RenderingHints formatHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, Functions.getImageLayout((RenderedImage)this.back));
            RenderedOp blender = JAI.create((String)"Blend", (ParameterBlock)pb, (RenderingHints)formatHints);
            return blender;
        }

        BlendedTransform(PlanarImage source) {
            this.back = source;
        }

        @Override
        public void setSource(Object source) {
            if (source != this.back) {
                this.back.removeSinks();
                this.back.dispose();
                this.back = (PlanarImage)source;
                BlendedOperation.this.changed = true;
            }
        }

        @Override
        public PlanarImage render() {
            if (BlendedOperation.this.colorInputOnly && this.back.getColorModel().getNumComponents() != 3) {
                return this.back;
            }
            PlanarImage newRendering = this.update();
            if (this.cachedImage == null || newRendering != this.cachedImage.getRendering()) {
                this.cachedImage = new CachedImage(newRendering, BlendedOperation.this.scale);
            }
            return this.cachedImage;
        }

        @Override
        public PlanarImage update() {
            if (BlendedOperation.this.clickPoint != null) {
                int[] pixel = this.pointToPixel(BlendedOperation.this.clickPoint);
                if (pixel != null) {
                    int r = pixel[0] / 256;
                    int g = pixel[1] / 256;
                    int b = pixel[2] / 256;
                    BlendedOperation.this.selectedColor = new Color(r, g, b);
                }
                BlendedOperation.this.clickPoint = null;
            }
            if (BlendedOperation.this.colorInputOnly && this.back.getColorModel().getNumComponents() != 3) {
                return this.back;
            }
            boolean newFront = false;
            PlanarImage front = this.softFront.get();
            if (front == null || BlendedOperation.this.changed) {
                front = this.setFront();
                this.softFront = new SoftReference<PlanarImage>(front);
                newFront = true;
            }
            PlanarImage result = this.softResult.get();
            if (!newFront && result != null) {
                return result;
            }
            RGBColorSelection colorSelection = BlendedOperation.this.getColorSelection();
            if (BlendedOperation.this.opacity == 1.0 && BlendedOperation.this.blendingMode.equals("Normal") && !BlendedOperation.this.validRegion(BlendedOperation.this.getRegion()) && (colorSelection == null || colorSelection.isAllSelected())) {
                this.softResult = this.softFront;
                return front;
            }
            RenderedOp blender = (RenderedOp)this.softBlender.get();
            if (BlendedOperation.this.validRegion(BlendedOperation.this.getRegion()) && (!BlendedOperation.this.rendering.getInputTransform().equals(BlendedOperation.this.lastTransform) || blender != null && blender.getParameters().get(2) != BlendedOperation.this.mask)) {
                BlendedOperation.this.mask = new LCROIShape(BlendedOperation.this.getRegion(), BlendedOperation.this.rendering.getInputTransform());
                blender = null;
            } else if (BlendedOperation.this.getRegion() == null) {
                BlendedOperation.this.mask = null;
            }
            if (colorSelection != null && !colorSelection.isAllSelected() && (newFront || !colorSelection.equals(BlendedOperation.this.lastColorSelection) || !BlendedOperation.this.rendering.getInputTransform().equals(BlendedOperation.this.lastTransform) || blender != null && blender.getParameters().get(3) != BlendedOperation.this.colorSelectionMask)) {
                PlanarImage labImage = Functions.toColorSpace((RenderedImage)this.back, new LCMS_ColorSpace(new LCMS.LABProfile()), LCMSColorConvertDescriptor.RELATIVE_COLORIMETRIC, null);
                ParameterBlock pb = new ParameterBlock();
                pb.addSource(labImage);
                pb.add(new int[]{1, 2});
                RenderedOp abImage = JAI.create((String)"bandselect", (ParameterBlock)pb, null);
                pb = new ParameterBlock();
                pb.addSource(this.back);
                pb.add(new double[][]{{ColorScience.Wr, ColorScience.Wg, ColorScience.Wb, 0.0}});
                RenderedOp monochrome = JAI.create((String)"BandCombine", (ParameterBlock)pb, null);
                RenderingHints layoutHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, Functions.getImageLayout((RenderedImage)labImage));
                pb = new ParameterBlock();
                pb.addSource(monochrome);
                pb.addSource(abImage);
                RenderedOp maskImage = JAI.create((String)"BandMerge", (ParameterBlock)pb, (RenderingHints)layoutHints);
                BlendedOperation.this.colorSelectionMask = (PlanarImage)new RGBColorSelectionMaskOpImage((RenderedImage)maskImage, BlendedOperation.this.getColorSelection(), null);
                RenderingHints extenderHints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
                KernelJAI kernel = Functions.getGaussKernel(0.5 * (double)BlendedOperation.this.scale);
                ParameterBlock maskPB = new ParameterBlock();
                maskPB.addSource(BlendedOperation.this.colorSelectionMask);
                maskPB.add(kernel);
                BlendedOperation.this.colorSelectionMask = (PlanarImage)JAI.create((String)"Convolve", (ParameterBlock)maskPB, (RenderingHints)extenderHints);
                BlendedOperation.this.lastColorSelection = colorSelection;
            } else if (colorSelection == null || colorSelection.isAllSelected()) {
                BlendedOperation.this.colorSelectionMask = null;
            }
            BlendedOperation.this.lastTransform = BlendedOperation.this.rendering.getInputTransform();
            blender = this.createBlender(front);
            this.softBlender = new SoftReference<RenderedOp>(blender);
            this.softResult = this.softBlender;
            return blender;
        }

        public class CachedImage
        extends PlanarImage {
            private final TileCache cache;
            private SoftReference<PlanarImage> softRendering;
            final float scale;

            public CachedImage(PlanarImage rendering, float scale) {
                super(new ImageLayout((RenderedImage)rendering), null, null);
                this.cache = JAIContext.fileCache;
                this.softRendering = new SoftReference<Object>(null);
                this.setProperty("LCPersistentCache", Boolean.TRUE);
                this.softRendering = new SoftReference<PlanarImage>(rendering);
                this.scale = scale;
            }

            public PlanarImage getRendering() {
                return this.softRendering != null ? this.softRendering.get() : null;
            }

            public Raster getTile(int tileX, int tileY) {
                Raster tile = this.cache.getTile((RenderedImage)((Object)this), tileX, tileY);
                if (tile == null) {
                    PlanarImage rendering = this.softRendering.get();
                    if (rendering == null) {
                        System.out.println("rendering null..." + BlendedOperation.this.getClass());
                        rendering = BlendedTransform.this.update();
                        this.softRendering = new SoftReference<PlanarImage>(rendering);
                    }
                    tile = rendering.getTile(tileX, tileY);
                    this.cache.add((RenderedImage)((Object)this), tileX, tileY, tile);
                }
                return tile;
            }
        }
    }
}

