/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.model.ImageEditor;

import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.jai.utils.Functions;
import com.lightcrafts.jai.utils.Transform;
import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.model.ColorPickerOperation;
import com.lightcrafts.model.ImageEditor.BlendedOperation;
import com.lightcrafts.model.ImageEditor.OperationTypeImpl;
import com.lightcrafts.model.ImageEditor.Rendering;
import com.lightcrafts.model.OperationType;
import com.lightcrafts.model.SliderConfig;
import com.lightcrafts.utils.ColorScience;
import java.awt.Color;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Map;

public class ChannelMixerV2
extends BlendedOperation
implements ColorPickerOperation {
    private static final String Strenght = "Strength";
    private Color color = Color.white;
    private double strenght = 1.0;
    static final OperationType typeV2 = new OperationTypeImpl("Channel Mixer V2");
    static final OperationType typeV3 = new OperationTypeImpl("Channel Mixer V3");
    static final OperationType typeV4 = new OperationTypeImpl("Channel Mixer V4");

    public ChannelMixerV2(Rendering rendering, OperationType type) {
        super(rendering, type);
        this.colorInputOnly = true;
        if (type != typeV2) {
            this.addSliderKey(Strenght);
        }
        DecimalFormat format = new DecimalFormat("0.00");
        if (type != typeV2) {
            this.setSliderConfig(Strenght, new SliderConfig(0.0, 10.0, this.strenght, 0.5, false, format));
        }
    }

    @Override
    public void setSliderValue(String key, double value) {
        value = this.roundValue(key, value);
        if (!key.equals(Strenght) || this.strenght == value) {
            return;
        }
        this.strenght = value;
        super.setSliderValue(key, value);
    }

    @Override
    public boolean neutralDefault() {
        return false;
    }

    @Override
    public Map<String, Double> setColor(Color color) {
        this.color = color;
        this.settingsChanged();
        return Collections.emptyMap();
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    protected void updateOp(Transform op) {
        op.update();
    }

    @Override
    protected BlendedOperation.BlendedTransform createBlendedOp(PlanarImage source) {
        return new ChannelMixerTransform(source);
    }

    @Override
    public OperationType getType() {
        return this.type;
    }

    private class ChannelMixerTransform
    extends BlendedOperation.BlendedTransform {
        ChannelMixerTransform(PlanarImage source) {
            super(source);
        }

        @Override
        public PlanarImage setFront() {
            if (ChannelMixerV2.this.type == typeV4) {
                return this.setFrontV4();
            }
            return this.setFrontV3();
        }

        public PlanarImage setFrontV4() {
            float[] filter = new float[]{(float)ChannelMixerV2.this.color.getRed() / 255.0f, (float)ChannelMixerV2.this.color.getGreen() / 255.0f, (float)ChannelMixerV2.this.color.getBlue() / 255.0f};
            filter = JAIContext.linearColorSpace.fromRGB(filter);
            float red = 1.0f - filter[0];
            float green = 1.0f - filter[1];
            float blue = 1.0f - filter[2];
            double tred = ColorScience.Wr;
            double tgreen = ColorScience.Wg;
            double tblue = ColorScience.Wb;
            if (red != 0.0f) {
                tred -= ChannelMixerV2.this.strenght * (double)red / 2.0;
                tgreen += ChannelMixerV2.this.strenght * (double)red / 4.0;
                tblue += ChannelMixerV2.this.strenght * (double)red / 4.0;
            }
            if (blue != 0.0f) {
                tblue -= ChannelMixerV2.this.strenght * (double)blue / 2.0;
                tgreen += ChannelMixerV2.this.strenght * (double)blue / 4.0;
                tred += ChannelMixerV2.this.strenght * (double)blue / 4.0;
            }
            if (green != 0.0f) {
                tgreen -= ChannelMixerV2.this.strenght * (double)green / 2.0;
                tblue += ChannelMixerV2.this.strenght * (double)green / 4.0;
                tred += ChannelMixerV2.this.strenght * (double)green / 4.0;
            }
            double[][] transform = new double[][]{{tred, tgreen, tblue, 0.0}, {tred, tgreen, tblue, 0.0}, {tred, tgreen, tblue, 0.0}};
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(this.back);
            pb.add(transform);
            return JAI.create((String)"BandCombine", (ParameterBlock)pb, null);
        }

        public PlanarImage setFrontV3() {
            float red = (float)ChannelMixerV2.this.color.getRed() / 255.0f;
            float green = (float)ChannelMixerV2.this.color.getGreen() / 255.0f;
            float blue = (float)ChannelMixerV2.this.color.getBlue() / 255.0f;
            double tred = 0.0;
            double tgreen = 1.0;
            double tblue = 0.0;
            if (red != 0.0f) {
                tred += ChannelMixerV2.this.strenght * (double)red / 2.0;
                tgreen -= ChannelMixerV2.this.strenght * (double)red / 4.0;
                tblue -= ChannelMixerV2.this.strenght * (double)red / 4.0;
            }
            if (blue != 0.0f) {
                tblue += ChannelMixerV2.this.strenght * (double)blue / 2.0;
                tgreen -= ChannelMixerV2.this.strenght * (double)blue / 4.0;
                tred -= ChannelMixerV2.this.strenght * (double)blue / 4.0;
            }
            if (green != 1.0f) {
                tgreen += ChannelMixerV2.this.strenght * (double)green / 2.0;
                tblue -= ChannelMixerV2.this.strenght * (double)green / 4.0;
                tred -= ChannelMixerV2.this.strenght * (double)green / 4.0;
            }
            double[][] transform = new double[][]{{tred, tgreen, tblue, 0.0}, {tred, tgreen, tblue, 0.0}, {tred, tgreen, tblue, 0.0}};
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(Functions.toColorSpace((RenderedImage)this.back, JAIContext.oldLinearColorSpace, null));
            pb.add(transform);
            return JAI.create((String)"BandCombine", (ParameterBlock)pb, null);
        }
    }
}

