/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.model.ImageEditor;

import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.jai.LCROIShape;
import com.lightcrafts.jai.utils.Transform;
import com.lightcrafts.mediax.jai.BorderExtender;
import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.mediax.jai.RenderedOp;
import com.lightcrafts.model.CloneContour;
import com.lightcrafts.model.CloneOperation;
import com.lightcrafts.model.Contour;
import com.lightcrafts.model.ImageEditor.BlendedOperation;
import com.lightcrafts.model.ImageEditor.OperationTypeImpl;
import com.lightcrafts.model.ImageEditor.Rendering;
import com.lightcrafts.model.OperationType;
import com.lightcrafts.model.Region;
import com.lightcrafts.ui.editor.EditorMode;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.Collection;
import java.util.Collections;

public class CloneOperationImpl
extends BlendedOperation
implements CloneOperation {
    static final OperationType type = new OperationTypeImpl("Clone");

    public CloneOperationImpl(Rendering rendering) {
        super(rendering, type);
    }

    @Override
    public EditorMode getPreferredMode() {
        return EditorMode.REGION;
    }

    @Override
    public boolean neutralDefault() {
        return true;
    }

    @Override
    public void setRegionInverted(boolean inverted) {
    }

    static PlanarImage buildCloner(Region region, Rendering rendering, PlanarImage back) {
        PlanarImage image = back;
        Collection<Contour> contours = region.getContours();
        for (Contour c : contours) {
            CloneContour cloneContour;
            if (!(c instanceof CloneContour)) continue;
            final CloneContour contour = cloneContour = (CloneContour)c;
            Point2D translation = contour.getTranslation();
            Point2D clonePoint = cloneContour.getClonePoint();
            Point2D source = new Point2D.Double(clonePoint.getX() + (translation != null ? translation.getX() : 0.0), clonePoint.getY() + (translation != null ? translation.getY() : 0.0));
            source = rendering.getInputTransform().transform(source, null);
            Rectangle bounds = contour.getOuterShape().getBounds();
            Point2D target = new Point2D.Double(bounds.getCenterX() + (translation != null ? translation.getX() : 0.0), bounds.getCenterY() + (translation != null ? translation.getY() : 0.0));
            target = rendering.getInputTransform().transform(target, null);
            int dx = (int)(target.getX() - source.getX());
            int dy = (int)(target.getY() - source.getY());
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(back).add((float)dx).add((float)dy);
            RenderedOp translated = JAI.create((String)"Translate", (ParameterBlock)pb, (RenderingHints)JAIContext.noCacheHint);
            pb = new ParameterBlock();
            pb.addSource(translated).add(dx > 0 ? dx : 0).add(dx < 0 ? -dx : 0).add(dy > 0 ? dy : 0).add(dy < 0 ? -dy : 0).add(BorderExtender.createInstance((int)0));
            RenderedOp border = JAI.create((String)"Border", (ParameterBlock)pb, (RenderingHints)JAIContext.noCacheHint);
            pb = new ParameterBlock();
            pb.addSource(border).add((float)back.getMinX()).add((float)back.getMinY()).add((float)back.getWidth()).add((float)back.getHeight());
            RenderedOp crop = JAI.create((String)"Crop", (ParameterBlock)pb, (RenderingHints)JAIContext.noCacheHint);
            pb = new ParameterBlock();
            pb.addSource(crop).add(back.getSampleModel().getDataType());
            RenderingHints formatHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, new ImageLayout((RenderedImage)back));
            formatHints.add(JAIContext.noCacheHint);
            RenderedOp formatted = JAI.create((String)"Format", (ParameterBlock)pb, (RenderingHints)formatHints);
            Region r = new Region(){

                @Override
                public Collection<Contour> getContours() {
                    return Collections.singleton(contour);
                }

                @Override
                public Shape getOuterShape() {
                    return contour.getOuterShape();
                }

                @Override
                public float getWidth() {
                    return contour.getWidth();
                }

                @Override
                public Point2D getTranslation() {
                    return contour.getTranslation();
                }
            };
            LCROIShape mask = new LCROIShape(r, rendering.getInputTransform());
            pb = new ParameterBlock();
            pb.addSource(formatted).addSource(image).add("Normal").add(new Double(1.0)).add((Object)mask);
            image = JAI.create((String)"Blend", (ParameterBlock)pb, null);
        }
        return image;
    }

    @Override
    protected void updateOp(Transform op) {
        op.update();
    }

    @Override
    protected BlendedOperation.BlendedTransform createBlendedOp(PlanarImage source) {
        return new Cloner(source);
    }

    @Override
    public OperationType getType() {
        return type;
    }

    private class Cloner
    extends BlendedOperation.BlendedTransform {
        Cloner(PlanarImage source) {
            super(source);
        }

        @Override
        public PlanarImage setFront() {
            if (CloneOperationImpl.this.getRegion() != null) {
                return CloneOperationImpl.buildCloner(CloneOperationImpl.this.getRegion(), CloneOperationImpl.this.rendering, this.back);
            }
            return this.back;
        }
    }
}

