/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.model.ImageEditor;

import com.lightcrafts.jai.utils.Transform;
import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.LookupTableJAI;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.model.ImageEditor.BlendedOperation;
import com.lightcrafts.model.ImageEditor.OperationTypeImpl;
import com.lightcrafts.model.ImageEditor.Rendering;
import com.lightcrafts.model.OperationType;
import com.lightcrafts.model.SliderConfig;
import com.lightcrafts.utils.splines;
import java.awt.image.renderable.ParameterBlock;
import java.text.DecimalFormat;

public class ColorBalanceOperation
extends BlendedOperation {
    static final OperationType type = new OperationTypeImpl("Color Balance");
    private final String RED = "Cyan-Red";
    private final String GREEN = "Magenta-Green";
    private final String BLUE = "Yellow-Blue";
    private final String MIDPOINT = "Midpoint";
    private final String HILIGHTS = "Hilights";
    private final String MIDTONES = "Midtones";
    private final String SHADOWS = "Shadows";
    private double red = 0.0;
    private double green = 0.0;
    private double blue = 0.0;
    private double midpoint = 0.18;

    public ColorBalanceOperation(Rendering rendering) {
        super(rendering, type);
        this.colorInputOnly = true;
        DecimalFormat format = new DecimalFormat("0.0");
        this.addSliderKey("Cyan-Red");
        this.addSliderKey("Magenta-Green");
        this.addSliderKey("Yellow-Blue");
        this.setSliderConfig("Cyan-Red", new SliderConfig(-10.0, 10.0, this.red, 0.1, false, format));
        this.setSliderConfig("Magenta-Green", new SliderConfig(-10.0, 10.0, this.green, 0.1, false, format));
        this.setSliderConfig("Yellow-Blue", new SliderConfig(-10.0, 10.0, this.blue, 0.1, false, format));
        format = new DecimalFormat("0.00");
        this.addSliderKey("Midpoint");
        this.setSliderConfig("Midpoint", new SliderConfig(0.0, 1.0, this.midpoint, 0.01, false, format));
    }

    @Override
    public void setSliderValue(String key, double value) {
        value = this.roundValue(key, value);
        if (key.equals("Cyan-Red") && this.red != value) {
            this.red = value;
        } else if (key.equals("Magenta-Green") && this.green != value) {
            this.green = value;
        } else if (key.equals("Yellow-Blue") && this.blue != value) {
            this.blue = value;
        } else if (key.equals("Midpoint") && this.midpoint != value) {
            this.midpoint = value;
        } else {
            return;
        }
        super.setSliderValue(key, value);
    }

    @Override
    public void setChoiceValue(String key, String value) {
        if (key.equals("Midpoint")) {
            if (value.equals("Hilights")) {
                this.midpoint = 0.62;
            } else if (value.equals("Midtones")) {
                this.midpoint = 0.18;
            } else if (value.equals("Shadows")) {
                this.midpoint = 0.04;
            }
        }
        super.setChoiceValue(key, value);
    }

    @Override
    protected BlendedOperation.BlendedTransform createBlendedOp(PlanarImage source) {
        return new ColorBalance(source);
    }

    @Override
    public boolean neutralDefault() {
        return true;
    }

    @Override
    protected void updateOp(Transform op) {
        op.update();
    }

    @Override
    public OperationType getType() {
        return type;
    }

    private class ColorBalance
    extends BlendedOperation.BlendedTransform {
        ColorBalance(PlanarImage source) {
            super(source);
        }

        @Override
        public PlanarImage setFront() {
            int i;
            double tred = ColorBalanceOperation.this.red / 2.0 - ColorBalanceOperation.this.blue / 4.0 - ColorBalanceOperation.this.green / 4.0;
            double tgreen = ColorBalanceOperation.this.green / 2.0 - ColorBalanceOperation.this.red / 4.0 - ColorBalanceOperation.this.blue / 4.0;
            double tblue = ColorBalanceOperation.this.blue / 2.0 - ColorBalanceOperation.this.red / 4.0 - ColorBalanceOperation.this.green / 4.0;
            double[][] polygon = new double[][]{{0.0, 0.0}, {ColorBalanceOperation.this.midpoint, 0.0}, {1.0, 0.0}};
            polygon[1][1] = tred;
            double[][] redCurve = new double[256][2];
            splines.bspline(3, polygon, redCurve);
            polygon[1][1] = tgreen;
            double[][] greenCurve = new double[256][2];
            splines.bspline(3, polygon, greenCurve);
            polygon[1][1] = tblue;
            double[][] blueCurve = new double[256][2];
            splines.bspline(3, polygon, blueCurve);
            short[][] table = new short[3][65536];
            splines.Interpolator interpolator = new splines.Interpolator();
            for (i = 0; i < 65536; ++i) {
                table[0][i] = (short)(0xFFFF & (int)Math.min(Math.max((double)i + 2550.0 * interpolator.interpolate((double)i / 65535.0, redCurve), 0.0), 65535.0));
            }
            interpolator.reset();
            for (i = 0; i < 65536; ++i) {
                table[1][i] = (short)(0xFFFF & (int)Math.min(Math.max((double)i + 2550.0 * interpolator.interpolate((double)i / 65535.0, greenCurve), 0.0), 65535.0));
            }
            interpolator.reset();
            for (i = 0; i < 65536; ++i) {
                table[2][i] = (short)(0xFFFF & (int)Math.min(Math.max((double)i + 2550.0 * interpolator.interpolate((double)i / 65535.0, blueCurve), 0.0), 65535.0));
            }
            LookupTableJAI lookupTable = new LookupTableJAI(table, true);
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(this.back);
            pb.add(lookupTable);
            return JAI.create((String)"lookup", (ParameterBlock)pb, null);
        }
    }
}

