/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.model.ImageEditor;

import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.jai.utils.Functions;
import com.lightcrafts.mediax.jai.IHSColorSpace;
import com.lightcrafts.model.ImageEditor.ImageEditorEngine;
import com.lightcrafts.model.ImageEditor.Locale;
import com.lightcrafts.model.Preview;
import com.lightcrafts.model.Region;
import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.toolkit.ShadowFactory;
import com.lightcrafts.utils.ColorScience;
import com.lightcrafts.utils.LCMS;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;

class DropperPreview
extends Preview {
    private ImageEditorEngine engine;
    private Point loc = new Point(0, 0);
    private Color color = Color.GRAY;
    private static IHSColorSpace ihsCS = IHSColorSpace.getInstance();
    private static final RenderingHints aliasingRenderHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);

    DropperPreview(ImageEditorEngine engine) {
        this.engine = engine;
    }

    @Override
    public String getName() {
        return Locale.LOCALE.get("Sampler_Name");
    }

    @Override
    public void setDropper(Point p) {
        if (p == null || this.engine == null) {
            return;
        }
        Color sample = this.engine.getPixelValue(p.x, p.y);
        if (sample != null) {
            this.loc = p;
            this.color = sample;
        }
        this.repaint();
    }

    @Override
    public void setRegion(Region region) {
    }

    @Override
    public void setSelected(Boolean selected) {
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        final Graphics2D g = (Graphics2D)graphics;
        g.setRenderingHints(aliasingRenderHints);
        Dimension bounds = this.getSize();
        boolean minx = false;
        boolean miny = false;
        int width = bounds.width;
        int height = bounds.height;
        int gap = width - 130;
        g.setColor(LightZoneSkin.Colors.NeutralGray);
        g.fillRect(0, 0, width, height);
        g.setColor(LightZoneSkin.Colors.ToolPanesForeground);
        Font font = new Font("Monospaced", 0, 13);
        g.setFont(font);
        TextLayout layout = new TextLayout("ABC", font, g.getFontRenderContext());
        float textHeight = (float)layout.getBounds().getHeight() + 5.0f;
        if (this.loc == null || this.engine == null) {
            return;
        }
        String separator = ": ";
        final FontMetrics fm = this.getFontMetrics(font);
        class Graph {
            Graph() {
            }

            private void drawAlignedString(String name, int value, float x, float y) {
                this.drawAlignedString(name, Integer.toString(value), x, y);
            }

            private void drawAlignedString(String name, String value, float x, float y) {
                g.drawString(name + ": " + value, x - (float)fm.stringWidth(name), y);
            }
        }
        Graph gg = new Graph();
        gg.drawAlignedString("x", this.loc.x, 50.0f, 2.0f + textHeight);
        gg.drawAlignedString("y", this.loc.y, 50.0f, 2.0f + 2.0f * textHeight);
        int red = this.color.getRed();
        int green = this.color.getGreen();
        int blue = this.color.getBlue();
        gg.drawAlignedString(Locale.LOCALE.get("Sampler_RedLabel"), red, 50.0f, 12.0f + 3.0f * textHeight);
        gg.drawAlignedString(Locale.LOCALE.get("Sampler_GreenLabel"), green, 50.0f, 12.0f + 4.0f * textHeight);
        gg.drawAlignedString(Locale.LOCALE.get("Sampler_BlueLabel"), blue, 50.0f, 12.0f + 5.0f * textHeight);
        double lightness = ColorScience.Wr * (float)red + ColorScience.Wg * (float)green + ColorScience.Wb * (float)blue;
        gg.drawAlignedString(Locale.LOCALE.get("Sampler_LuminosityLabel"), (int)lightness, 0 + gap + 50, 2.0f + textHeight);
        double zone = Math.log1p(lightness) / (8.0 * Math.log(2.0));
        DecimalFormat format = new DecimalFormat("0.0");
        gg.drawAlignedString(Locale.LOCALE.get("Sampler_ZoneLabel"), format.format(16.0 * zone), 0 + gap + 50, 2.0f + 2.0f * textHeight);
        float[] xyzColor = JAIContext.linearColorSpace.toCIEXYZ(new float[]{(float)((double)red / 255.0), (float)((double)green / 255.0), (float)((double)blue / 255.0)});
        float[] ihsColor = ihsCS.fromCIEXYZ(xyzColor);
        gg.drawAlignedString(Locale.LOCALE.get("Sampler_IntensityLabel"), (int)(100.0f * ihsColor[0]) + "%", 0 + gap + 50, 12.0f + 3.0f * textHeight);
        gg.drawAlignedString(Locale.LOCALE.get("Sampler_HueLabel"), (int)(360.0 * ((double)ihsColor[1] / (Math.PI * 2))) + "\u00b0", 0 + gap + 50, 12.0f + 4.0f * textHeight);
        gg.drawAlignedString(Locale.LOCALE.get("Sampler_SaturationLabel"), (int)(100.0f * ihsColor[2]) + "%", 0 + gap + 50, 12.0f + 5.0f * textHeight);
        LCMS.Transform ts = new LCMS.Transform(new LCMS.Profile(JAIContext.linearProfile), LCMS.TYPE_RGB_16, new LCMS.Profile(JAIContext.labProfile), LCMS.TYPE_Lab_16, 1, 0);
        short[] labColors = new short[3];
        ts.doTransform(new short[]{(short)(red * 256), (short)(green * 256), (short)(blue * 256)}, labColors);
        int L = 100 * (0xFFFF & labColors[0]) / 65535;
        int a = ((0xFFFF & labColors[1]) - 32768) / 256;
        int b = ((0xFFFF & labColors[2]) - 32768) / 256;
        gg.drawAlignedString("L", L, 50.0f, 12.0f + 7.0f * textHeight);
        gg.drawAlignedString("a", a, 50.0f, 12.0f + 8.0f * textHeight);
        gg.drawAlignedString("b", b, 50.0f, 12.0f + 9.0f * textHeight);
        float[] components = this.color.getRGBComponents(null);
        components = Functions.fromLinearToCS(JAIContext.systemColorSpace, components);
        Dimension size = new Dimension(width - 20, 60);
        BufferedImage image = new BufferedImage(size.width - 106, size.height - 6, 1);
        Graphics imageG = image.getGraphics();
        imageG.setColor(new Color(components[0], components[1], components[2]));
        imageG.fillRect(0, 0, size.width - 106, size.height - 6);
        imageG.dispose();
        ShadowFactory shadow = new ShadowFactory(3, 1.0f, Color.gray);
        shadow.setRenderingHint("blur_quality", "high");
        BufferedImage shadowImage = shadow.createShadow(image);
        imageG = shadowImage.getGraphics();
        imageG.drawImage(image, 3, 2, null);
        imageG.dispose();
        graphics.drawImage(shadowImage, 110, (int)(12.0f + 6.0f * textHeight), null);
        graphics.setColor(Color.DARK_GRAY);
        graphics.drawRect(112, (int)(12.0f + 6.0f * textHeight) + 2, size.width - 106, size.height - 6);
    }

    static {
        aliasingRenderHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        aliasingRenderHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    }
}

