/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.model.ImageEditor;

import com.lightcrafts.jai.utils.Transform;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.model.GenericOperation;
import com.lightcrafts.model.ImageEditor.OperationImpl;
import com.lightcrafts.model.ImageEditor.Rendering;
import com.lightcrafts.model.OperationType;
import com.lightcrafts.model.SliderConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

abstract class GenericOperationImpl
extends OperationImpl
implements GenericOperation {
    OperationType type;
    List<String> sliderKeys;
    List<String> checkboxKeys;
    List<String> choiceKeys;
    Map<String, List<String>> choiceValues;
    Map<String, SliderConfig> sliderConfigs;

    protected GenericOperationImpl(Rendering rendering, OperationType type) {
        super(rendering, type.getName());
        this.type = type;
        this.sliderKeys = new ArrayList<String>();
        this.checkboxKeys = new ArrayList<String>();
        this.choiceKeys = new ArrayList<String>();
        this.choiceValues = new HashMap<String, List<String>>();
        this.sliderConfigs = new HashMap<String, SliderConfig>();
    }

    @Override
    public OperationType getType() {
        return this.type;
    }

    void addSliderKey(String key) {
        this.sliderKeys.add(key);
        this.sliderConfigs.put(key, new SliderConfig());
    }

    void addCheckboxKey(String key) {
        this.checkboxKeys.add(key);
    }

    void addChoiceKey(String key) {
        this.choiceKeys.add(key);
        this.choiceValues.put(key, new ArrayList());
    }

    void addChoiceValue(String key, String value) {
        this.choiceValues.get(key).add(value);
    }

    void setCheckboxKeys(List<String> keys) {
        this.checkboxKeys = keys;
    }

    @Override
    public List<String> getSliderKeys() {
        return new ArrayList<String>(this.sliderKeys);
    }

    @Override
    public List<String> getCheckboxKeys() {
        return new ArrayList<String>(this.checkboxKeys);
    }

    @Override
    public List<String> getChoiceKeys() {
        return new ArrayList<String>(this.choiceKeys);
    }

    @Override
    public List<String> getChoiceValues(String key) {
        return new ArrayList<String>((Collection)this.choiceValues.get(key));
    }

    public double roundValue(String key, double value) {
        SliderConfig sliderConfig = this.getSliderConfig(key);
        double increment = sliderConfig.getIncrement();
        return (double)Math.round(value / increment) * increment;
    }

    @Override
    public void setSliderValue(String key, double value) {
        this.settingsChanged();
    }

    @Override
    public void setCheckboxValue(String key, boolean value) {
        this.settingsChanged();
    }

    @Override
    public void setChoiceValue(String key, String value) {
        this.settingsChanged();
    }

    void setSliderConfig(String key, SliderConfig config) {
        this.sliderConfigs.put(key, config);
    }

    @Override
    public SliderConfig getSliderConfig(String key) {
        return this.sliderConfigs.get(key);
    }

    @Override
    protected abstract void updateOp(Transform var1);

    @Override
    protected abstract Transform createOp(PlanarImage var1);
}

