/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.model.ImageEditor;

import com.lightcrafts.image.BadImageFileException;
import com.lightcrafts.image.ColorProfileException;
import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.UnknownImageTypeException;
import com.lightcrafts.image.export.BitsPerChannelOption;
import com.lightcrafts.image.export.ImageExportOptions;
import com.lightcrafts.image.export.ImageFileExportOptions;
import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.metadata.ImageOrientation;
import com.lightcrafts.image.types.AuxiliaryImageInfo;
import com.lightcrafts.image.types.ImageType;
import com.lightcrafts.image.types.JPEGImageType;
import com.lightcrafts.image.types.RawImageInfo;
import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.jai.operator.LCMSColorConvertDescriptor;
import com.lightcrafts.jai.opimage.CachedImage;
import com.lightcrafts.jai.utils.Functions;
import com.lightcrafts.jai.utils.LCTileCache;
import com.lightcrafts.mediax.jai.BorderExtender;
import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.Interpolation;
import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.mediax.jai.RenderedImageAdapter;
import com.lightcrafts.mediax.jai.RenderedOp;
import com.lightcrafts.mediax.jai.TileCache;
import com.lightcrafts.mediax.jai.operator.TransposeType;
import com.lightcrafts.model.CloneOperation;
import com.lightcrafts.model.CropBounds;
import com.lightcrafts.model.Engine;
import com.lightcrafts.model.EngineListener;
import com.lightcrafts.model.ImageEditor.AdvancedNoiseReductionOperation;
import com.lightcrafts.model.ImageEditor.AdvancedNoiseReductionOperationV4;
import com.lightcrafts.model.ImageEditor.BlendedOperation;
import com.lightcrafts.model.ImageEditor.ChannelMixer;
import com.lightcrafts.model.ImageEditor.ChannelMixerV2;
import com.lightcrafts.model.ImageEditor.CloneOperationImpl;
import com.lightcrafts.model.ImageEditor.ColorBalanceOperation;
import com.lightcrafts.model.ImageEditor.ColorBalanceOperationV2;
import com.lightcrafts.model.ImageEditor.ColorSelectionPreview;
import com.lightcrafts.model.ImageEditor.ContrastMaskOperation;
import com.lightcrafts.model.ImageEditor.DropperPreview;
import com.lightcrafts.model.ImageEditor.GaussianBlurOperation;
import com.lightcrafts.model.ImageEditor.HDROperation;
import com.lightcrafts.model.ImageEditor.HDROperationV2;
import com.lightcrafts.model.ImageEditor.HDROperationV3;
import com.lightcrafts.model.ImageEditor.HiPassFilterOperation;
import com.lightcrafts.model.ImageEditor.HistogramPreview;
import com.lightcrafts.model.ImageEditor.HueSaturationOperation;
import com.lightcrafts.model.ImageEditor.ImageEditorDisplay;
import com.lightcrafts.model.ImageEditor.NoiseReductionOperation;
import com.lightcrafts.model.ImageEditor.OperationImpl;
import com.lightcrafts.model.ImageEditor.PaintListener;
import com.lightcrafts.model.ImageEditor.PassThroughPreview;
import com.lightcrafts.model.ImageEditor.RawAdjustmentsOperation;
import com.lightcrafts.model.ImageEditor.RedEyesOperation;
import com.lightcrafts.model.ImageEditor.Rendering;
import com.lightcrafts.model.ImageEditor.SpotOperationImpl;
import com.lightcrafts.model.ImageEditor.UnSharpMaskOperation;
import com.lightcrafts.model.ImageEditor.WhiteBalance;
import com.lightcrafts.model.ImageEditor.WhiteBalanceV2;
import com.lightcrafts.model.ImageEditor.WhitePointOperationImpl;
import com.lightcrafts.model.ImageEditor.ZoneFinder;
import com.lightcrafts.model.ImageEditor.ZoneOperationImpl;
import com.lightcrafts.model.Operation;
import com.lightcrafts.model.OperationType;
import com.lightcrafts.model.Preview;
import com.lightcrafts.model.PrintSettings;
import com.lightcrafts.model.RenderingIntent;
import com.lightcrafts.model.Scale;
import com.lightcrafts.model.SpotOperation;
import com.lightcrafts.model.WhitePointOperation;
import com.lightcrafts.model.ZoneOperation;
import com.lightcrafts.platform.Platform;
import com.lightcrafts.utils.ColorProfileInfo;
import com.lightcrafts.utils.UserCanceledException;
import com.lightcrafts.utils.thread.ProgressThread;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Timer;

public class ImageEditorEngine
implements Engine {
    private ImageInfo m_imageInfo;
    private ImageInfo m_exportInfo;
    private PlanarImage sourceImage;
    private PlanarImage processedImage;
    private Rendering rendering;
    private ImageEditorDisplay canvas = null;
    private boolean engineActive = true;
    private LinkedList<Preview> previews = new LinkedList();
    private static final Scale[] scales = new Scale[]{new Scale(1, 40), new Scale(1, 20), new Scale(1, 10), new Scale(1, 8), new Scale(1, 6), new Scale(1, 4), new Scale(1, 3), new Scale(1, 2), new Scale(2, 3), new Scale(1, 1), new Scale(2, 1), new Scale(3, 1), new Scale(4, 1)};
    private LinkedList<EngineListener> listeners = null;
    private static boolean DEBUG = false;
    private ImageMetadata metadata = null;
    private AuxiliaryImageInfo auxInfo = null;
    private TransposeType transposeAngle = null;
    private RenderedImage backgroundImage;
    private boolean addFirstPaintLatency;
    private boolean disposed = false;
    private static Map<OperationType, Class<? extends BlendedOperation>> operationsSet = new HashMap<OperationType, Class<? extends BlendedOperation>>();
    private int selectedOperation = -1;
    private PlanarImage previewImage = null;
    private long synchImageRepaintTime = 300L;
    private long tilesRead = 0L;
    private long tilesWritten = 0L;
    private long tilesOnDisk = 0L;
    private Timer swingTimer = null;
    private UpdateActionListener currentTask = null;
    private long lastTime = -1L;
    private static final Map<RenderingIntent, LCMSColorConvertDescriptor.RenderingIntent> renderingIntentMap;
    private ICC_Profile proofProfile = null;
    private LCMSColorConvertDescriptor.RenderingIntent proofIntent = null;

    public Rendering getRendering() {
        return this.rendering;
    }

    public AuxiliaryImageInfo getAuxInfo() {
        return this.auxInfo;
    }

    public ImageMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public AffineTransform getTransform() {
        return this.rendering.getTransform();
    }

    CropBounds getCropBounds() {
        return this.rendering.getCropBounds();
    }

    PlanarImage getSourceImage() {
        return this.sourceImage;
    }

    @Override
    public Dimension getNaturalSize() {
        return this.rendering.getRenderingSize();
    }

    @Override
    public synchronized Component getComponent() {
        if (this.canvas == null) {
            this.listeners = new LinkedList();
            this.canvas = new ImageEditorDisplay(this, null);
            this.canvas.setEngineListeners(this.listeners);
            this.canvas.setPaintListener(new CanvasPaintListener());
            if (this.addFirstPaintLatency) {
                this.canvas.setFirstTime();
            }
            if (this.backgroundImage != null) {
                this.canvas.setBackgroundImage(this.backgroundImage);
            }
            this.previews.add(new PassThroughPreview(this));
            this.previews.add(new ZoneFinder(this));
            this.previews.add(new ColorSelectionPreview(this));
            this.previews.add(new HistogramPreview(this));
            this.previews.add(new DropperPreview(this));
        }
        return this.canvas;
    }

    @Override
    public List<Preview> getPreviews() {
        return this.previews;
    }

    @Override
    public List getLayerModes() {
        return BlendedOperation.blendingModes;
    }

    @Override
    public List getPreferredScales() {
        return Arrays.asList(scales);
    }

    public void setFocusedZone(int index, double[][] controlPoints) {
        for (Preview preview : this.previews) {
            if (!preview.isShowing()) continue;
            if (preview instanceof ZoneFinder) {
                ((ZoneFinder)preview).setFocusedZone(index);
                continue;
            }
            if (!(preview instanceof HistogramPreview)) continue;
            ((HistogramPreview)preview).setFocusedZone(index, controlPoints);
        }
    }

    public ImageEditorEngine(ImageMetadata imageMetadata, ImageInfo exportInfo, ProgressThread thread) throws BadImageFileException, ColorProfileException, IOException, UnknownImageTypeException, UserCanceledException {
        String imagePath = imageMetadata.getPath();
        File imageFile = new File(imagePath).getCanonicalFile();
        this.m_imageInfo = ImageInfo.getInstanceFor(imageFile);
        this.m_exportInfo = exportInfo;
        System.out.println("Opening " + imageFile);
        this.metadata = imageMetadata;
        this.sourceImage = this.m_imageInfo.getImage(thread, true);
        this.auxInfo = this.m_imageInfo.getAuxiliaryInfo();
        if (this.sourceImage == null) {
            throw new IOException("Something wrong with opening " + this.metadata.getFile().getName());
        }
        ImageOrientation orientation = this.metadata.getOrientation();
        if (orientation != null) {
            this.transposeAngle = orientation.getCorrection();
            if (this.transposeAngle != null) {
                ParameterBlock pb = new ParameterBlock();
                pb.addSource(this.sourceImage);
                pb.add(this.transposeAngle);
                RenderedOp transposed = JAI.create((String)"Transpose", (ParameterBlock)pb, null);
                transposed.setProperty("LCPersistentCache", (Object)Boolean.TRUE);
                CachedImage cache = new CachedImage(new ImageLayout((RenderedImage)transposed), JAIContext.fileCache);
                for (int x = 0; x <= cache.getMaxTileX(); ++x) {
                    for (int y = 0; y <= cache.getMaxTileY(); ++y) {
                        Object[] dstData;
                        Object[] srcData;
                        if (transposed.getSampleModel().getDataType() == 1) {
                            srcData = ((DataBufferUShort)transposed.getTile(x, y).getDataBuffer()).getData();
                            dstData = ((DataBufferUShort)cache.getWritableTile(x, y).getDataBuffer()).getData();
                            System.arraycopy(srcData, 0, dstData, 0, srcData.length);
                            continue;
                        }
                        if (transposed.getSampleModel().getDataType() == 0) {
                            srcData = ((DataBufferByte)transposed.getTile(x, y).getDataBuffer()).getData();
                            dstData = ((DataBufferByte)cache.getWritableTile(x, y).getDataBuffer()).getData();
                            System.arraycopy(srcData, 0, dstData, 0, srcData.length);
                            continue;
                        }
                        throw new IllegalArgumentException("Unknown image data type: " + transposed.getSampleModel().getDataType());
                    }
                }
                this.sourceImage = cache;
                transposed.dispose();
            }
        }
        this.rendering = new Rendering(this.sourceImage, this);
        this.addFirstPaintLatency = true;
    }

    public ImageEditorEngine(RenderedImage image) {
        if (!(image instanceof PlanarImage)) {
            image = new RenderedImageAdapter(image);
        }
        this.sourceImage = (PlanarImage)image;
        this.rendering = new Rendering(this.sourceImage, this);
        this.backgroundImage = image;
    }

    @Override
    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        System.out.println("Disposing Engine");
        if (this.swingTimer != null) {
            ActionListener[] als;
            this.swingTimer.stop();
            for (ActionListener al : als = this.swingTimer.getActionListeners()) {
                this.swingTimer.removeActionListener(al);
            }
            this.swingTimer = null;
        }
        this.m_imageInfo = null;
        this.m_exportInfo = null;
        this.rendering.dispose();
        this.canvas.dispose();
        this.canvas = null;
        this.metadata = null;
        this.rendering = null;
        this.listeners = null;
        this.previews = null;
        if (this.sourceImage != null) {
            this.sourceImage.dispose();
            this.sourceImage = null;
        }
        if (this.processedImage != null) {
            this.processedImage.dispose();
            this.processedImage = null;
        }
        if (this.previewImage != null) {
            this.previewImage.dispose();
            this.previewImage = null;
        }
    }

    @Override
    public Collection<OperationType> getGenericOperationTypes() {
        return operationsSet.keySet();
    }

    @Override
    public Operation insertOperation(OperationType type, int position) {
        Class<? extends BlendedOperation> opClass = operationsSet.get(type);
        if (opClass.equals(RawAdjustmentsOperation.class) && !(this.getAuxInfo() instanceof RawImageInfo)) {
            throw new RuntimeException("RAW adjustments can not be applied to an image that is not in RAW format");
        }
        OperationImpl op = null;
        try {
            try {
                Constructor<? extends BlendedOperation> c = opClass.getConstructor(Rendering.class, OperationType.class);
                op = c.newInstance(this.rendering, type);
            }
            catch (NoSuchMethodException e) {
                Constructor<? extends BlendedOperation> c = opClass.getConstructor(Rendering.class);
                op = c.newInstance(this.rendering);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (op != null) {
            this.rendering.addOperation(position, op);
            if (!op.neutralDefault()) {
                this.update(op, false);
            }
        }
        return op;
    }

    @Override
    public ZoneOperation insertZoneOperation(int position) {
        ZoneOperationImpl op = new ZoneOperationImpl(this.rendering);
        this.rendering.addOperation(position, op);
        return op;
    }

    @Override
    public CloneOperation insertCloneOperation(int position) {
        CloneOperationImpl op = new CloneOperationImpl(this.rendering);
        this.rendering.addOperation(position, op);
        return op;
    }

    @Override
    public SpotOperation insertSpotOperation(int position) {
        SpotOperationImpl op = new SpotOperationImpl(this.rendering);
        this.rendering.addOperation(position, op);
        return op;
    }

    @Override
    public WhitePointOperation insertWhitePointOperation(int position) {
        WhitePointOperationImpl op = new WhitePointOperationImpl(this.rendering);
        this.rendering.addOperation(position, op);
        return op;
    }

    @Override
    public OperationType getRawAdjustmentsOperationType() {
        return RawAdjustmentsOperation.typeV2;
    }

    @Override
    public OperationType getGenericRawAdjustmentsOperationType() {
        return RawAdjustmentsOperation.typeV1;
    }

    @Override
    public void removeOperation(int position) {
        Operation currentSelection = this.selectedOperation >= 0 ? this.rendering.getOperation(this.selectedOperation) : null;
        OperationImpl op = (OperationImpl)this.rendering.removeOperation(position);
        op.dispose();
        if (currentSelection != null) {
            this.selectedOperation = this.rendering.indexOf(currentSelection);
        }
        this.update(op, false);
    }

    @Override
    public void swap(int position) {
        Operation currentSelection = this.selectedOperation >= 0 ? this.rendering.getOperation(this.selectedOperation) : null;
        OperationImpl op = (OperationImpl)this.rendering.removeOperation(position);
        this.rendering.addOperation(position + 1, op);
        if (currentSelection != null) {
            this.selectedOperation = this.rendering.indexOf(currentSelection);
        }
        this.update(op, false);
    }

    @Override
    public void setCropBounds(CropBounds crop) {
        this.rendering.setCropBounds(crop);
        this.update(null, false);
    }

    @Override
    public void setScale(Scale scale) {
        this.rendering.setScaleFactor(scale.getFactor());
        this.update(null, false);
    }

    @Override
    public Scale setScale(Rectangle rect) {
        Dimension dimension = this.getNaturalSize();
        double hScale = (double)rect.height / (double)dimension.height;
        double wScale = (double)rect.width / (double)dimension.width;
        this.rendering.setScaleFactor((float)Math.min(hScale, wScale));
        this.update(null, false);
        return new Scale(this.rendering.getScaleFactor());
    }

    public void update(OperationImpl op, boolean isLive) {
        this.update(op, isLive, null);
    }

    PlanarImage scaleFinal(PlanarImage image) {
        float scale;
        float f = scale = this.rendering.getScaleFactor() > 1.0f ? this.rendering.getScaleFactor() : 1.0f;
        if (scale == 1.0f) {
            return image;
        }
        float scaleX = (float)Math.floor(scale * (float)image.getWidth()) / (float)image.getWidth();
        float scaleY = (float)Math.floor(scale * (float)image.getHeight()) / (float)image.getHeight();
        AffineTransform xform = AffineTransform.getScaleInstance(scaleX, scaleY);
        RenderingHints formatHints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
        Interpolation interp = Interpolation.getInstance((int)0);
        ParameterBlock params = new ParameterBlock();
        params.addSource(image);
        params.add(xform);
        params.add(interp);
        return JAI.create((String)"Affine", (ParameterBlock)params, (RenderingHints)formatHints);
    }

    @Override
    public synchronized void setSelectedOperation(int position, boolean selected) {
        OperationImpl op = (OperationImpl)this.rendering.getOperation(position);
        if (op != null) {
            op.setSelected(selected);
        }
        this.selectedOperation = selected && op != null ? position : -1;
        this.update(null, false);
    }

    public synchronized Operation getSelectedOperation() {
        if (this.selectedOperation >= 0) {
            return this.rendering.getOperation(this.selectedOperation);
        }
        return null;
    }

    public synchronized int getSelectedOperationIndex() {
        return this.selectedOperation;
    }

    public PlanarImage getRendering(int stopBefore) {
        if (stopBefore >= 0) {
            return this.rendering.getRendering(stopBefore);
        }
        return null;
    }

    public synchronized void update(OperationImpl op, boolean isLive, Object updater) {
        if (this.canvas == null || !this.event_filter(isLive, updater)) {
            return;
        }
        PlanarImage oldProcessedImage = this.processedImage;
        this.processedImage = this.rendering.getRendering(!this.engineActive);
        this.processedImage.setProperty("LCPersistentCache", (Object)Boolean.TRUE);
        if (oldProcessedImage != null) {
            oldProcessedImage.dispose();
        }
        if (this.previewImage != null) {
            this.previewImage.dispose();
        }
        this.previewImage = Functions.fromUShortToByte((RenderedImage)Functions.toColorSpace((RenderedImage)this.processedImage, JAIContext.systemColorSpace, this.proofProfile, null, this.proofIntent, null), null);
        this.previewImage.setProperty("LCPersistentCache", (Object)Boolean.TRUE);
        PlanarImage finalImage = this.scaleFinal(this.previewImage);
        this.canvas.set(finalImage, isLive);
    }

    private boolean event_filter(boolean isLive, Object updater) {
        if (updater != null && updater != this.currentTask) {
            return false;
        }
        if (isLive) {
            long timeNow = System.currentTimeMillis();
            long timeDiff = this.lastTime == -1L ? 0L : timeNow - this.lastTime;
            this.lastTime = timeNow;
            long delay = Math.min(Math.max(this.synchImageRepaintTime, 300L), 1000L);
            if (timeDiff < delay) {
                if (this.swingTimer != null) {
                    if (this.currentTask != null) {
                        this.swingTimer.removeActionListener(this.currentTask);
                    }
                    this.currentTask = new UpdateActionListener();
                    this.swingTimer.addActionListener(this.currentTask);
                    this.swingTimer.setInitialDelay((int)delay);
                    if (this.swingTimer.isRunning()) {
                        this.swingTimer.restart();
                    } else {
                        this.swingTimer.start();
                    }
                } else {
                    this.currentTask = new UpdateActionListener();
                    this.swingTimer = new Timer((int)delay, this.currentTask);
                    this.swingTimer.setRepeats(false);
                    this.swingTimer.start();
                }
                return false;
            }
            this.swingTimer.removeActionListener(this.currentTask);
            this.currentTask = null;
            this.lastTime = -1L;
        } else {
            if (this.swingTimer != null && this.swingTimer.isRunning()) {
                this.swingTimer.stop();
                this.swingTimer.removeActionListener(this.currentTask);
                this.currentTask = null;
            }
            this.lastTime = -1L;
        }
        return true;
    }

    @Override
    public void print(ProgressThread thread, PageFormat format, PrintSettings settings) throws PrinterException {
        Platform.getPlatform().getPrinterLayer().print(this, thread, format, settings);
    }

    @Override
    public void cancelPrint() {
        Platform.getPlatform().getPrinterLayer().cancelPrint();
    }

    public static LCMSColorConvertDescriptor.RenderingIntent getLCMSIntent(RenderingIntent intent) {
        return renderingIntentMap.get(intent);
    }

    public ICC_Profile getProofProfile() {
        return this.proofProfile;
    }

    public LCMSColorConvertDescriptor.RenderingIntent getProofIntent() {
        return this.proofIntent;
    }

    @Override
    public void preview(PrintSettings settings) {
        if (settings != null) {
            this.proofProfile = settings.getColorProfile();
            this.proofIntent = renderingIntentMap.get(settings.getRenderingIntent());
        } else {
            this.proofProfile = null;
            this.proofIntent = null;
        }
        this.update(null, false);
    }

    public PlanarImage getRendering(Dimension bounds) {
        return this.getRendering(bounds, JAIContext.sRGBColorProfile, true);
    }

    public PlanarImage getRendering(Dimension bounds, ICC_Profile profile, boolean eightBits) {
        return this.getRendering(bounds, profile, null, eightBits);
    }

    public PlanarImage getRendering(Dimension bounds, ICC_Profile profile, LCMSColorConvertDescriptor.RenderingIntent intent, boolean eightBits) {
        Dimension dimension = this.getNaturalSize();
        float scale = bounds != null ? Math.min((float)bounds.width / (float)dimension.getWidth(), (float)bounds.height / (float)dimension.getHeight()) : 1.0f;
        Rendering newRendering = this.canvas != null ? this.rendering.clone() : this.rendering;
        newRendering.setCropAndScale(this.getCropBounds(), scale);
        PlanarImage image = newRendering.getRendering();
        if (profile != null) {
            ICC_ColorSpace exportColorSpace = profile == JAIContext.sRGBColorProfile ? JAIContext.sRGBColorSpace : new ICC_ColorSpace(profile);
            image = intent != null ? Functions.toColorSpace((RenderedImage)image, exportColorSpace, intent, null) : Functions.toColorSpace((RenderedImage)image, exportColorSpace, null);
        }
        if (eightBits) {
            image = Functions.fromUShortToByte((RenderedImage)image, null);
        }
        return image;
    }

    public void prefetchRendering(Rectangle area) {
        this.rendering.prefetch(area);
    }

    @Override
    public void write(ProgressThread thread, ImageExportOptions exportOptions) throws IOException {
        ImageFileExportOptions fileOptions = (ImageFileExportOptions)exportOptions;
        ImageType exportType = exportOptions.getImageType();
        int exportWidth = fileOptions.resizeWidth.getValue();
        int exportHeight = fileOptions.resizeHeight.getValue();
        String exportProfileName = fileOptions.colorProfile.getValue();
        ICC_Profile profile = ColorProfileInfo.getExportICCProfileFor(exportProfileName);
        if (profile == null) {
            profile = JAIContext.sRGBExportColorProfile;
        }
        byte[] lzn = exportOptions.getAuxData();
        PlanarImage exportImage = this.getRendering(new Dimension(exportWidth, exportHeight), profile, exportType instanceof JPEGImageType || exportOptions.getIntValueOf(BitsPerChannelOption.NAME) == 8);
        double scale = Math.min((double)exportWidth / (double)exportImage.getWidth(), (double)exportHeight / (double)exportImage.getHeight());
        if (scale > 1.0) {
            AffineTransform xform = AffineTransform.getScaleInstance(scale, scale);
            RenderingHints formatHints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
            Interpolation interp = Interpolation.getInstance((int)3);
            ParameterBlock params = new ParameterBlock();
            params.addSource(exportImage);
            params.add(xform);
            params.add(interp);
            exportImage = JAI.create((String)"Affine", (ParameterBlock)params, (RenderingHints)formatHints);
        }
        if (fileOptions.resizeWidth.getValue() > exportImage.getWidth()) {
            fileOptions.resizeWidth.setValue(exportImage.getWidth());
        }
        if (fileOptions.resizeHeight.getValue() > exportImage.getHeight()) {
            fileOptions.resizeHeight.setValue(exportImage.getHeight());
        }
        if (exportImage instanceof RenderedOp) {
            RenderedOp rop = (RenderedOp)exportImage;
            rop.setProperty("LCPersistentCache", (Object)Boolean.TRUE);
        }
        if (this.m_exportInfo != null) {
            exportType.putImage(this.m_exportInfo, exportImage, exportOptions, lzn, thread);
        } else {
            exportType.putImage(this.m_imageInfo, exportImage, exportOptions, lzn, thread);
        }
    }

    public Color getPixelValue(int x, int y) {
        int[] rgb = new int[3];
        boolean numSamples = false;
        boolean red = false;
        boolean green = false;
        boolean blue = false;
        Point2D p = this.rendering.getInputTransform().transform(new Point(x, y), null);
        x = (int)p.getX();
        y = (int)p.getY();
        Rectangle bounds = this.processedImage.getBounds();
        if (!bounds.contains(x, y)) {
            return null;
        }
        Raster tile = this.processedImage.getTile(this.processedImage.XToTileX(x), this.processedImage.YToTileY(y));
        rgb = tile.getPixel(x, y, rgb);
        return new Color((float)rgb[0] / 65535.0f, (float)rgb[1] / 65535.0f, (float)rgb[2] / 65535.0f);
    }

    @Override
    public List getDebugItems() {
        ArrayList items = new ArrayList();
        return items;
    }

    @Override
    public void setActive(boolean active) {
        if (this.engineActive != active) {
            this.engineActive = active;
            this.update(null, false);
        }
    }

    @Override
    public void addEngineListener(EngineListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeEngineListener(EngineListener listener) {
        this.listeners.remove(listener);
    }

    public void notifyListeners(int level) {
        for (EngineListener listener : this.listeners) {
            listener.engineActive(level);
        }
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }

    static {
        operationsSet.put(UnSharpMaskOperation.typeV1, UnSharpMaskOperation.class);
        operationsSet.put(UnSharpMaskOperation.typeV2, UnSharpMaskOperation.class);
        operationsSet.put(UnSharpMaskOperation.typeV3, UnSharpMaskOperation.class);
        operationsSet.put(NoiseReductionOperation.type, NoiseReductionOperation.class);
        operationsSet.put(AdvancedNoiseReductionOperation.typeV1, AdvancedNoiseReductionOperation.class);
        operationsSet.put(AdvancedNoiseReductionOperation.typeV2, AdvancedNoiseReductionOperation.class);
        operationsSet.put(AdvancedNoiseReductionOperation.typeV3, AdvancedNoiseReductionOperation.class);
        operationsSet.put(AdvancedNoiseReductionOperationV4.type, AdvancedNoiseReductionOperationV4.class);
        operationsSet.put(HiPassFilterOperation.type, HiPassFilterOperation.class);
        operationsSet.put(HueSaturationOperation.typeV1, HueSaturationOperation.class);
        operationsSet.put(HueSaturationOperation.typeV2, HueSaturationOperation.class);
        operationsSet.put(HueSaturationOperation.typeV3, HueSaturationOperation.class);
        operationsSet.put(GaussianBlurOperation.type, GaussianBlurOperation.class);
        operationsSet.put(HDROperation.type, HDROperation.class);
        operationsSet.put(HDROperationV2.typeV2, HDROperationV2.class);
        operationsSet.put(HDROperationV2.typeV3, HDROperationV2.class);
        operationsSet.put(HDROperationV2.typeV4, HDROperationV2.class);
        operationsSet.put(HDROperationV3.typeV5, HDROperationV3.class);
        operationsSet.put(ContrastMaskOperation.type, ContrastMaskOperation.class);
        operationsSet.put(WhiteBalanceV2.typeV2, WhiteBalanceV2.class);
        operationsSet.put(WhiteBalanceV2.typeV3, WhiteBalanceV2.class);
        operationsSet.put(WhiteBalance.type, WhiteBalance.class);
        operationsSet.put(ChannelMixer.type, ChannelMixer.class);
        operationsSet.put(ChannelMixerV2.typeV2, ChannelMixerV2.class);
        operationsSet.put(ChannelMixerV2.typeV3, ChannelMixerV2.class);
        operationsSet.put(ChannelMixerV2.typeV4, ChannelMixerV2.class);
        operationsSet.put(ColorBalanceOperationV2.typeV2, ColorBalanceOperationV2.class);
        operationsSet.put(ColorBalanceOperationV2.typeV3, ColorBalanceOperationV2.class);
        operationsSet.put(ColorBalanceOperation.type, ColorBalanceOperation.class);
        operationsSet.put(RedEyesOperation.type, RedEyesOperation.class);
        operationsSet.put(RawAdjustmentsOperation.typeV1, RawAdjustmentsOperation.class);
        operationsSet.put(RawAdjustmentsOperation.typeV2, RawAdjustmentsOperation.class);
        renderingIntentMap = new HashMap<RenderingIntent, LCMSColorConvertDescriptor.RenderingIntent>();
        renderingIntentMap.put(RenderingIntent.RELATIVE_COLORIMETRIC, LCMSColorConvertDescriptor.RELATIVE_COLORIMETRIC);
        renderingIntentMap.put(RenderingIntent.PERCEPTUAL, LCMSColorConvertDescriptor.PERCEPTUAL);
        renderingIntentMap.put(RenderingIntent.SATURATION, LCMSColorConvertDescriptor.SATURATION);
        renderingIntentMap.put(RenderingIntent.ABSOLUTE_COLORIMETRIC, LCMSColorConvertDescriptor.ABSOLUTE_COLORIMETRIC);
        renderingIntentMap.put(RenderingIntent.RELATIVE_COLORIMETRIC_BP, LCMSColorConvertDescriptor.RELATIVE_COLORIMETRIC_BP);
    }

    class GrayPatchesImage
    extends BufferedImage {
        static final int height = 512;
        static final int width = 256;

        GrayPatchesImage(int steps) {
            super(JAIContext.colorModel_sRGB8, JAIContext.colorModel_sRGB8.createCompatibleWritableRaster(256, 512), false, null);
            Graphics g = this.getGraphics();
            if (DEBUG) {
                System.out.print("Colors: ");
            }
            for (int i = 0; i < steps; ++i) {
                float color = (float)(Math.pow(2.0, (double)i * 8.0 / (double)(steps - 1)) - 1.0) / 255.0f;
                float[] srgbColor = Functions.fromLinearToCS(JAIContext.systemColorSpace, new float[]{color, color, color});
                if (DEBUG) {
                    System.out.print(", " + i + ":" + (int)(255.0f * color) + " -> " + (int)(255.0f * srgbColor[0]));
                }
                g.setColor(new Color((int)(255.0f * srgbColor[0]), (int)(255.0f * srgbColor[1]), (int)(255.0f * srgbColor[2])));
                g.fillRect(0, i * 512 / steps, 256, (i + 1) * 512 / steps - i * 512 / steps);
            }
            if (DEBUG) {
                System.out.println();
            }
        }
    }

    class UpdateActionListener
    implements ActionListener {
        UpdateActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ImageEditorEngine.this.update(null, true, this);
        }
    }

    class CanvasPaintListener
    implements PaintListener {
        CanvasPaintListener() {
        }

        @Override
        public void paintDone(PlanarImage image, Rectangle visibleRect, boolean synchronous, long time) {
            TileCache tileCache;
            if (synchronous) {
                ImageEditorEngine.this.synchImageRepaintTime = (ImageEditorEngine.this.synchImageRepaintTime + time) / 2L;
            }
            if ((tileCache = JAI.getDefaultInstance().getTileCache()) instanceof LCTileCache) {
                LCTileCache tc = (LCTileCache)tileCache;
                if (ImageEditorEngine.this.tilesRead != tc.tilesRead() || ImageEditorEngine.this.tilesWritten != tc.tilesWritten() || ImageEditorEngine.this.tilesOnDisk != tc.tilesOnDisk()) {
                    ImageEditorEngine.this.tilesRead = tc.tilesRead();
                    ImageEditorEngine.this.tilesWritten = tc.tilesWritten();
                    ImageEditorEngine.this.tilesOnDisk = tc.tilesOnDisk();
                    System.out.println("Tile Cache Statistics r: " + ImageEditorEngine.this.tilesRead + ", w: " + ImageEditorEngine.this.tilesWritten + ", on disk: " + ImageEditorEngine.this.tilesOnDisk);
                }
            }
            for (Preview preview : ImageEditorEngine.this.previews) {
                if (!preview.isShowing() || !(preview instanceof PaintListener)) continue;
                float renderingScale = ImageEditorEngine.this.rendering.getScaleFactor();
                Rectangle previewVisibleRect = visibleRect;
                if (renderingScale > 1.0f) {
                    previewVisibleRect = new Rectangle((int)((float)visibleRect.x / renderingScale), (int)((float)visibleRect.y / renderingScale), (int)((float)visibleRect.width / renderingScale), (int)((float)visibleRect.height / renderingScale));
                }
                ((PaintListener)((Object)preview)).paintDone(preview instanceof ZoneFinder ? ImageEditorEngine.this.previewImage : ImageEditorEngine.this.processedImage, previewVisibleRect, synchronous, time);
            }
        }
    }
}

