/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.model.ImageEditor;

import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.jai.opimage.CachedImage;
import com.lightcrafts.jai.utils.Functions;
import com.lightcrafts.mediax.jai.BorderExtender;
import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.Interpolation;
import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.KernelJAI;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.mediax.jai.RenderedOp;
import com.lightcrafts.model.CropBounds;
import com.lightcrafts.model.ImageEditor.BlendedOperation;
import com.lightcrafts.model.ImageEditor.ImageEditorEngine;
import com.lightcrafts.model.ImageEditor.OperationImpl;
import com.lightcrafts.model.Operation;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.util.LinkedList;
import java.util.Vector;

public class Rendering
implements Cloneable {
    private float scaleFactor = 1.0f;
    private CropBounds cropBounds = new CropBounds();
    private AffineTransform inputTransform = new AffineTransform();
    private AffineTransform transform = new AffineTransform();
    private final PlanarImage sourceImage;
    private PlanarImage xformedSourceImage;
    private ImageEditorEngine engine;
    private LinkedList<Operation> pipeline = new LinkedList();
    private ImagePyramid pyramid;
    public boolean cheapScale = false;
    private static final int MIP_SCALE_RATIO = 2;

    public Rendering clone() {
        try {
            Rendering object = (Rendering)super.clone();
            object.engine = null;
            RenderedOp downSampler = this.createDownScaleOp((RenderedImage)this.sourceImage, 2);
            downSampler.removeSources();
            object.inputTransform = this.buildTransform(true);
            object.transform = this.buildTransform(false);
            object.xformedSourceImage = null;
            object.pipeline = new LinkedList();
            for (Operation op : this.pipeline) {
                object.pipeline.add(((BlendedOperation)op).clone(object));
            }
            return object;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    void dispose() {
        if (this.pipeline != null) {
            while (!this.pipeline.isEmpty()) {
                this.pipeline.removeLast().dispose();
            }
            this.pipeline = null;
        }
    }

    void addOperation(int position, Operation op) {
        this.pipeline.add(position, op);
    }

    Operation removeOperation(int position) {
        return this.pipeline.remove(position);
    }

    public int indexOf(Operation op) {
        return this.pipeline.indexOf(op);
    }

    public Operation getOperation(int index) {
        return this.pipeline.get(index);
    }

    protected RenderedOp createDownScaleOp(RenderedImage src, int ratio) {
        KernelJAI kernel = Functions.getLanczos2Kernel(ratio);
        int ko = kernel.getXOrigin();
        float[] kdata = kernel.getHorizontalKernelData();
        float[] qsFilterArray = new float[kdata.length - ko];
        System.arraycopy(kdata, ko, qsFilterArray, 0, qsFilterArray.length);
        ParameterBlock params = new ParameterBlock();
        params.addSource(src);
        params.add(ratio);
        params.add(ratio);
        params.add(qsFilterArray);
        params.add(Interpolation.getInstance((int)0));
        return JAI.create((String)"FilteredSubsample", (ParameterBlock)params, (RenderingHints)new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1)));
    }

    public Rendering(PlanarImage sourceImage, ImageEditorEngine engine) {
        this.sourceImage = sourceImage;
        this.engine = engine;
        RenderedOp downSampler = this.createDownScaleOp((RenderedImage)sourceImage, 2);
        downSampler.removeSources();
        this.pyramid = new ImagePyramid((RenderedImage)sourceImage);
        this.xformedSourceImage = null;
        this.inputTransform = this.buildTransform(true);
        this.transform = this.buildTransform(false);
    }

    public Rendering(PlanarImage sourceImage) {
        this(sourceImage, null);
    }

    ImageEditorEngine getEngine() {
        return this.engine;
    }

    public void update(OperationImpl op, boolean isLive) {
        if (this.engine != null) {
            this.engine.update(op, isLive);
        }
    }

    public AffineTransform getInputTransform() {
        return new AffineTransform(this.inputTransform);
    }

    public AffineTransform getTransform() {
        return new AffineTransform(this.transform);
    }

    public void setCropBounds(CropBounds cropBounds) {
        if (!cropBounds.equals(this.cropBounds)) {
            this.cropBounds = cropBounds;
            this.inputTransform = this.buildTransform(true);
            this.transform = this.buildTransform(false);
            if (this.xformedSourceImage != null) {
                this.xformedSourceImage.dispose();
                this.xformedSourceImage = null;
            }
        }
    }

    public CropBounds getCropBounds() {
        return this.cropBounds;
    }

    public void setScaleFactor(float scaleFactor) {
        if (scaleFactor != this.scaleFactor) {
            this.scaleFactor = scaleFactor;
            this.inputTransform = this.buildTransform(true);
            this.transform = this.buildTransform(false);
            if (this.xformedSourceImage != null) {
                this.xformedSourceImage.dispose();
                this.xformedSourceImage = null;
            }
        }
    }

    public float getScaleFactor() {
        return this.scaleFactor;
    }

    public void setCropAndScale(CropBounds cropBounds, float scaleFactor) {
        if (!cropBounds.equals(this.cropBounds) || scaleFactor != this.scaleFactor) {
            this.cropBounds = cropBounds;
            this.scaleFactor = scaleFactor;
            this.inputTransform = this.buildTransform(true);
            this.transform = this.buildTransform(false);
            if (this.xformedSourceImage != null) {
                this.xformedSourceImage.dispose();
                this.xformedSourceImage = null;
            }
        }
    }

    public PlanarImage getXformedSourceImage() {
        if (this.xformedSourceImage == null) {
            this.xformedSourceImage = this.transformSourceImage();
        }
        return this.xformedSourceImage;
    }

    public PlanarImage getRendering(boolean inactive, int stopBefore) {
        PlanarImage processedImage = this.getXformedSourceImage();
        if (this.pipeline == null) {
            System.out.println("Rendering.renderPipeline: null pipeline?");
            return processedImage;
        }
        int index = 0;
        for (Operation op : this.pipeline) {
            PlanarImage result;
            OperationImpl operation = (OperationImpl)op;
            if (index == stopBefore) break;
            if (!(!operation.isActive() || inactive && operation.isDeactivatable() || (result = operation.render(processedImage, this.scaleFactor < 1.0f ? this.scaleFactor : 1.0f)) == null)) {
                processedImage = result;
            }
            ++index;
        }
        return processedImage;
    }

    public void prefetch(Rectangle area) {
        if (this.pipeline == null) {
            System.out.println("Rendering.renderPipeline: null pipeline?");
            return;
        }
        PlanarImage processedImage = this.getXformedSourceImage();
        int index = 0;
        for (Operation operation : this.pipeline) {
            PlanarImage result;
            if (operation.isActive() && (result = ((OperationImpl)operation).render(processedImage, this.scaleFactor < 1.0f ? this.scaleFactor : 1.0f)) != null) {
                Point[] indices = result.getTileIndices(area);
                if (indices != null) {
                    CachedImage cachedResult = new CachedImage(new ImageLayout((RenderedImage)result), JAIContext.fileCache);
                    result.prefetchTiles(indices);
                    for (Point tile : indices) {
                        Raster newTile = result.getTile(tile.x, tile.y);
                        WritableRaster cachedTile = cachedResult.getWritableTile(tile.x, tile.y);
                        Functions.copyData(cachedTile, newTile);
                    }
                    result = cachedResult;
                }
                System.out.println("Rendered layer " + index);
                processedImage = result;
            }
            ++index;
        }
    }

    public PlanarImage getRendering() {
        return this.getRendering(false, -1);
    }

    public PlanarImage getRendering(boolean inactive) {
        return this.getRendering(inactive, -1);
    }

    public PlanarImage getRendering(int stopBefore) {
        return this.getRendering(false, stopBefore);
    }

    public Dimension getRenderingSize() {
        if (this.cropBounds.isAngleOnly()) {
            Rectangle sourceBounds = new Rectangle(this.sourceImage.getBounds());
            if (this.cropBounds.getAngle() != 0.0) {
                Point2D.Double center = new Point2D.Double(sourceBounds.getCenterX(), sourceBounds.getCenterY());
                sourceBounds = AffineTransform.getRotateInstance(-this.cropBounds.getAngle(), ((Point2D)center).getX(), ((Point2D)center).getY()).createTransformedShape(sourceBounds).getBounds();
            }
            return new Dimension(sourceBounds.width, sourceBounds.height);
        }
        return new Dimension((int)this.cropBounds.getWidth(), (int)this.cropBounds.getHeight());
    }

    private AffineTransform buildTransform(boolean isInputTransform) {
        Rectangle sourceBounds = new Rectangle(this.sourceImage.getBounds());
        AffineTransform transform = new AffineTransform();
        if (this.scaleFactor < 1.0f || !isInputTransform) {
            double scaleX = (double)Math.round(this.scaleFactor * (float)sourceBounds.width) / (double)sourceBounds.width;
            double scaleY = (double)Math.round(this.scaleFactor * (float)sourceBounds.height) / (double)sourceBounds.height;
            double scale = Math.min(scaleX, scaleY);
            transform.preConcatenate(AffineTransform.getScaleInstance(scale, scale));
        }
        if (this.cropBounds.getAngle() != 0.0) {
            Rectangle2D bounds = transform.createTransformedShape(sourceBounds).getBounds2D();
            Point2D.Double center = new Point2D.Double(bounds.getCenterX(), bounds.getCenterY());
            transform.preConcatenate(AffineTransform.getRotateInstance(-this.cropBounds.getAngle(), ((Point2D)center).getX(), ((Point2D)center).getY()));
            bounds = transform.createTransformedShape(sourceBounds).getBounds2D();
            transform.preConcatenate(AffineTransform.getTranslateInstance(-bounds.getMinX(), -bounds.getMinY()));
        }
        if (!this.cropBounds.isAngleOnly()) {
            CropBounds actualCropBounds = CropBounds.transform(transform, this.cropBounds);
            Point2D cropUpperLeft = actualCropBounds.getUpperLeft();
            transform.preConcatenate(AffineTransform.getTranslateInstance(-cropUpperLeft.getX(), -cropUpperLeft.getY()));
        }
        return transform;
    }

    private PlanarImage transformSourceImage() {
        PlanarImage image;
        PlanarImage xformedSourceImage = image = this.sourceImage;
        AffineTransform completeInputTransform = this.inputTransform;
        if (!completeInputTransform.isIdentity()) {
            AffineTransform transform = completeInputTransform;
            Point2D zero = transform.transform(new Point2D.Double(0.0, 0.0), null);
            Point2D one = transform.transform(new Point2D.Double(1.0, 1.0), null);
            double dx = one.getX() - zero.getX();
            double dy = one.getY() - zero.getY();
            double scale = Math.sqrt((dx * dx + dy * dy) / 2.0);
            if (!this.cheapScale && scale <= 0.5) {
                int level = 0;
                while (scale <= 0.5) {
                    scale *= 2.0;
                    ++level;
                }
                image = (PlanarImage)this.pyramid.getImage(level);
                transform = new AffineTransform(transform);
                transform.concatenate(AffineTransform.getScaleInstance((double)this.sourceImage.getWidth() / (double)image.getWidth(), (double)this.sourceImage.getHeight() / (double)image.getHeight()));
            }
            if (!transform.isIdentity()) {
                RenderingHints extenderHints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
                ParameterBlock params = new ParameterBlock();
                params.addSource(image);
                params.add(transform);
                params.add(Interpolation.getInstance((int)(this.cheapScale ? 1 : 2)));
                xformedSourceImage = JAI.create((String)"Affine", (ParameterBlock)params, (RenderingHints)extenderHints);
            } else {
                xformedSourceImage = image;
            }
        }
        if (!this.cropBounds.isAngleOnly()) {
            CropBounds actualCropBounds = CropBounds.transform(completeInputTransform, this.cropBounds);
            Rectangle bounds = new Rectangle(xformedSourceImage.getMinX(), xformedSourceImage.getMinY(), xformedSourceImage.getWidth(), xformedSourceImage.getHeight());
            Rectangle finalBounds = bounds.intersection(new Rectangle(0, 0, (int)Math.round(actualCropBounds.getWidth()), (int)Math.round(actualCropBounds.getHeight())));
            if (finalBounds.width > 0 && finalBounds.height > 0) {
                xformedSourceImage = Functions.crop((RenderedImage)xformedSourceImage, finalBounds.x, finalBounds.y, finalBounds.width, finalBounds.height, null);
            }
        }
        if ((xformedSourceImage = Functions.toUShortLinear(xformedSourceImage, null)) instanceof RenderedOp) {
            xformedSourceImage.setProperty("LCPersistentCache", (Object)Boolean.TRUE);
        }
        return xformedSourceImage;
    }

    class ImagePyramid {
        private RenderedImage currentImage;
        private int currentLevel = 0;
        Vector<RenderedImage> renderings = new Vector();

        ImagePyramid(RenderedImage image) {
            this.currentImage = image;
            this.renderings.addElement(this.currentImage);
        }

        public RenderedImage getUpImage() {
            if (this.currentLevel > 0) {
                --this.currentLevel;
                this.currentImage = this.renderings.get(this.currentLevel);
            }
            return this.currentImage;
        }

        public RenderedImage getDownImage() {
            ++this.currentLevel;
            if (this.renderings.size() <= this.currentLevel) {
                RenderedOp smaller = Rendering.this.createDownScaleOp(this.currentImage, 2);
                smaller.setProperty("LCPersistentCache", (Object)Boolean.TRUE);
                this.renderings.addElement((RenderedImage)smaller);
                this.currentImage = smaller;
                return this.currentImage;
            }
            this.currentImage = this.renderings.get(this.currentLevel);
            return this.currentImage;
        }

        public RenderedImage getImage(int level) {
            if (level < 0) {
                return null;
            }
            while (this.currentLevel < level) {
                this.getDownImage();
            }
            while (this.currentLevel > level) {
                this.getUpImage();
            }
            return this.currentImage;
        }
    }
}

