/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.model.ImageEditor;

import Jama.Matrix;
import com.lightcrafts.image.types.AuxiliaryImageInfo;
import com.lightcrafts.jai.utils.Transform;
import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.LookupTableJAI;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.mediax.jai.RenderedOp;
import com.lightcrafts.model.ColorDropperOperation;
import com.lightcrafts.model.ImageEditor.BlendedOperation;
import com.lightcrafts.model.ImageEditor.OperationTypeImpl;
import com.lightcrafts.model.ImageEditor.Rendering;
import com.lightcrafts.model.OperationType;
import com.lightcrafts.model.SliderConfig;
import com.lightcrafts.utils.ColorScience;
import com.lightcrafts.utils.splines;
import java.awt.geom.Point2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.TreeMap;

public class WhiteBalanceV2
extends BlendedOperation
implements ColorDropperOperation {
    static final String SOURCE = "Temperature";
    private final String TINT = "Tint";
    private float tint = 0.0f;
    private Point2D p = null;
    static final OperationType typeV2 = new OperationTypeImpl("White Point V2");
    static final OperationType typeV3 = new OperationTypeImpl("White Point V3");
    private float source = 5000.0f;
    private float REF_T = 5000.0f;
    private ColorScience.CAMethod caMethod = ColorScience.CAMethod.Bradford;
    static Matrix RGBtoZYX = new Matrix(ColorScience.RGBtoZYX()).transpose();
    static Matrix XYZtoRGB = RGBtoZYX.inverse();

    public WhiteBalanceV2(Rendering rendering, OperationType type) {
        super(rendering, type);
        this.colorInputOnly = true;
        this.caMethod = ColorScience.CAMethod.Mixed;
        AuxiliaryImageInfo auxInfo = rendering.getEngine().getAuxInfo();
        this.addSliderKey(SOURCE);
        this.addSliderKey("Tint");
        this.setSliderConfig(SOURCE, new SliderConfig(1000.0, 40000.0, this.source, 10.0, true, new DecimalFormat("0")));
        this.setSliderConfig("Tint", new SliderConfig(-20.0, 20.0, this.tint, 0.1, false, new DecimalFormat("0.0")));
    }

    @Override
    public boolean neutralDefault() {
        return false;
    }

    @Override
    public void setSliderValue(String key, double value) {
        value = this.roundValue(key, value);
        if (key == SOURCE && (double)this.source != value) {
            this.source = (float)value;
        } else if (key == "Tint" && (double)this.tint != value) {
            this.tint = (float)value;
        } else {
            return;
        }
        super.setSliderValue(key, value);
    }

    static float[] W(float original, float target) {
        float[] originalW = ColorScience.W(original);
        float[] targetW = ColorScience.W(target);
        return new float[]{originalW[0] / targetW[0], originalW[1] / targetW[1], originalW[2] / targetW[2]};
    }

    @Override
    public Map<String, Float> setColor(Point2D p) {
        this.p = p;
        this.settingsChanged();
        this.p = null;
        TreeMap<String, Float> result = new TreeMap<String, Float>();
        result.put(SOURCE, Float.valueOf(this.source));
        result.put("Tint", Float.valueOf(this.tint));
        return result;
    }

    static float[] neutralize(int[] pixel, ColorScience.CAMethod caMethod, float source, float REF_T) {
        double r = pixel[0];
        double g = pixel[1];
        double b = pixel[2];
        double sat = ColorScience.saturation(r, g, b);
        int minT = (int)source;
        double wbr = 0.0;
        double wbg = 0.0;
        double wbb = 0.0;
        int t = 1000;
        while (t < 40000) {
            Matrix B = new Matrix(ColorScience.chromaticAdaptation(REF_T, t, caMethod));
            Matrix combo = XYZtoRGB.times(B.times(RGBtoZYX));
            Matrix color = new Matrix(new double[][]{{pixel[0]}, {pixel[1]}, {pixel[2]}});
            r = (color = combo.times(color)).get(0, 0);
            double tSat = ColorScience.saturation(r, g = color.get(1, 0), b = color.get(2, 0));
            if (tSat < sat) {
                sat = tSat;
                minT = t;
                wbr = r / 256.0;
                wbg = g / 256.0;
                wbb = b / 256.0;
            }
            t = (int)((double)t + 0.001 * (double)t);
        }
        if (wbr != 0.0 || wbg != 0.0 || wbb != 0.0) {
            System.out.println("wb: " + wbr + ", " + wbg + ", " + wbb + ", sat: " + sat);
            return new float[]{minT, (float)(-(wbg - (wbr + wbb) / 2.0))};
        }
        return new float[]{REF_T, 0.0f};
    }

    public static PlanarImage whiteBalance(RenderedImage image, float source, float REF_T, float tint, float lightness, ColorScience.CAMethod caMethod) {
        return WhiteBalanceV2.whiteBalance(image, source, REF_T, tint, lightness, 1.0f, null, caMethod);
    }

    public static float[][] whiteBalanceMatrix(float source, float REF_T, float mult, float[][] cameraRGB, ColorScience.CAMethod caMethod) {
        Matrix B = new Matrix(ColorScience.chromaticAdaptation(REF_T, source, caMethod));
        Matrix combo = XYZtoRGB.times(B.times(RGBtoZYX));
        Matrix m = combo.times(new Matrix(new double[][]{{1.0}, {1.0}, {1.0}}));
        double max = m.get(1, 0);
        if (max != 1.0) {
            combo = combo.times(new Matrix(new double[][]{{1.0 / max, 0.0, 0.0}, {0.0, 1.0 / max, 0.0}, {0.0, 0.0, 1.0 / max}}));
        }
        if (cameraRGB != null) {
            combo = combo.times(new Matrix(cameraRGB));
        }
        if (mult != 1.0f) {
            combo = combo.times(mult);
        }
        return combo.getArrayFloat();
    }

    public static PlanarImage tintCast(PlanarImage image, float tint, float lightness) {
        if (tint != 0.0f) {
            int i;
            double tred = -tint / 4.0f;
            double tgreen = tint / 2.0f;
            double tblue = -tint / 4.0f;
            double[][] polygon = new double[][]{{0.0, 0.0}, {lightness, 0.0}, {1.0, 0.0}};
            polygon[1][1] = tred;
            double[][] redCurve = new double[256][2];
            splines.bspline(2, polygon, redCurve);
            polygon[1][1] = tgreen;
            double[][] greenCurve = new double[256][2];
            splines.bspline(2, polygon, greenCurve);
            polygon[1][1] = tblue;
            double[][] blueCurve = new double[256][2];
            splines.bspline(2, polygon, blueCurve);
            short[][] table = new short[3][65536];
            splines.Interpolator interpolator = new splines.Interpolator();
            for (i = 0; i < 65536; ++i) {
                table[0][i] = (short)(0xFFFF & (int)Math.min(Math.max((double)i + 255.0 * interpolator.interpolate((double)i / 65535.0, redCurve), 0.0), 65535.0));
            }
            interpolator.reset();
            for (i = 0; i < 65536; ++i) {
                table[1][i] = (short)(0xFFFF & (int)Math.min(Math.max((double)i + 255.0 * interpolator.interpolate((double)i / 65535.0, greenCurve), 0.0), 65535.0));
            }
            interpolator.reset();
            for (i = 0; i < 65536; ++i) {
                table[2][i] = (short)(0xFFFF & (int)Math.min(Math.max((double)i + 255.0 * interpolator.interpolate((double)i / 65535.0, blueCurve), 0.0), 65535.0));
            }
            LookupTableJAI lookupTable = new LookupTableJAI(table, true);
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(image);
            pb.add(lookupTable);
            return JAI.create((String)"lookup", (ParameterBlock)pb, null);
        }
        return image;
    }

    public static PlanarImage whiteBalance(RenderedImage image, float source, float REF_T, float tint, float lightness, float mult, float[][] cameraRGB, ColorScience.CAMethod caMethod) {
        float[][] b = WhiteBalanceV2.whiteBalanceMatrix(source, REF_T, mult, cameraRGB, caMethod);
        double[][] t = new double[3][4];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                t[i][j] = b[i][j];
            }
        }
        RenderedOp cargb = JAI.create((String)"BandCombine", (RenderedImage)image, (Object)t, null);
        if (tint != 0.0f) {
            return WhiteBalanceV2.tintCast((PlanarImage)cargb, tint, lightness);
        }
        return cargb;
    }

    @Override
    protected void updateOp(Transform op) {
        op.update();
    }

    @Override
    protected BlendedOperation.BlendedTransform createBlendedOp(PlanarImage source) {
        return new WhiteBalanceTransform(source);
    }

    @Override
    public OperationType getType() {
        return this.type;
    }

    private class WhiteBalanceTransform
    extends BlendedOperation.BlendedTransform {
        WhiteBalanceTransform(PlanarImage source) {
            super(source);
        }

        @Override
        public PlanarImage setFront() {
            float[] n;
            int[] pixel;
            float lightness = 0.18f;
            if (WhiteBalanceV2.this.p != null && (pixel = this.pointToPixel(WhiteBalanceV2.this.p)) != null && (n = WhiteBalanceV2.neutralize(pixel, WhiteBalanceV2.this.caMethod, WhiteBalanceV2.this.source, WhiteBalanceV2.this.REF_T)) != null) {
                lightness = (float)pixel[1] / 255.0f;
                WhiteBalanceV2.this.source = n[0];
                WhiteBalanceV2.this.tint = Math.min(Math.max(n[1], -20.0f), 20.0f);
            }
            return WhiteBalanceV2.whiteBalance((RenderedImage)this.back, WhiteBalanceV2.this.source, WhiteBalanceV2.this.REF_T, WhiteBalanceV2.this.tint, lightness, WhiteBalanceV2.this.caMethod);
        }
    }
}

