/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.model;

import com.lightcrafts.model.RGBColorSelectionPreset;
import java.awt.Color;

public class RGBColorSelection {
    public final float red;
    public final float green;
    public final float blue;
    public final float radius;
    public final float luminosityLower;
    public final float luminosityUpper;
    public final float luminosityLowerFeather;
    public final float luminosityUpperFeather;
    public final boolean isInverted;
    public final boolean isColorEnabled;
    public final boolean isLuminosityEnabled;
    private static float lastRed = 0.5f;
    private static float lastGreen = 0.5f;
    private static float lastBlue = 0.5f;
    private static final float[] gm_blue = new float[]{0.0902f, 0.0471f, 0.2745f};
    private static final float[] gm_green = new float[]{0.1294f, 0.2667f, 0.0824f};
    private static final float[] gm_red = new float[]{0.2392f, 0.0706f, 0.0471f};
    private static final float[] gm_yellow = new float[]{0.5882f, 0.5882f, 0.0863f};
    private static final float[] gm_magenta = new float[]{0.3529f, 0.1412f, 0.298f};
    private static final float[] gm_cyan = new float[]{0.1373f, 0.2275f, 0.3765f};

    public RGBColorSelection() {
        this(0.5f, 0.5f, 0.5f, -1.0f, 0.0f, 0.0f, 1.0f, 0.0f, false, true, true);
    }

    public RGBColorSelection(float red, float green, float blue, float radius, float luminosityLower, float luminosityLowerFeather, float luminosityUpper, float luminosityUpperFeather, boolean isInverted, boolean isColorEnabled, boolean isLuminosityEnabled) {
        lastRed = this.red = red;
        lastGreen = this.green = green;
        lastBlue = this.blue = blue;
        this.radius = radius;
        this.luminosityLower = luminosityLower;
        this.luminosityUpper = luminosityUpper;
        this.luminosityLowerFeather = luminosityLowerFeather;
        this.luminosityUpperFeather = luminosityUpperFeather;
        this.isInverted = isInverted;
        this.isColorEnabled = isColorEnabled;
        this.isLuminosityEnabled = isLuminosityEnabled;
    }

    public RGBColorSelectionPreset getPreset() {
        if (this.radius == -1.0f) {
            return RGBColorSelectionPreset.AllColors;
        }
        float eps = 0.001f;
        if (Math.abs(this.red - gm_red[0]) < 0.001f && Math.abs(this.green - gm_red[1]) < 0.001f && Math.abs(this.blue - gm_red[2]) < 0.001f) {
            return RGBColorSelectionPreset.Reds;
        }
        if (Math.abs(this.red - gm_yellow[0]) < 0.001f && Math.abs(this.green - gm_yellow[1]) < 0.001f && Math.abs(this.blue - gm_yellow[2]) < 0.001f) {
            return RGBColorSelectionPreset.Yellows;
        }
        if (Math.abs(this.red - gm_green[0]) < 0.001f && Math.abs(this.green - gm_green[1]) < 0.001f && Math.abs(this.blue - gm_green[2]) < 0.001f) {
            return RGBColorSelectionPreset.Greens;
        }
        if (Math.abs(this.red - gm_cyan[0]) < 0.001f && Math.abs(this.green - gm_cyan[1]) < 0.001f && this.blue - gm_cyan[2] < 0.001f) {
            return RGBColorSelectionPreset.Cyans;
        }
        if (Math.abs(this.red - gm_blue[0]) < 0.001f && Math.abs(this.green - gm_blue[1]) < 0.001f && Math.abs(this.blue - gm_blue[2]) < 0.001f) {
            return RGBColorSelectionPreset.Blues;
        }
        if (Math.abs(this.red - gm_magenta[0]) < 0.001f && Math.abs(this.green - gm_magenta[1]) < 0.001f && Math.abs(this.blue - gm_magenta[2]) < 0.001f) {
            return RGBColorSelectionPreset.Magentas;
        }
        return RGBColorSelectionPreset.SampledColors;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.red) ^ Float.floatToIntBits(this.green) ^ Float.floatToIntBits(this.blue) ^ Float.floatToIntBits(this.radius) ^ Float.floatToIntBits(this.luminosityLower) ^ Float.floatToIntBits(this.luminosityLowerFeather) ^ Float.floatToIntBits(this.luminosityUpper) ^ Float.floatToIntBits(this.luminosityUpperFeather) ^ (this.isColorEnabled ? 2 : 0) ^ (this.isLuminosityEnabled ? 1 : 0) ^ (this.isInverted ? 1 : 0);
    }

    public RGBColorSelection(RGBColorSelectionPreset p, boolean isInverted) {
        switch (p) {
            case AllColors: {
                this.red = 0.5f;
                this.green = 0.5f;
                this.blue = 0.5f;
                this.radius = -1.0f;
                break;
            }
            case SampledColors: {
                this.red = lastRed;
                this.green = lastGreen;
                this.blue = lastBlue;
                this.radius = 0.4f;
                break;
            }
            case Reds: {
                this.red = gm_red[0];
                this.green = gm_red[1];
                this.blue = gm_red[2];
                this.radius = 0.4f;
                break;
            }
            case Yellows: {
                this.red = gm_yellow[0];
                this.green = gm_yellow[1];
                this.blue = gm_yellow[2];
                this.radius = 0.4f;
                break;
            }
            case Greens: {
                this.red = gm_green[0];
                this.green = gm_green[1];
                this.blue = gm_green[2];
                this.radius = 0.4f;
                break;
            }
            case Cyans: {
                this.red = gm_cyan[0];
                this.green = gm_cyan[1];
                this.blue = gm_cyan[2];
                this.radius = 0.4f;
                break;
            }
            case Blues: {
                this.red = gm_blue[0];
                this.green = gm_blue[1];
                this.blue = gm_blue[2];
                this.radius = 0.4f;
                break;
            }
            case Magentas: {
                this.red = gm_magenta[0];
                this.green = gm_magenta[1];
                this.blue = gm_magenta[2];
                this.radius = 0.4f;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Color Selection Preset: " + p.name());
            }
        }
        this.luminosityLower = 0.0f;
        this.luminosityUpper = 1.0f;
        this.luminosityLowerFeather = 0.0f;
        this.luminosityUpperFeather = 0.0f;
        this.isInverted = isInverted;
        this.isColorEnabled = true;
        this.isLuminosityEnabled = true;
    }

    public boolean isAllSelected() {
        return (!this.isColorEnabled || this.radius < 0.0f) && (this.luminosityLowerFeather == 0.0f && this.luminosityUpperFeather == 0.0f && this.luminosityUpper - this.luminosityLower == 1.0f || !this.isLuminosityEnabled);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RGBColorSelection that = (RGBColorSelection)o;
        if (Float.compare(that.blue, this.blue) != 0) {
            return false;
        }
        if (Float.compare(that.green, this.green) != 0) {
            return false;
        }
        if (this.isColorEnabled != that.isColorEnabled) {
            return false;
        }
        if (this.isLuminosityEnabled != that.isLuminosityEnabled) {
            return false;
        }
        if (this.isInverted != that.isInverted) {
            return false;
        }
        if (Float.compare(that.luminosityLower, this.luminosityLower) != 0) {
            return false;
        }
        if (Float.compare(that.luminosityLowerFeather, this.luminosityLowerFeather) != 0) {
            return false;
        }
        if (Float.compare(that.luminosityUpper, this.luminosityUpper) != 0) {
            return false;
        }
        if (Float.compare(that.luminosityUpperFeather, this.luminosityUpperFeather) != 0) {
            return false;
        }
        if (Float.compare(that.radius, this.radius) != 0) {
            return false;
        }
        return Float.compare(that.red, this.red) == 0;
    }

    public Color toColor() {
        return new Color(this.red, this.green, this.blue);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("brightness ([");
        buffer.append(this.luminosityLower);
        buffer.append(" +/- ");
        buffer.append(this.luminosityLowerFeather);
        buffer.append("] -> [");
        buffer.append(this.luminosityUpper);
        buffer.append(" +/- ");
        buffer.append(this.luminosityUpperFeather);
        buffer.append("]); rgb ([");
        buffer.append(this.red);
        buffer.append(", ");
        buffer.append(this.green);
        buffer.append(", ");
        buffer.append(this.blue);
        buffer.append(" : ");
        buffer.append(this.radius);
        buffer.append("])");
        buffer.append(" hue=");
        buffer.append(this.isColorEnabled);
        buffer.append(" brightness=");
        buffer.append(this.isLuminosityEnabled);
        buffer.append(" inverted=");
        buffer.append(this.isInverted);
        return buffer.toString();
    }
}

