/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.model;

import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XmlNode;
import java.text.NumberFormat;

public class Scale
implements Comparable {
    private static final String NumeratorTag = "Numerator";
    private static final String DenominatorTag = "Denominator";
    private static final String FactorTag = "Factor";
    private int numerator;
    private int denominator;
    private float scale;

    public Scale(int numerator, int denominator) {
        this.numerator = numerator;
        this.denominator = denominator;
    }

    public Scale(XmlNode node) throws XMLException {
        String[] attrs = node.getAttributes();
        String key = attrs[0];
        String value = null;
        try {
            if (key.equals(FactorTag)) {
                value = node.getAttribute(key);
                this.scale = Float.parseFloat(value);
                return;
            }
            if (key.equals(NumeratorTag) || key.equals(DenominatorTag)) {
                value = node.getAttribute(NumeratorTag);
                this.numerator = Integer.parseInt(value);
                value = node.getAttribute(DenominatorTag);
                this.denominator = Integer.parseInt(value);
                return;
            }
            throw new XMLException("Unexpected attribute: " + key);
        }
        catch (NumberFormatException e) {
            throw new XMLException("Not a number :\"" + value + "\"", e);
        }
    }

    public Scale(float scale) {
        this.scale = scale;
    }

    public float getFactor() {
        if (this.scale != 0.0f) {
            return this.scale;
        }
        return (float)this.numerator / (float)this.denominator;
    }

    public String toRationalString() {
        return "" + this.numerator + ":" + this.denominator;
    }

    public String toPercentString() {
        NumberFormat format = NumberFormat.getPercentInstance();
        float s = this.getFactor();
        return format.format(s);
    }

    public String toString() {
        if (this.scale != 0.0f) {
            return this.toPercentString();
        }
        return this.toRationalString();
    }

    public int compareTo(Object o) throws ClassCastException {
        float b;
        Scale s = (Scale)o;
        float a = this.getFactor();
        if (a == (b = s.getFactor())) {
            return 0;
        }
        return a > b ? 1 : -1;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Scale)) {
            return false;
        }
        Scale s = (Scale)o;
        return this.getFactor() == s.getFactor();
    }

    public void save(XmlNode node) {
        if (this.scale != 0.0f) {
            node.setAttribute(FactorTag, Float.toString(this.getFactor()));
        } else {
            node.setAttribute(NumeratorTag, Integer.toString(this.numerator));
            node.setAttribute(DenominatorTag, Integer.toString(this.denominator));
        }
    }
}

