/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.prefs;

import com.lightcrafts.platform.AlertDialog;
import com.lightcrafts.platform.Platform;
import com.lightcrafts.prefs.Locale;
import com.lightcrafts.prefs.PreferencesItem;
import com.lightcrafts.utils.filecache.FileCache;
import com.lightcrafts.utils.filecache.FileCacheFactory;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

class BrowserCacheItem
extends PreferencesItem {
    private static final String Package = "/com/lightcrafts/utils/filecache";
    private static final String Key = "CacheScope";
    private static Preferences Prefs = Preferences.userRoot().node("/com/lightcrafts/utils/filecache");
    private JRadioButton localButton = new JRadioButton(Locale.LOCALE.get("BrowserCacheItemLocalOption"));
    private JRadioButton globalButton = new JRadioButton(Locale.LOCALE.get("BrowserCacheItemGlobalOption"));
    private ButtonGroup group;
    private JButton clearButton;

    BrowserCacheItem(JTextArea help) {
        super(help);
        this.localButton.setFocusable(false);
        this.globalButton.setFocusable(false);
        this.group = new ButtonGroup();
        this.group.add(this.localButton);
        this.group.add(this.globalButton);
        this.clearButton = new ClearButton();
        this.addHelpListeners();
    }

    @Override
    public String getLabel() {
        return Locale.LOCALE.get("BrowserCacheItemLabel");
    }

    @Override
    public String getHelp(MouseEvent e) {
        return Locale.LOCALE.get("BrowserCacheItemHelp");
    }

    @Override
    public boolean requiresRestart() {
        return false;
    }

    @Override
    public JComponent getComponent() {
        Box box = Box.createHorizontalBox();
        box.add(this.localButton);
        box.add(this.globalButton);
        box.add(Box.createHorizontalGlue());
        box.add(this.clearButton);
        box.add(Box.createHorizontalGlue());
        return box;
    }

    @Override
    public void commit() {
        Prefs.putBoolean(Key, this.localButton.isSelected());
    }

    @Override
    public void restore() {
        boolean local = Prefs.getBoolean(Key, false);
        this.localButton.setSelected(local);
        this.globalButton.setSelected(!local);
    }

    class ClearButton
    extends JButton
    implements ActionListener {
        ClearButton() {
            super(Locale.LOCALE.get("BrowserCacheItemClearButton"));
            this.setToolTipText(Locale.LOCALE.get("BrowserCacheItemClearToolTip"));
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Frame parent = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this);
            AlertDialog alert = Platform.getPlatform().getAlertDialog();
            int option = alert.showAlert(parent, Locale.LOCALE.get("BrowserCacheItemClearWarningMajor"), Locale.LOCALE.get("BrowserCacheItemClearWarningMinor"), 1, Locale.LOCALE.get("BrowserCacheItemClearOption"), Locale.LOCALE.get("BrowserCacheItemCancelOption"));
            if (option != 0) {
                return;
            }
            try {
                FileCache cache = FileCacheFactory.getGlobalCache();
                if (cache == null) {
                    throw new IOException("Global cache does not exist");
                }
                cache.clear();
            }
            catch (IOException e) {
                alert.showAlert(parent, Locale.LOCALE.get("BrowserCacheItemError"), e.getMessage(), 2, Locale.LOCALE.get("BrowserCacheItemErrorButton"));
                System.out.println("Error clearing the global browser cache:");
                e.printStackTrace();
            }
        }
    }
}

