/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.prefs;

import com.lightcrafts.prefs.HelpArea;
import com.lightcrafts.prefs.Locale;
import com.lightcrafts.ui.metadata2.CopyrightDefaults;
import com.lightcrafts.ui.toolkit.TextAreaFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

class CopyrightPrefsPanel
extends JPanel {
    private static final int TextFieldWidth = 250;
    private static final Dimension TextAreaSize = new Dimension(250, 150);
    private JTextArea copyrightText;
    private JTextField creatorText;
    private JButton revert;
    private HelpArea help;
    private boolean isPlaceholderCopyrightTextShown;
    private boolean isPlaceholderCreatorTextShown;

    CopyrightPrefsPanel() {
        this.initCreatorText();
        this.initCopyrightText();
        String helpText = Locale.LOCALE.get("CopyrightHelp");
        this.help = new HelpArea();
        this.help.setText(helpText);
        Dimension helpSize = this.help.getPreferredSize();
        helpSize = new Dimension(helpSize.width, 70);
        this.help.setPreferredSize(helpSize);
        this.help.setMaximumSize(helpSize);
        this.revert = new JButton(Locale.LOCALE.get("CopyrightRevertButtonText"));
        this.revert.setHorizontalAlignment(0);
        this.revert.setAlignmentX(0.5f);
        this.revert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                CopyrightPrefsPanel.this.revertCreatorText();
                CopyrightPrefsPanel.this.revertCopyrightText();
            }
        });
        JPanel fields = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(8, 4, 8, 4);
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 13;
        fields.add((Component)new JLabel(Locale.LOCALE.get("CreatorLabel") + ':'), c);
        c.gridx = 1;
        c.gridy = 0;
        c.anchor = 17;
        fields.add((Component)this.creatorText, c);
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = 13;
        fields.add((Component)new JLabel(Locale.LOCALE.get("CopyrightLabel") + ':'), c);
        c.gridx = 1;
        c.gridy = 1;
        c.anchor = 17;
        JScrollPane scrollpane = new JScrollPane(this.copyrightText);
        scrollpane.setPreferredSize(TextAreaSize);
        fields.add((Component)scrollpane, c);
        this.setLayout(new BoxLayout(this, 1));
        this.add(Box.createVerticalGlue());
        this.add(Box.createVerticalStrut(8));
        this.add(fields);
        this.add(Box.createVerticalStrut(8));
        this.add(this.revert);
        this.add(Box.createVerticalStrut(8));
        this.add(Box.createVerticalGlue());
        this.add(this.help);
    }

    private void initCopyrightText() {
        String text = CopyrightDefaults.getDefaultCopyright();
        if (text != null && !text.equals("")) {
            this.copyrightText = TextAreaFactory.createTextArea(text, 30);
        } else {
            text = Locale.LOCALE.get("CopyrightPlaceholderText");
            this.copyrightText = TextAreaFactory.createTextArea(text, 30);
            this.copyrightText.setFont(this.copyrightText.getFont().deriveFont(2));
            this.copyrightText.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent event) {
                    if (CopyrightPrefsPanel.this.isPlaceholderCopyrightTextShown) {
                        CopyrightPrefsPanel.this.copyrightText.setText("");
                        CopyrightPrefsPanel.this.copyrightText.setFont(CopyrightPrefsPanel.this.copyrightText.getFont().deriveFont(0));
                    }
                    CopyrightPrefsPanel.this.isPlaceholderCopyrightTextShown = false;
                }
            });
            this.isPlaceholderCopyrightTextShown = true;
        }
        this.copyrightText.setEditable(true);
    }

    private void initCreatorText() {
        String text = CopyrightDefaults.getDefaultCreator();
        if (text != null && !text.equals("")) {
            this.creatorText = new JTextField(text);
        } else {
            text = Locale.LOCALE.get("CreatorPlaceholderText");
            this.creatorText = new JTextField(text);
            this.creatorText.setFont(this.creatorText.getFont().deriveFont(2));
            this.creatorText.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent event) {
                    if (CopyrightPrefsPanel.this.isPlaceholderCreatorTextShown) {
                        CopyrightPrefsPanel.this.creatorText.setText("");
                        CopyrightPrefsPanel.this.creatorText.setFont(CopyrightPrefsPanel.this.creatorText.getFont().deriveFont(0));
                    }
                    CopyrightPrefsPanel.this.isPlaceholderCreatorTextShown = false;
                }
            });
            this.isPlaceholderCreatorTextShown = true;
        }
        this.creatorText.setEditable(true);
        Dimension size = this.creatorText.getPreferredSize();
        this.creatorText.setPreferredSize(new Dimension(250, size.height));
    }

    private void revertCopyrightText() {
        String copyText = CopyrightDefaults.getDefaultCopyright();
        if (copyText != null && !copyText.equals("")) {
            this.copyrightText.setText(copyText);
        } else if (!this.isPlaceholderCopyrightTextShown) {
            copyText = Locale.LOCALE.get("CopyrightPlaceholderText");
            this.copyrightText.setText(copyText);
            this.copyrightText.setFont(this.copyrightText.getFont().deriveFont(2));
            this.isPlaceholderCopyrightTextShown = true;
        }
    }

    private void revertCreatorText() {
        String createText = CopyrightDefaults.getDefaultCreator();
        if (createText != null && !createText.equals("")) {
            this.creatorText.setText(createText);
        } else if (!this.isPlaceholderCreatorTextShown) {
            createText = Locale.LOCALE.get("CreatorPlaceholderText");
            this.creatorText.setText(createText);
            this.creatorText.setFont(this.creatorText.getFont().deriveFont(2));
            this.isPlaceholderCreatorTextShown = true;
        }
        Dimension size = this.creatorText.getPreferredSize();
        this.creatorText.setPreferredSize(new Dimension(250, size.height));
    }

    void commit() {
        String s = this.copyrightText.getText();
        if (s.equals("") || this.isPlaceholderCopyrightTextShown) {
            CopyrightDefaults.setDefaultCopyright(null);
        } else {
            CopyrightDefaults.setDefaultCopyright(s);
        }
        s = this.creatorText.getText();
        if (s.equals("") || this.isPlaceholderCreatorTextShown) {
            CopyrightDefaults.setDefaultCreator(null);
        } else {
            CopyrightDefaults.setDefaultCreator(s);
        }
    }
}

