/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.prefs;

import com.lightcrafts.image.export.ImageExportOptions;
import com.lightcrafts.image.types.ImageType;
import com.lightcrafts.image.types.JPEGImageType;
import com.lightcrafts.image.types.TIFFImageType;
import com.lightcrafts.prefs.HelpArea;
import com.lightcrafts.prefs.Locale;
import com.lightcrafts.ui.export.ExportControls;
import com.lightcrafts.ui.export.ExportLogic;
import com.lightcrafts.ui.export.SaveOptions;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

class SavePrefsPanel
extends JPanel
implements ItemListener {
    private JComboBox typeCombo;
    private Box typeBox;
    private ExportControls ctrls;
    private JLabel ctrlsTitle;
    private Box ctrlsTitleBox;
    private ExportComboItem otherComboItem;
    private HelpArea help;

    SavePrefsPanel() {
        SaveOptions options = SaveOptions.getDefaultSaveOptions();
        ImageExportOptions export = SaveOptions.getExportOptions(options);
        List<ExportComboItem> filters = SavePrefsPanel.getExportAllComboItems();
        ImageType defaultType = SaveOptions.getExportOptions(options).getImageType();
        this.typeCombo = new JComboBox();
        ExportComboItem defaultItem = null;
        for (ExportComboItem filter : filters) {
            ImageExportOptions filterOptions = filter.getExportOptions();
            ImageType filterType = filterOptions.getImageType();
            if (defaultType.equals(filterType)) {
                defaultItem = filter = new ExportComboItem(export);
            }
            this.typeCombo.addItem(filter);
        }
        if (defaultItem != null) {
            this.typeCombo.setSelectedItem(defaultItem);
        }
        this.typeCombo.setMaximumSize(this.typeCombo.getPreferredSize());
        this.typeCombo.addItemListener(this);
        this.setLayout(new BoxLayout(this, 1));
        JLabel typeLabel = new JLabel(Locale.LOCALE.get("SaveTypeLabel"));
        this.typeBox = Box.createHorizontalBox();
        this.typeBox.add(typeLabel);
        this.typeBox.add(this.typeCombo);
        this.ctrls = new ExportControls(export, false);
        this.ctrls.setBorder(BorderFactory.createTitledBorder(""));
        this.ctrlsTitle = new JLabel(defaultItem.toString() + " Options");
        this.ctrlsTitleBox = Box.createHorizontalBox();
        this.ctrlsTitleBox.add(this.ctrlsTitle);
        this.ctrlsTitleBox.add(Box.createHorizontalGlue());
        String helpText = Locale.LOCALE.get("SaveHelp");
        this.help = new HelpArea();
        this.help.setText(helpText);
        Dimension helpSize = this.help.getPreferredSize();
        helpSize = new Dimension(helpSize.width, 70);
        this.help.setPreferredSize(helpSize);
        this.help.setMaximumSize(helpSize);
        this.add(Box.createVerticalGlue());
        this.add(Box.createVerticalStrut(8));
        this.add(this.typeBox);
        this.add(Box.createVerticalStrut(8));
        this.add(this.ctrlsTitleBox);
        this.add(Box.createVerticalStrut(8));
        this.add(this.ctrls);
        this.add(Box.createVerticalStrut(8));
        this.add(Box.createVerticalGlue());
        this.add(this.help);
    }

    void commit() {
        ExportComboItem item = (ExportComboItem)this.typeCombo.getSelectedItem();
        ImageExportOptions export = item.exportOptions;
        SaveOptions options = export.getImageType() == TIFFImageType.INSTANCE ? SaveOptions.createSidecarTiff(export) : SaveOptions.createSidecarJpeg(export);
        SaveOptions.setDefaultSaveOptions(options);
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            ExportComboItem exportComboItem = (ExportComboItem)this.typeCombo.getSelectedItem();
            ImageExportOptions newOptions = exportComboItem.getExportOptions();
            if (this.otherComboItem != null) {
                ImageExportOptions oldOptions = this.otherComboItem.getExportOptions();
                ExportLogic.mergeExportOptions(oldOptions, newOptions);
            }
            this.removeAll();
            this.ctrls = new ExportControls(newOptions, false);
            this.ctrls.setBorder(BorderFactory.createTitledBorder(""));
            this.ctrlsTitle.setText(exportComboItem.toString() + " Options");
            this.add(Box.createVerticalGlue());
            this.add(Box.createVerticalStrut(8));
            this.add(this.typeBox);
            this.add(Box.createVerticalStrut(8));
            this.add(this.ctrlsTitleBox);
            this.add(Box.createVerticalStrut(8));
            this.add(this.ctrls);
            this.add(Box.createVerticalStrut(8));
            this.add(Box.createVerticalGlue());
            this.add(this.help);
            this.repaint();
            this.otherComboItem = exportComboItem;
        }
    }

    private static List<ExportComboItem> getExportAllComboItems() {
        ArrayList<ExportComboItem> filters = new ArrayList<ExportComboItem>();
        ExportComboItem filter = new ExportComboItem(TIFFImageType.INSTANCE.newExportOptions());
        filters.add(filter);
        filter = new ExportComboItem(JPEGImageType.INSTANCE.newExportOptions());
        filters.add(filter);
        return filters;
    }

    static class ExportComboItem {
        private ImageExportOptions exportOptions;

        private ExportComboItem(ImageExportOptions exportOptions) {
            this.exportOptions = exportOptions;
        }

        public String toString() {
            return this.exportOptions.getImageType().getName();
        }

        private ImageExportOptions getExportOptions() {
            return this.exportOptions;
        }
    }
}

