/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.prefs;

import com.lightcrafts.platform.FileChooser;
import com.lightcrafts.platform.Platform;
import com.lightcrafts.prefs.Locale;
import com.lightcrafts.prefs.PreferencesItem;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

class ScratchFileItem
extends PreferencesItem {
    private static final String Package = "/com/lightcrafts/jai/utils";
    private static final String Key = "ScratchDirectory";
    private static Preferences Prefs = Preferences.userRoot().node("/com/lightcrafts/jai/utils");
    private JTextField text = new JTextField();
    private JButton chooserButton;

    ScratchFileItem(JTextArea help) {
        super(help);
        this.text.setEditable(false);
        this.chooserButton = new JButton(Locale.LOCALE.get("ScratchFileItemButton"));
        this.chooserButton.setToolTipText(Locale.LOCALE.get("ScratchFileItemToolTip"));
        this.chooserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                FileChooser chooser = Platform.getPlatform().getFileChooser();
                String path = ScratchFileItem.this.text.getText();
                File dir = new File(path);
                Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, ScratchFileItem.this.chooserButton);
                dir = chooser.chooseDirectory(Locale.LOCALE.get("ScratchFileDialogTitle"), dir, window, true);
                if (dir != null) {
                    if (!dir.isDirectory()) {
                        dir = dir.getParentFile();
                    }
                    if (dir != null) {
                        path = dir.getAbsolutePath();
                        ScratchFileItem.this.text.setText(path);
                    }
                }
            }
        });
        this.addHelpListeners();
    }

    @Override
    public String getLabel() {
        return Locale.LOCALE.get("ScratchFileItemLabel");
    }

    @Override
    public String getHelp(MouseEvent e) {
        return Locale.LOCALE.get("ScratchFileItemHelp");
    }

    @Override
    public boolean requiresRestart() {
        return true;
    }

    @Override
    public JComponent getComponent() {
        Box box = Box.createHorizontalBox();
        box.add(this.text);
        box.add(Box.createHorizontalStrut(6));
        box.add(this.chooserButton);
        return box;
    }

    @Override
    public void commit() {
        String path = this.text.getText();
        Prefs.put(Key, path);
    }

    @Override
    public void restore() {
        String path = Prefs.get(Key, null);
        if (path == null) {
            path = ScratchFileItem.getDefaultTempPath();
        }
        if (path != null) {
            this.text.setText(path);
        } else {
            this.text.setEnabled(false);
        }
    }

    private static String getDefaultTempPath() {
        try {
            File tempFile = File.createTempFile("lzScratchProbe", "");
            File tempDir = tempFile.getParentFile();
            tempFile.delete();
            if (tempDir != null) {
                return tempDir.getAbsolutePath();
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }
}

