/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.splash;

import com.lightcrafts.splash.SplashWindow;
import com.lightcrafts.splash.StartupProgress;
import com.lightcrafts.utils.Version;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;

public final class SplashImage
extends BufferedImage {
    private static BufferedImage m_splashImage = null;
    private String[] m_staticText;
    private static final Color m_textColor = new Color(204, 204, 204);
    private static final Font m_textFont = new Font("SansSerif", 0, 12);
    private static final Point m_textLoc = new Point(57, 107);

    public SplashImage(String text) {
        this(new String[]{text});
    }

    public SplashImage(String[] texts) {
        super(SplashImage.backgroundImage().getWidth(), SplashImage.backgroundImage().getHeight(), 2);
        this.m_staticText = texts;
        this.update("");
    }

    public StartupProgress getStartupProgress() {
        return new StartupProgress(){

            @Override
            public void startupMessage(String text) {
                super.startupMessage(text);
                SplashImage.this.update(text);
                SplashWindow.repaintInstance();
            }
        };
    }

    public static String[] getDefaultSplashText(String licenseText) {
        String name = Version.getVersionName();
        String revision = Version.getRevisionNumber();
        String versionText = "Version " + name + " (" + revision + ')';
        if (licenseText != null) {
            return new String[]{versionText, licenseText};
        }
        return new String[]{versionText};
    }

    static synchronized BufferedImage backgroundImage() {
        if (m_splashImage == null) {
            URL url = SplashImage.class.getResource("resources/Splash.png");
            try {
                m_splashImage = ImageIO.read(url);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return m_splashImage;
    }

    private void update(String dynamicText) {
        Graphics2D g = (Graphics2D)this.getGraphics();
        g.drawImage(SplashImage.backgroundImage(), new AffineTransform(), null);
        g.setColor(m_textColor);
        g.setFont(m_textFont);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int y = SplashImage.m_textLoc.y;
        FontMetrics metrics = g.getFontMetrics(m_textFont);
        int dy = 0 - metrics.getHeight() - 5;
        for (int i = 0; i < this.m_staticText.length; ++i) {
            g.drawString(this.m_staticText[i], SplashImage.m_textLoc.x, y);
            y += dy;
        }
        g.drawString(dynamicText, SplashImage.m_textLoc.x, y);
    }
}

