/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.splash;

import com.lightcrafts.app.ComboFrame;
import java.awt.DisplayMode;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;

public final class SplashWindow
extends Frame {
    private static SplashWindow INSTANCE;
    private Image m_image;
    private boolean m_paintCalled;

    public static void disposeSplash() {
        if (INSTANCE != null) {
            INSTANCE.dispose();
            INSTANCE = null;
        }
    }

    public static void invokeMain(String className, String[] args) {
        try {
            Class.forName(className).getMethod("main", String[].class).invoke(null, new Object[]{args});
        }
        catch (Exception e) {
            InternalError error = new InternalError("Failed to invoke main method");
            error.initCause(e);
            throw error;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        g.drawImage(this.m_image, 0, 0, this);
        if (!this.m_paintCalled) {
            this.m_paintCalled = true;
            SplashWindow splashWindow = this;
            synchronized (splashWindow) {
                this.notifyAll();
            }
        }
    }

    public static void repaintInstance() {
        if (INSTANCE != null) {
            INSTANCE.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void splash(Image image) {
        if (INSTANCE == null && image != null) {
            INSTANCE = new SplashWindow(image);
            INSTANCE.setVisible(true);
            if (!EventQueue.isDispatchThread() && Runtime.getRuntime().availableProcessors() == 1) {
                SplashWindow splashWindow = INSTANCE;
                synchronized (splashWindow) {
                    while (!SplashWindow.INSTANCE.m_paintCalled) {
                        try {
                            INSTANCE.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
    }

    public static void splash(URL imageURL) {
        if (imageURL != null) {
            SplashWindow.splash(Toolkit.getDefaultToolkit().createImage(imageURL));
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    private SplashWindow(Image image) {
        this.m_image = image;
        this.setIconImage(ComboFrame.IconImage);
        this.setUndecorated(true);
        MediaTracker mt = new MediaTracker(this);
        mt.addImage(image, 0);
        try {
            mt.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int imgWidth = image.getWidth(this);
        int imgHeight = image.getHeight(this);
        this.setSize(imgWidth, imgHeight);
        DisplayMode dm = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDisplayMode();
        this.setLocation((dm.getWidth() - imgWidth) / 2, (dm.getHeight() - imgHeight) / 2);
        MouseAdapter disposeOnClick = new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseClicked(MouseEvent evt) {
                SplashWindow splashWindow = SplashWindow.this;
                synchronized (splashWindow) {
                    SplashWindow.this.m_paintCalled = true;
                    SplashWindow.this.notifyAll();
                }
                SplashWindow.disposeSplash();
            }
        };
        this.addMouseListener(disposeOnClick);
    }
}

