/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.action;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;

public abstract class ToggleAction
extends AbstractAction {
    public static final String TOGGLE_STATE = "ToggleState";
    public static final String PRESSED_ICON = "PressedIcon";
    private String onName;
    private Icon onIcon;
    private String onDescription;
    private String offName;
    private Icon offIcon;
    private String offDescription;
    private boolean state;

    public ToggleAction() {
        this.putValue(TOGGLE_STATE, Boolean.FALSE);
    }

    public ToggleAction(String onName, String offName) {
        super(offName);
        this.onName = onName;
        this.offName = offName;
        this.putValue(TOGGLE_STATE, Boolean.FALSE);
    }

    public ToggleAction(String onName, Icon onIcon, String offName, Icon offIcon) {
        super(offName, offIcon);
        this.onName = onName;
        this.onIcon = onIcon;
        this.offName = offName;
        this.offIcon = offIcon;
        this.putValue(TOGGLE_STATE, Boolean.FALSE);
    }

    protected abstract void onActionPerformed(ActionEvent var1);

    protected abstract void offActionPerformed(ActionEvent var1);

    public void setState(boolean state) {
        if (this.state != state) {
            this.actionPerformed(null);
        }
    }

    public boolean getState() {
        return this.state;
    }

    public void setName(String name, boolean state) {
        if (state) {
            this.onName = name;
        } else {
            this.offName = name;
        }
        this.actionPerformed(null);
    }

    public String getName(boolean state) {
        return state ? this.onName : this.offName;
    }

    public void setIcon(Icon icon, boolean state) {
        if (state) {
            this.onIcon = icon;
        } else {
            this.offIcon = icon;
        }
        this.actionPerformed(null);
    }

    public void setPressedIcon(Icon icon) {
        this.putValue(PRESSED_ICON, icon);
    }

    public void setDescription(String description, boolean state) {
        if (state) {
            this.onDescription = description;
        } else {
            this.offDescription = description;
        }
        this.actionPerformed(null);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.state = !this.state;
        String name = this.state ? this.onName : this.offName;
        this.putValue("Name", name);
        Icon icon = this.state ? this.onIcon : this.offIcon;
        this.putValue("SmallIcon", icon);
        String description = this.state ? this.onDescription : this.offDescription;
        this.putValue("ShortDescription", description);
        if (event != null) {
            if (this.state) {
                this.onActionPerformed(event);
            } else {
                this.offActionPerformed(event);
            }
        }
        this.putValue(TOGGLE_STATE, this.state);
    }
}

