/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.advice;

import com.lightcrafts.ui.advice.AbstractAdvice;
import com.lightcrafts.ui.advice.Advice;
import com.lightcrafts.ui.advice.AdviceContent;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.event.MouseInputAdapter;

public class AdvisorDialog
extends JDialog {
    private static AdvisorDialog Recent;
    private static Cursor OpenHand;
    private static Cursor ClosedHand;
    private static Preferences Prefs;
    private static final String AdviceHashKey = "AdviceHash";
    private Advice advice;

    public AdvisorDialog(Advice advice) {
        super(advice.getOwner());
        this.advice = advice;
        final AdviceContent content = new AdviceContent(advice);
        this.setContentPane(content);
        MouseInputAdapter listener = new MouseInputAdapter(){
            Point start;

            @Override
            public void mousePressed(MouseEvent event) {
                this.start = event.getPoint();
                content.setCursorRecurse(ClosedHand);
            }

            @Override
            public void mouseDragged(MouseEvent event) {
                Point loc = AdvisorDialog.this.getLocation();
                loc.x += event.getPoint().x - this.start.x;
                loc.y += event.getPoint().y - this.start.y;
                AdvisorDialog.this.setLocation(loc);
            }

            @Override
            public void mouseReleased(MouseEvent event) {
                this.start = null;
                content.setCursorRecurse(OpenHand);
            }

            @Override
            public void mouseEntered(MouseEvent event) {
            }

            @Override
            public void mouseExited(MouseEvent event) {
            }
        };
        content.setCursorRecurse(OpenHand);
        content.addMouseInputListenerRecurse(listener);
        this.setModal(false);
        this.setFocusable(false);
        this.setUndecorated(true);
        this.getRootPane().setWindowDecorationStyle(0);
        this.pack();
    }

    public Advice getAdvice() {
        return this.advice;
    }

    public void advise() {
        int hash = this.advice.getMessage().hashCode();
        int count = Prefs.getInt(AdviceHashKey + hash, 0);
        int max = this.advice.getMaxCount();
        if (max < 0 || count < max) {
            if (Recent != null) {
                Recent.setVisible(false);
            }
            Recent = this;
            Prefs.putInt(AdviceHashKey + hash, ++count);
            Point loc = this.advice.getLocation();
            if (loc != null) {
                this.setLocation(loc);
            } else {
                this.setLocationRelativeTo(this.getOwner());
            }
            this.setVisible(true);
        }
    }

    public static void advise(Advice advice) {
        AdvisorDialog dialog = new AdvisorDialog(advice);
        dialog.advise();
    }

    public static boolean clearNagCounts() {
        try {
            Prefs.removeNode();
        }
        catch (BackingStoreException e) {
            return false;
        }
        Prefs = Preferences.userRoot().node("/com/lightcrafts/ui/advice");
        return true;
    }

    public static void main(String[] args) {
        JFrame owner = new JFrame("owner");
        owner.getContentPane().setPreferredSize(new Dimension(640, 480));
        owner.pack();
        owner.setLocationRelativeTo(null);
        owner.setDefaultCloseOperation(3);
        owner.setVisible(true);
        AbstractAdvice advice = new AbstractAdvice(owner){

            @Override
            public String getMessage() {
                return "The adapter which receives mouse events and mouse motion events.  The methods in this class are empty; this class is provided as a convenience for easily creating listeners by extending this class and overriding only the methods of interest.";
            }

            @Override
            public int getMaxCount() {
                return -1;
            }
        };
        AdvisorDialog.clearNagCounts();
        AdvisorDialog.advise(advice);
    }

    static {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Point hot = new Point(8, 8);
        String path = "resources/OpenHand.png";
        URL url = AdvisorDialog.class.getResource(path);
        Image image = toolkit.createImage(url);
        OpenHand = toolkit.createCustomCursor(image, hot, "Drag");
        path = "resources/ClosedHand.png";
        url = AdvisorDialog.class.getResource(path);
        image = toolkit.createImage(url);
        ClosedHand = toolkit.createCustomCursor(image, hot, "Dragging");
        Prefs = Preferences.userRoot().node("/com/lightcrafts/ui/advice");
    }
}

