/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.ctrls;

import com.lightcrafts.ui.browser.ctrls.Locale;
import com.lightcrafts.ui.browser.model.ImageDatumComparator;
import com.lightcrafts.ui.browser.view.AbstractImageBrowser;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.prefs.Preferences;
import javax.swing.JComboBox;

class SortCombo
extends JComboBox
implements ItemListener {
    private static final Preferences Prefs = Preferences.userRoot().node("/com/lightcrafts/ui/browser/ctrls");
    private static final String ComparatorKey = "SortComparator";
    private AbstractImageBrowser images;

    SortCombo(AbstractImageBrowser images) {
        ImageDatumComparator[] comparators;
        this.images = images;
        for (ImageDatumComparator comparator : comparators = ImageDatumComparator.getAll()) {
            this.addItem(comparator);
        }
        this.addItemListener(this);
        this.setToolTipText(Locale.LOCALE.get("SortToolTip"));
        this.setFocusable(false);
        this.setFont(new Font("SansSerif", 0, 12));
        this.setFixedSize();
        String compName = Prefs.get(ComparatorKey, null);
        for (ImageDatumComparator comparator : comparators) {
            if (!comparator.toString().equals(compName)) continue;
            this.setSelectedItem(comparator);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            ImageDatumComparator comp = (ImageDatumComparator)e.getItem();
            this.images.setSort(comp);
            Prefs.put(ComparatorKey, comp.toString());
        }
    }

    private void setFixedSize() {
        Dimension size = this.getPreferredSize();
        this.setMinimumSize(size);
        this.setPreferredSize(size);
        this.setMaximumSize(size);
    }
}

