/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.folders;

import com.lightcrafts.ui.browser.folders.FolderTree;
import com.lightcrafts.ui.browser.folders.FolderTreeNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.prefs.Preferences;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

class FolderPathsSaver {
    private static final Preferences Prefs = Preferences.userNodeForPackage(FolderPathsSaver.class);
    private static final String PrefsKey = "BrowserTreePath";
    private static final TreeSelectionListener m_listener = new TreeSelectionListener(){

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            FolderPathsSaver.updatePath(e.getPath(), "");
        }
    };

    FolderPathsSaver() {
    }

    static void addToTree(JTree tree) {
        tree.addTreeSelectionListener(m_listener);
    }

    static void clearPath(String pathKey) {
        String name;
        int n = 0;
        do {
            String key;
            if ((name = Prefs.get(key = PrefsKey + pathKey + n++, null)) == null) continue;
            Prefs.remove(key);
        } while (name != null);
    }

    static TreePath getLatestPath(FolderTree tree) {
        return FolderPathsSaver.getLatestPath(tree, "");
    }

    static void removeFromTree(JTree tree) {
        tree.removeTreeSelectionListener(m_listener);
    }

    static void restorePath(FolderTree tree, String key) {
        TreePath path = FolderPathsSaver.getLatestPath(tree, key);
        if (path != null) {
            tree.setSelectionPath(path);
        }
    }

    static void savePath(FolderTree tree, String key) {
        TreePath path = tree.getSelectionPath();
        if (path != null) {
            FolderPathsSaver.updatePath(path, key);
        }
    }

    private static TreePath getLatestPath(FolderTree tree, String pathKey) {
        String name;
        LinkedList<String> names = new LinkedList<String>();
        int n = 0;
        do {
            if ((name = Prefs.get(PrefsKey + pathKey + n++, null)) == null) continue;
            names.addFirst(name);
        } while (name != null);
        if (names.isEmpty()) {
            return null;
        }
        ArrayList<FolderTreeNode> nodes = new ArrayList<FolderTreeNode>();
        FolderTreeNode node = tree.getRoot();
        Iterator i = names.iterator();
        if (!node.toString().equals(i.next())) {
            return null;
        }
        nodes.add(node);
        while (i.hasNext() && (node = node.getChildByName(name = (String)i.next())) != null) {
            nodes.add(node);
        }
        return new TreePath(nodes.toArray());
    }

    private static void updatePath(TreePath path, String pathKey) {
        int n = 0;
        String key = PrefsKey + pathKey;
        while (path != null) {
            FolderTreeNode node = (FolderTreeNode)path.getLastPathComponent();
            Prefs.put(key + n++, node.toString());
            path = path.getParentPath();
        }
        key = PrefsKey + pathKey + n++;
        while (Prefs.get(key, null) != null) {
            Prefs.remove(key);
            key = PrefsKey + pathKey + n++;
        }
    }
}

