/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.model;

import com.lightcrafts.image.metadata.CoreDirectory;
import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.metadata.ImageMetadataDirectory;
import com.lightcrafts.image.metadata.values.DateMetaValue;
import com.lightcrafts.image.metadata.values.StringMetaValue;
import com.lightcrafts.image.metadata.values.UnsignedLongMetaValue;
import com.lightcrafts.ui.browser.model.ImageDatum;
import com.lightcrafts.ui.browser.model.Thumbnailer;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.imageio.ImageIO;

class EggImage {
    private static final RenderedImage EggImage;
    private static final HashMap<Integer, RenderedImage> EggImages;

    EggImage() {
    }

    static RenderedImage getEggImage(int size) {
        Integer key = size;
        if (EggImages.containsKey(key)) {
            return EggImages.get(key);
        }
        RenderedImage egg = Thumbnailer.constrainImage(EggImage, size);
        EggImages.put(key, egg);
        return egg;
    }

    static ImageMetadata getEggMetadata(File file) {
        ImageMetadata meta = new ImageMetadata();
        ImageMetadataDirectory core = meta.getDirectoryFor(CoreDirectory.class, true);
        String path = file.getParent();
        if (path == null) {
            path = "";
        }
        StringMetaValue pathValue = new StringMetaValue(path);
        core.putValue(2, pathValue);
        String name = file.getName();
        StringMetaValue nameValue = new StringMetaValue(name);
        core.putValue(3, nameValue);
        long length = file.length();
        UnsignedLongMetaValue lengthValue = new UnsignedLongMetaValue(length);
        core.putValue(4, lengthValue);
        long time = file.lastModified();
        DateMetaValue timeValue = new DateMetaValue(time);
        core.putValue(1, timeValue);
        return meta;
    }

    static {
        try {
            EggImage = ImageIO.read(ImageDatum.class.getResource("resources/EggFrame.jpg"));
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't initialize EggImage", e);
        }
        int size = Math.max(EggImage.getWidth(), EggImage.getHeight());
        EggImages = new HashMap();
        EggImages.put(size, EggImage);
    }
}

