/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.model;

import com.lightcrafts.ui.browser.model.ImageDatum;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class ImageGroup {
    private List<ImageDatum> datums;
    private ImageDatum leader;

    public List<ImageDatum> getImageDatums() {
        return new LinkedList<ImageDatum>(this.datums);
    }

    public boolean isNonTrivial() {
        return this.datums.size() > 1;
    }

    ImageGroup(ImageDatum leader) {
        this.leader = leader;
        this.datums = new LinkedList<ImageDatum>();
        this.datums.add(leader);
    }

    void addImageDatum(ImageDatum datum) {
        this.datums.add(datum);
    }

    void removeImageDatum(ImageDatum datum) {
        this.datums.remove(datum);
        if (this.leader == datum) {
            this.leader = null;
        }
    }

    ImageDatum getLeader() {
        return this.leader;
    }

    public static boolean checkConsistency(Collection<ImageDatum> datums) {
        HashSet<ImageGroup> groups = new HashSet<ImageGroup>();
        for (ImageDatum datum : datums) {
            ImageGroup group = datum.getGroup();
            groups.add(group);
        }
        HashSet<ImageDatum> seen = new HashSet<ImageDatum>();
        for (ImageGroup group : groups) {
            List<ImageDatum> members = group.getImageDatums();
            for (ImageDatum member : members) {
                if (seen.contains(member)) {
                    System.err.println("ImageDatum in multiple ImageGroups");
                    return false;
                }
                if (!datums.contains(member)) {
                    System.err.println("Unexpected ImageDatum in ImageGroup");
                    return false;
                }
                seen.add(member);
            }
        }
        return true;
    }
}

