/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.model;

import com.lightcrafts.ui.browser.model.ImageTask;
import com.lightcrafts.ui.browser.model.ImageTaskQueueListener;
import java.awt.EventQueue;
import java.util.LinkedList;

public class ImageTaskQueue
implements Runnable {
    private LinkedList<ImageTask> queue;
    private Thread thread = new Thread((Runnable)this, "Image Task Queue");
    private boolean pause;
    private boolean stop;
    private LinkedList<ImageTaskQueueListener> listeners;

    public ImageTaskQueue() {
        this.thread.setPriority(1);
        this.queue = new LinkedList();
        this.listeners = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTask(ImageTask task) {
        LinkedList<ImageTask> linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.add(task);
            this.queue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTask(ImageTask task) {
        LinkedList<ImageTask> linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.remove(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAllTasks() {
        LinkedList<ImageTask> linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.clear();
        }
    }

    public void start() {
        if (!this.thread.isAlive()) {
            this.pause = false;
            this.stop = false;
            this.thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.pause = false;
        this.stop = true;
        Object object = this.queue;
        synchronized (object) {
            this.queue.notifyAll();
        }
        object = this.thread;
        synchronized (object) {
            this.thread.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Thread thread = this.thread;
        synchronized (thread) {
            this.pause = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Thread thread = this.thread;
        synchronized (thread) {
            if (this.pause) {
                this.pause = false;
                this.thread.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void raiseTask(ImageTask task) {
        LinkedList<ImageTask> linkedList = this.queue;
        synchronized (linkedList) {
            if (this.queue.contains(task)) {
                this.queue.remove(task);
                this.queue.addFirst(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lowerTask(ImageTask task) {
        LinkedList<ImageTask> linkedList = this.queue;
        synchronized (linkedList) {
            if (this.queue.contains(task)) {
                this.queue.remove(task);
                this.queue.addLast(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.stop) {
            Runnable task;
            Object object = this.queue;
            synchronized (object) {
                while (this.queue.isEmpty() && !this.stop) {
                    ImageTaskQueue.waitForNotify(this.queue);
                    if (!this.stop) continue;
                    return;
                }
                task = this.queue.removeFirst();
                this.logQueueSize();
            }
            try {
                task.run();
            }
            catch (Throwable t) {
                this.logTaskError(t);
            }
            object = this.thread;
            synchronized (object) {
                while (this.pause && !this.stop) {
                    ImageTaskQueue.waitForNotify(this.thread);
                }
            }
        }
    }

    void addListener(ImageTaskQueueListener listener) {
        this.listeners.add(listener);
    }

    void removeListener(ImageTaskQueueListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitForNotify(Object monitor) {
        Object object = monitor;
        synchronized (object) {
            boolean interrupted;
            do {
                try {
                    interrupted = false;
                    monitor.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            } while (interrupted);
        }
    }

    private void logQueueSize() {
        final int depth = this.queue.size();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (ImageTaskQueueListener listener : ImageTaskQueue.this.listeners) {
                    listener.queueDepthChanged(depth);
                }
            }
        });
    }

    private void logTaskError(Throwable t) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Abort ImageTask--");
        buffer.append(t.getClass().getName());
        if (t.getMessage() != null) {
            buffer.append(": ");
            buffer.append(t.getMessage());
        }
        System.err.println(buffer);
        t.printStackTrace();
    }
}

