/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.model;

import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.metadata.ImageOrientation;
import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.jai.utils.Functions;
import com.lightcrafts.mediax.jai.BorderExtender;
import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.Interpolation;
import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.mediax.jai.operator.TransposeDescriptor;
import com.lightcrafts.mediax.jai.operator.TransposeType;
import com.lightcrafts.ui.browser.model.ImageFileStrategy;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

class Thumbnailer {
    private static final Interpolation interpolation = Interpolation.getInstance((int)1);

    Thumbnailer() {
    }

    static RenderedImage getImage(File file, int maxImageSize) {
        return Thumbnailer.getImage(file, maxImageSize, true);
    }

    static RenderedImage getImage(File file, int maxImageSize, boolean colorConvert) {
        ImageFileStrategy strategy;
        ImageFileStrategy[] strategies;
        RenderedImage image = null;
        ImageInfo info = ImageInfo.getInstanceFor(file);
        ImageFileStrategy[] arr$ = strategies = ImageFileStrategy.Strategies;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (image = (strategy = arr$[i$]).getImage(info, maxImageSize)) == null; ++i$) {
        }
        if (image == null) {
            return null;
        }
        image = Thumbnailer.maybeRetile(image);
        if ((image = Thumbnailer.maybeBandSelect(image)).getWidth() > maxImageSize || image.getHeight() > maxImageSize) {
            image = Thumbnailer.constrainImage(image, maxImageSize);
        }
        if (colorConvert) {
            image = Thumbnailer.maybeConvertColors(image);
        }
        image = Thumbnailer.maybeConvertBitDepth(image);
        return image;
    }

    static RenderedImage constrainImage(RenderedImage image, int size) {
        float scaleFactor = Thumbnailer.scaleFactor(image, size);
        if (scaleFactor != 1.0f) {
            image = Thumbnailer.scaleImage(image, scaleFactor);
        }
        return image;
    }

    static RenderedImage rotate(RenderedImage image, ImageMetadata meta) {
        ImageOrientation orient;
        TransposeType transpose;
        if (meta != null && (transpose = (orient = meta.getOrientation()).getCorrection()) != null) {
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(image);
            pb.add(transpose);
            image = JAI.create((String)"Transpose", (ParameterBlock)pb, null);
        }
        return image;
    }

    static RenderedImage rotateNinetyTimes(RenderedImage image, int multiple) {
        TransposeType transpose;
        while (multiple < 0) {
            multiple += 4;
        }
        switch (multiple % 4) {
            case 1: {
                transpose = TransposeDescriptor.ROTATE_90;
                break;
            }
            case 2: {
                transpose = TransposeDescriptor.ROTATE_180;
                break;
            }
            case 3: {
                transpose = TransposeDescriptor.ROTATE_270;
                break;
            }
            default: {
                transpose = null;
            }
        }
        if (transpose != null) {
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(image);
            pb.add(transpose);
            image = JAI.create((String)"Transpose", (ParameterBlock)pb, null);
        }
        return image;
    }

    private static float scaleFactor(RenderedImage img, int xSize) {
        int ySize = Thumbnailer.heightFromWidth(xSize);
        int width = img.getWidth();
        int height = img.getHeight();
        if (width != xSize || height != ySize) {
            return Math.min((float)xSize / (float)width, (float)ySize / (float)height);
        }
        return 1.0f;
    }

    private static int heightFromWidth(int width) {
        return width;
    }

    private static PlanarImage scaleImage(RenderedImage source, float scale) {
        if (scale == 1.0f) {
            return PlanarImage.wrapRenderedImage((RenderedImage)source);
        }
        float scaleX = (float)Math.floor(scale * (float)source.getWidth()) / (float)source.getWidth();
        float scaleY = (float)Math.floor(scale * (float)source.getHeight()) / (float)source.getHeight();
        ParameterBlock params = new ParameterBlock();
        params.addSource(source);
        params.add(AffineTransform.getScaleInstance(scaleX, scaleY));
        params.add(interpolation);
        RenderingHints hints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
        return JAI.create((String)"Affine", (ParameterBlock)params, (RenderingHints)hints);
    }

    private static RenderedImage maybeRetile(RenderedImage image) {
        if (image instanceof BufferedImage && (image.getWidth() > 1024 || image.getHeight() > 1024)) {
            ColorModel colors = image.getColorModel();
            SampleModel samples = colors.createCompatibleSampleModel(512, 512);
            ImageLayout layout = new ImageLayout(0, 0, 512, 512, samples, colors);
            RenderingHints formatHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(image);
            pb.add(image.getSampleModel().getDataType());
            image = JAI.create((String)"Format", (ParameterBlock)pb, (RenderingHints)formatHints);
        }
        return image;
    }

    private static RenderedImage maybeBandSelect(RenderedImage image) {
        ColorModel colors = image.getColorModel();
        boolean hasAlpha = colors.hasAlpha();
        if (hasAlpha) {
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(image);
            if (image.getColorModel().getNumColorComponents() == 3) {
                pb.add(new int[]{0, 1, 2});
            } else {
                pb.add(new int[]{0});
            }
            image = JAI.create((String)"bandselect", (ParameterBlock)pb, null);
        }
        return image;
    }

    private static RenderedImage maybeConvertColors(RenderedImage image) {
        if (image.getColorModel().getColorSpace() != null && !image.getColorModel().getColorSpace().isCS_sRGB()) {
            image = Functions.toColorSpace(image, JAIContext.sRGBColorSpace, null);
        }
        return image;
    }

    private static RenderedImage maybeConvertBitDepth(RenderedImage image) {
        SampleModel sample = image.getSampleModel();
        int type = sample.getDataType();
        if (type == 1) {
            image = Functions.fromUShortToByte(image, null);
        }
        return image;
    }

    public static void main(String[] args) throws IOException {
        BufferedImage image = ImageIO.read(new File(args[0]));
        int size = 500;
        final RenderedImage thumb = Thumbnailer.constrainImage(image, size);
        JComponent comp = new JComponent(){

            @Override
            protected void paintComponent(Graphics graphics) {
                Graphics2D g = (Graphics2D)graphics;
                g.drawRenderedImage(thumb, new AffineTransform());
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(thumb.getWidth(), thumb.getHeight());
            }
        };
        Border line = BorderFactory.createLineBorder(Color.red);
        Border empty = BorderFactory.createEmptyBorder(20, 20, 20, 20);
        CompoundBorder compound = BorderFactory.createCompoundBorder(empty, line);
        JPanel container = new JPanel(new BorderLayout());
        container.add(comp);
        container.setBorder(compound);
        JPanel panel = new JPanel(new FlowLayout());
        panel.add(container);
        JFrame frame = new JFrame("Thumbnailer");
        frame.setContentPane(panel);
        frame.setSize(400, 400);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

