/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.view;

import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.browser.model.ImageDatum;
import com.lightcrafts.ui.browser.view.ImageBrowserEvent;
import com.lightcrafts.ui.browser.view.ImageBrowserListener;
import com.lightcrafts.ui.browser.view.Locale;
import java.awt.Font;
import java.io.File;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;

public class ImageBrowserFooter
extends Box
implements ImageBrowserListener {
    private JLabel lead = new JLabel();
    private JLabel all = new JLabel(Locale.LOCALE.get("NoImagesSelectedText"));
    private JLabel error = new JLabel();

    public ImageBrowserFooter() {
        super(0);
        Font font = this.lead.getFont();
        font = font.deriveFont(10.0f);
        this.lead.setFont(font);
        this.all.setFont(font);
        this.error.setFont(font);
        this.lead.setForeground(LightZoneSkin.Colors.ToolPanesForeground);
        this.all.setForeground(LightZoneSkin.Colors.ToolPanesForeground);
        this.error.setForeground(LightZoneSkin.Colors.ToolPanesForeground);
        this.lead.setAlignmentX(0.0f);
        this.all.setAlignmentX(0.5f);
        this.error.setAlignmentX(1.0f);
        this.add(this.lead);
        this.add(Box.createHorizontalGlue());
        this.add(this.error);
        this.add(Box.createHorizontalGlue());
        this.add(this.all);
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
    }

    @Override
    public void selectionChanged(ImageBrowserEvent event) {
        ImageDatum datum = event.getLead();
        File lead = datum != null ? datum.getFile() : null;
        List<File> files = event.getFiles();
        int count = event.getImageCount();
        this.setSelectedFiles(lead, files, count);
    }

    public void setSelectedFiles(File leadFile, List<File> files, int total) {
        File folder;
        if (leadFile != null) {
            String sizeText = ImageBrowserFooter.getSizeText(leadFile.length());
            this.lead.setText(leadFile.getName() + " (" + sizeText + ")");
        } else {
            this.lead.setText("");
        }
        long bytes = 0L;
        for (File file : files) {
            bytes += file.length();
        }
        String sizeText = ImageBrowserFooter.getSizeText(bytes);
        int size = files.size();
        if (size == 0) {
            if (total > 0) {
                if (total == 1) {
                    this.all.setText(Locale.LOCALE.get("SingleImageText"));
                } else {
                    this.all.setText(total + " " + Locale.LOCALE.get("MultipleImagesText"));
                }
            } else {
                this.all.setText(Locale.LOCALE.get("NoImagesText"));
            }
        } else if (size == total) {
            if (size == 1) {
                this.all.setText(Locale.LOCALE.get("SingleImageSelectedText") + " (" + sizeText + ")");
            } else {
                this.all.setText(size + " " + Locale.LOCALE.get("MultipleImagesSelectedText") + " (" + sizeText + ")");
            }
        } else {
            this.all.setText(size + " / " + total + " " + Locale.LOCALE.get("MultipleImagesSelectedText") + " (" + sizeText + ")");
        }
        String errorText = null;
        if (leadFile != null && !leadFile.canWrite()) {
            errorText = "\"" + leadFile.getName() + "\" " + Locale.LOCALE.get("ReadOnlyFileText");
        }
        if (errorText == null && files.size() > 0 && (folder = files.get(0).getParentFile()) != null && !folder.canWrite()) {
            errorText = "\"" + folder.getName() + "\" " + Locale.LOCALE.get("ReadOnlyFolderText");
        }
        this.error.setText(errorText);
    }

    @Override
    public void imageDoubleClicked(ImageBrowserEvent event) {
        this.error.setText("");
    }

    @Override
    public void browserError(String message) {
        this.error.setText(message);
    }

    private static String getSizeText(long bytes) {
        if (bytes > 0x40000000L) {
            return Long.toString(bytes >> 30) + "GB";
        }
        if (bytes > 0x100000L) {
            return Long.toString(bytes >> 20) + "MB";
        }
        if (bytes > 1024L) {
            return Long.toString(bytes >> 10) + "KB";
        }
        return Long.toString(bytes) + "B";
    }
}

