/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.view;

import com.lightcrafts.platform.Platform;
import com.lightcrafts.ui.browser.model.ImageDatum;
import com.lightcrafts.ui.browser.view.AbstractImageBrowser;
import com.lightcrafts.ui.browser.view.ImageBrowserSelectionModel;
import com.lightcrafts.ui.browser.view.ImageDatumControl;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Collections;
import javax.swing.event.MouseInputListener;

class ImageBrowserMouseListener
implements MouseInputListener {
    private AbstractImageBrowser browser;
    private ImageBrowserSelectionModel selection;
    private ImageDatumControl controller;

    ImageBrowserMouseListener(AbstractImageBrowser browser, ImageBrowserSelectionModel selection, ImageDatumControl controller) {
        this.browser = browser;
        this.selection = selection;
        this.controller = controller;
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        Point p;
        int index;
        ImageDatum datum;
        if (this.controller.isControllerEvent(event)) {
            this.controller.handleEvent(event);
        } else if (event.getClickCount() == 2 && (datum = this.browser.getImageDatum(index = this.browser.getIndex(p = event.getPoint()))) != null) {
            this.browser.notifyDoubleClicked(datum);
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.browser.requestFocusInWindow();
        if (this.controller.isControllerEvent(event)) {
            this.controller.handleEvent(event);
        } else {
            boolean isCtrlDown;
            Point p = event.getPoint();
            int index = this.browser.getIndex(p);
            if (index < 0) {
                this.selection.clearSelected();
                return;
            }
            ImageDatum datum = this.browser.getImageDatum(index);
            Rectangle bounds = this.browser.getBounds(index);
            this.browser.scrollRectToVisible(bounds);
            boolean bl = isCtrlDown = !ImageBrowserMouseListener.isMac() && event.isControlDown() || ImageBrowserMouseListener.isMac() && event.isMetaDown() && !event.isPopupTrigger();
            if (event.isShiftDown()) {
                this.browser.addContinuousSelected(datum, isCtrlDown);
            } else if (isCtrlDown) {
                if (this.selection.isSelected(datum)) {
                    this.selection.removeSelected(datum);
                } else {
                    this.selection.addSelected(datum);
                }
                this.selection.setLeadSelected(datum, false);
            } else if (event.isPopupTrigger() || ImageBrowserMouseListener.isWindows() && event.getButton() != 1) {
                if (!this.selection.isSelected(datum)) {
                    this.selection.setSelected(Collections.singletonList(datum));
                    this.selection.setLeadSelected(datum, false);
                }
            } else if (!this.selection.isSelected(datum)) {
                this.selection.setLeadSelected(datum, true);
            }
        }
        if (event.isPopupTrigger()) {
            this.browser.showPopup(event);
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (this.controller.isControllerEvent(event)) {
            this.controller.handleEvent(event);
        } else if (event.isPopupTrigger()) {
            this.browser.showPopup(event);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
        this.controller.setIndex(-1);
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        if (this.controller.isControllerEvent(event)) {
            this.controller.handleEvent(event);
        }
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        if (this.controller.isControllerEvent(event)) {
            this.controller.handleEvent(event);
        }
    }

    private static boolean isMac() {
        return Platform.getType() == Platform.MacOSX;
    }

    private static boolean isWindows() {
        return Platform.getType() == Platform.Windows;
    }
}

