/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.view;

import com.lightcrafts.ui.browser.model.ImageDatum;
import com.lightcrafts.ui.browser.view.AbstractImageBrowser;
import com.lightcrafts.ui.browser.view.ImageBrowserSelectionModel;
import com.lightcrafts.ui.browser.view.ImageDatumTransferable;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

class ImageBrowserTransferHandler
extends TransferHandler {
    private AbstractImageBrowser browser;
    private ImageBrowserSelectionModel selection;

    ImageBrowserTransferHandler(AbstractImageBrowser browser, ImageBrowserSelectionModel selection) {
        this.browser = browser;
        this.selection = selection;
    }

    DragGestureListener createDragInitiator() {
        return new DragInitiator();
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        List<ImageDatum> datums = this.selection.getSelected();
        return new ImageDatumTransferable(datums);
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        return false;
    }

    private Image createDragImage() {
        List<ImageDatum> datums = this.selection.getSelected();
        Rectangle bounds = new Rectangle();
        for (ImageDatum datum : datums) {
            Rectangle rect = this.browser.getBounds(datum);
            bounds.add(rect);
        }
        BufferedImage image = new BufferedImage(bounds.width, bounds.height, 6);
        Graphics2D g = (Graphics2D)image.getGraphics();
        AlphaComposite composite = AlphaComposite.getInstance(3, 0.5f);
        g.setComposite(composite);
        for (ImageDatum datum : datums) {
            Rectangle rect = this.browser.getBounds(datum);
            g.setClip(rect);
            this.browser.paintComponent(g);
        }
        return image;
    }

    class DragInitiator
    extends DragSourceAdapter
    implements DragGestureListener {
        DragInitiator() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent event) {
            if (ImageBrowserTransferHandler.this.selection.getSelected().isEmpty()) {
                return;
            }
            Transferable trans = ImageBrowserTransferHandler.this.createTransferable(null);
            if (DragSource.isDragImageSupported()) {
                Image image = ImageBrowserTransferHandler.this.createDragImage();
                Point origin = event.getDragOrigin();
                Point offset = new Point(-origin.x, -origin.y);
                event.startDrag(null, image, offset, trans, this);
            } else {
                event.startDrag(null, trans, this);
            }
        }
    }
}

