/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.view;

import com.lightcrafts.ui.LightZoneSkin;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;

class ImageDatumRatingRenderer {
    static Color TextColor = LightZoneSkin.Colors.BrowserLabelForeground;
    static Color BackColor = LightZoneSkin.Colors.BrowserImageTypeLabelBackground;
    static int HInset = 4;
    static int VInset = 28;
    static int ArcRadius = 8;
    static int StarSize = 12;
    static int TextStarGap = 2;
    static GeneralPath StarShape = new GeneralPath();

    ImageDatumRatingRenderer() {
    }

    static void paint(Graphics2D g, Rectangle2D rect, int rating) {
        String text = Integer.toString(rating);
        Point2D textOrigin = ImageDatumRatingRenderer.getTextOrigin(rect, g, text);
        FontMetrics metrics = g.getFontMetrics();
        Rectangle2D textBounds = metrics.getStringBounds(text, g);
        double x = textOrigin.getX();
        double y = textOrigin.getY();
        textBounds = new Rectangle2D.Double(x + textBounds.getX(), y + textBounds.getY(), textBounds.getWidth(), textBounds.getHeight());
        RoundRectangle2D.Double background = new RoundRectangle2D.Double(textBounds.getX() - (double)(ArcRadius / 2), textBounds.getY() - (double)(ArcRadius / 2), textBounds.getWidth() + (double)ArcRadius + (double)StarSize, textBounds.getHeight() + (double)ArcRadius, ArcRadius, ArcRadius);
        Color oldColor = g.getColor();
        g.setColor(BackColor);
        g.fill(background);
        g.setColor(TextColor);
        g.drawString(text, (float)x, (float)y);
        AffineTransform xform = AffineTransform.getTranslateInstance(textBounds.getX() + textBounds.getWidth() + (double)(StarSize / 2) + (double)TextStarGap, textBounds.getY() + textBounds.getHeight() / 2.0);
        Shape star = xform.createTransformedShape(StarShape);
        g.fill(star);
        g.setColor(oldColor);
    }

    private static Point2D getTextOrigin(Rectangle2D rect, Graphics2D g, String text) {
        Point2D ll = ImageDatumRatingRenderer.getLowerLeft(rect);
        FontMetrics metrics = g.getFontMetrics();
        Rectangle2D bounds = metrics.getStringBounds(text, g);
        double x = ll.getX() + bounds.getX();
        double y = ll.getY() - bounds.getHeight() - bounds.getY();
        return new Point2D.Double(x, y);
    }

    static Point2D getLowerLeft(Rectangle2D rect) {
        double x = rect.getX() + (double)HInset + (double)ArcRadius;
        double y = rect.getY() + rect.getHeight() - (double)VInset - (double)ArcRadius;
        return new Point2D.Double(x, y);
    }

    static {
        double bigRadius = 0.5 * (double)StarSize;
        double smallRadius = 0.2 * (double)StarSize;
        double angle = -1.5707963267948966;
        double x = bigRadius * Math.cos(angle);
        double y = bigRadius * Math.sin(angle);
        StarShape.moveTo((float)x, (float)y);
        for (int n = 1; n <= 5; ++n) {
            x = smallRadius * Math.cos(angle += 0.6283185307179586);
            y = smallRadius * Math.sin(angle);
            StarShape.lineTo((float)x, (float)y);
            x = bigRadius * Math.cos(angle += 0.6283185307179586);
            y = bigRadius * Math.sin(angle);
            StarShape.lineTo((float)x, (float)y);
        }
        StarShape.closePath();
    }
}

